/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.io.writecache;

import com.bigdata.counters.CounterSet;
import com.bigdata.ha.HAPipelineGlue;
import com.bigdata.ha.QuorumPipeline;
import com.bigdata.io.ChecksumUtility;
import com.bigdata.io.IBufferAccess;
import com.bigdata.io.IReopenChannel;
import com.bigdata.io.writecache.IBackingReader;
import com.bigdata.io.writecache.IWriteCache;
import com.bigdata.io.writecache.WriteCache;
import com.bigdata.io.writecache.WriteCacheServiceCounters;
import com.bigdata.quorum.Quorum;
import com.bigdata.quorum.QuorumMember;
import com.bigdata.util.ChecksumError;
import com.bigdata.util.DaemonThreadFactory;
import com.bigdata.util.InnerCause;
import com.bigdata.util.concurrent.Computable;
import com.bigdata.util.concurrent.Memoizer;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.Channel;
import java.util.LinkedList;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.log4j.Logger;

public abstract class WriteCacheService
implements IWriteCache {
    protected static final Logger log = Logger.getLogger(WriteCacheService.class);
    private static final Logger haLog = Logger.getLogger("com.bigdata.ha");
    private final AtomicBoolean open = new AtomicBoolean(true);
    private final boolean useChecksum;
    private final ExecutorService localWriteService;
    private Future<Void> localWriteFuture;
    private volatile Future<?> remoteWriteFuture = null;
    private final LinkedBlockingDeque<WriteCache> cleanList;
    private final ReentrantLock cleanListLock = new ReentrantLock();
    private final Condition cleanListNotEmpty = this.cleanListLock.newCondition();
    private final ReentrantReadWriteLock lock = new ReentrantReadWriteLock();
    private final BlockingQueue<WriteCache> dirtyList;
    private final ReentrantLock dirtyListLock = new ReentrantLock();
    private final Condition dirtyListEmpty = this.dirtyListLock.newCondition();
    private final Condition dirtyListChange = this.dirtyListLock.newCondition();
    private final AtomicReference<WriteCache> compactingCacheRef = new AtomicReference();
    private final AtomicReference<WriteCache> compactingReserveRef = new AtomicReference();
    private final boolean compactionEnabled;
    private final int compactionThreshold = 20;
    private final AtomicReference<WriteCache> current = new AtomicReference();
    private final AtomicReference<WriteCache.ReadCache> readCache = new AtomicReference();
    private volatile boolean halt = false;
    private final AtomicReference<Throwable> firstCause = new AtomicReference();
    private final int capacity;
    private final ConcurrentMap<Long, WriteCache> serviceMap;
    private final WriteCache[] writeBuffers;
    private final WriteCache.ReadCache[] readBuffers;
    private final long[] addrsUsed = null;
    private int addrsUsedCurs = 0;
    private final char[] addrActions = null;
    private final int[] addrLens = null;
    private final IBackingReader reader;
    private final AtomicLong fileExtent = new AtomicLong(-1L);
    private final Quorum<HAPipelineGlue, QuorumMember<HAPipelineGlue>> quorum;
    private final long quorumToken;
    private final int replicationFactor;
    private final AtomicLong cacheSequence = new AtomicLong(0L);
    private final int m_dirtyListThreshold;
    private final int readListSize;
    private final BlockingQueue<WriteCache.ReadCache> readList;
    private final int hotListSize;
    private final BlockingQueue<WriteCache.ReadCache> hotList;
    private WriteCache.ReadCache hotCache = null;
    private final int hotCacheThreshold;
    private WriteCache.ReadCache hotReserve = null;
    private volatile boolean flush = false;
    private volatile boolean directWrite = false;
    private static final Computable<LoadRecordRequest, ByteBuffer> loadChild = new Computable<LoadRecordRequest, ByteBuffer>(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public ByteBuffer compute(LoadRecordRequest req) throws InterruptedException {
            try {
                ByteBuffer ret = req.service._getRecord(req.offset, req.nbytes);
                if (ret != null && ret.remaining() == 0) {
                    throw new AssertionError();
                }
                ByteBuffer byteBuffer = ret;
                return byteBuffer;
            }
            finally {
                req.service.memo.removeFromCache(req);
            }
        }
    };
    private final ReadMemoizer memo;
    private final AtomicReference<WriteCacheServiceCounters> counters;

    protected Quorum<HAPipelineGlue, QuorumMember<HAPipelineGlue>> getQuorum() {
        return this.quorum;
    }

    public WriteCacheService(int nwriteBuffers, int minCleanListSize, int nreadBuffers, boolean prefixWrites, int compactionThreshold, int hotCacheSize, int hotCacheThreshold, boolean useChecksum, long fileExtent, IReopenChannel<? extends Channel> opener, Quorum quorum, IBackingReader reader) throws InterruptedException {
        int i;
        if (nwriteBuffers <= 0) {
            throw new IllegalArgumentException();
        }
        if (minCleanListSize == 0) {
            minCleanListSize = Math.max(4, (int)((double)nwriteBuffers * 0.003));
        }
        if (minCleanListSize > nwriteBuffers) {
            minCleanListSize = nwriteBuffers;
        }
        if (minCleanListSize < 0) {
            throw new IllegalArgumentException();
        }
        if (compactionThreshold <= 0) {
            throw new IllegalArgumentException();
        }
        if (compactionThreshold > 100) {
            throw new IllegalArgumentException();
        }
        if (fileExtent < 0L) {
            throw new IllegalArgumentException();
        }
        if (opener == null) {
            throw new IllegalArgumentException();
        }
        this.useChecksum = useChecksum;
        boolean bl = this.compactionEnabled = this.canCompact() && compactionThreshold < 100;
        if (log.isInfoEnabled()) {
            log.info("Compaction Enabled: " + this.compactionEnabled + " @ threshold=" + compactionThreshold);
        }
        if ((this.quorum = quorum) != null) {
            this.quorumToken = quorum.token();
            this.replicationFactor = quorum.replicationFactor();
        } else {
            this.quorumToken = -1L;
            this.replicationFactor = 1;
        }
        this.reader = reader;
        this.dirtyList = new LinkedBlockingQueue<WriteCache>();
        this.cleanList = new LinkedBlockingDeque();
        this.writeBuffers = new WriteCache[nwriteBuffers];
        this.m_dirtyListThreshold = this.compactionEnabled ? Math.max(1, nwriteBuffers - minCleanListSize - 2) : 1;
        assert (this.m_dirtyListThreshold >= 1);
        assert (this.m_dirtyListThreshold <= this.writeBuffers.length);
        this.readListSize = nreadBuffers;
        this.readList = new LinkedBlockingDeque<WriteCache.ReadCache>();
        this.readBuffers = new WriteCache.ReadCache[nreadBuffers];
        for (i = 0; i < this.readBuffers.length; ++i) {
            this.readBuffers[i] = new WriteCache.ReadCache(null);
        }
        this.hotListSize = (double)hotCacheSize < (double)this.readListSize * 0.8 && hotCacheSize > 2 ? hotCacheSize : 0;
        this.hotList = new LinkedBlockingDeque<WriteCache.ReadCache>();
        this.hotCacheThreshold = hotCacheThreshold;
        for (i = 0; i < this.hotListSize; ++i) {
            this.hotList.add(this.readBuffers[i]);
        }
        for (i = this.hotListSize; i < this.readListSize; ++i) {
            this.readList.add(this.readBuffers[i]);
        }
        this.hotCache = (WriteCache.ReadCache)this.hotList.poll();
        this.hotReserve = (WriteCache.ReadCache)this.hotList.poll();
        this.readCache.set((WriteCache.ReadCache)this.readList.poll());
        WriteCache.ReadCache curReadCache = this.readCache.get();
        if (curReadCache != null) {
            curReadCache.incrementReferenceCount();
        }
        if (log.isInfoEnabled()) {
            log.info("nbuffers=" + nwriteBuffers + ", dirtyListThreshold=" + this.m_dirtyListThreshold + ", compactionThreshold=" + compactionThreshold + ", compactionEnabled=" + this.compactionEnabled + ", prefixWrites=" + prefixWrites + ", hotListSize=" + this.hotListSize + ", useChecksum=" + useChecksum + ", quorum=" + quorum);
        }
        this.fileExtent.set(fileExtent);
        this.writeBuffers[0] = this.newWriteCache(null, useChecksum, false, opener, fileExtent);
        this.current.set(this.writeBuffers[0]);
        for (int i2 = 1; i2 < nwriteBuffers; ++i2) {
            WriteCache tmp;
            this.writeBuffers[i2] = tmp = this.newWriteCache(null, useChecksum, false, opener, fileExtent);
            this.cleanList.add(tmp);
        }
        WriteCacheServiceCounters counters = new WriteCacheServiceCounters(nwriteBuffers, this.m_dirtyListThreshold, compactionThreshold);
        for (int i3 = 0; i3 < this.writeBuffers.length; ++i3) {
            this.writeBuffers[i3].setCounters(counters);
        }
        this.counters = new AtomicReference<WriteCacheServiceCounters>(counters);
        this.capacity = this.current.get().capacity();
        this.serviceMap = new ConcurrentHashMap<Long, WriteCache>(nwriteBuffers * (this.capacity / 1024));
        this.memo = new ReadMemoizer(loadChild);
        this.localWriteService = Executors.newSingleThreadExecutor(new DaemonThreadFactory(this.getClass().getName()));
        this.localWriteFuture = this.localWriteService.submit(this.newWriteTask());
    }

    protected boolean canCompact() {
        return false;
    }

    public long resetSequence() {
        return this.cacheSequence.getAndSet(0L);
    }

    public long getSequence() {
        return this.cacheSequence.get();
    }

    protected Callable<Void> newWriteTask() {
        return new WriteTask();
    }

    public abstract WriteCache newWriteCache(IBufferAccess var1, boolean var2, boolean var3, IReopenChannel<? extends Channel> var4, long var5) throws InterruptedException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void reset() throws InterruptedException {
        ReentrantReadWriteLock.WriteLock writeLock = this.lock.writeLock();
        writeLock.lockInterruptibly();
        try {
            if (!this.open.get()) {
                throw new IllegalStateException(this.firstCause.get());
            }
            this.localWriteFuture.cancel(true);
            Future<?> rwf = this.remoteWriteFuture;
            if (rwf != null) {
                try {
                    rwf.cancel(true);
                }
                catch (Throwable t) {
                    log.warn(t, t);
                }
            }
            this.drainAndResetDirtyList();
            try {
                this.localWriteFuture.get();
            }
            catch (Throwable t) {
                this.drainAndResetDirtyList();
                this.dirtyListLock.lockInterruptibly();
                try {
                    if (!this.dirtyList.isEmpty()) {
                        throw new AssertionError();
                    }
                }
                finally {
                    this.dirtyListLock.unlock();
                }
                if (this.compactingCacheRef.get() != null) {
                    throw new AssertionError();
                }
                this.cleanListLock.lockInterruptibly();
                try {
                    if (this.writeBuffers.length > 1 && this.cleanList.isEmpty()) {
                        throw new AssertionError();
                    }
                }
                finally {
                    this.cleanListLock.unlock();
                }
            }
            finally {
                this.drainAndResetDirtyList();
                this.dirtyListLock.lockInterruptibly();
                try {
                    if (!this.dirtyList.isEmpty()) {
                        throw new AssertionError();
                    }
                }
                finally {
                    this.dirtyListLock.unlock();
                }
                if (this.compactingCacheRef.get() != null) {
                    throw new AssertionError();
                }
                this.cleanListLock.lockInterruptibly();
                try {
                    if (this.writeBuffers.length > 1 && this.cleanList.isEmpty()) {
                        throw new AssertionError();
                    }
                }
                finally {
                    this.cleanListLock.unlock();
                }
            }
            WriteCache x = this.current.get();
            if (x != null) {
                x.resetWith(this.serviceMap);
            } else {
                WriteCache t = this.cleanList.poll();
                if (t == null) {
                    throw new AssertionError();
                }
                if (!this.current.compareAndSet(null, t)) {
                    throw new AssertionError();
                }
            }
            WriteCacheServiceCounters c = this.counters.get();
            c.ndirty = 0;
            c.nclean = this.writeBuffers.length - 1;
            ++c.nreset;
            this.resetSequence();
            this.localWriteFuture = this.localWriteService.submit(this.newWriteTask());
            this.remoteWriteFuture = null;
            this.fileExtent.set(-1L);
            ++this.counters.get().nreset;
            this.flush = false;
        }
        finally {
            writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resetAndClear() throws InterruptedException {
        ReentrantReadWriteLock.WriteLock writeLock = this.lock.writeLock();
        writeLock.lockInterruptibly();
        try {
            this.reset();
            this.serviceMap.clear();
            for (WriteCache t : this.writeBuffers) {
                t.reset();
            }
        }
        finally {
            writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void drainAndResetDirtyList() throws InterruptedException {
        LinkedList c = new LinkedList();
        this.dirtyListLock.lockInterruptibly();
        try {
            this.dirtyList.drainTo(c);
            this.dirtyListEmpty.signalAll();
            this.dirtyListChange.signalAll();
        }
        finally {
            this.dirtyListLock.unlock();
        }
        this.cleanListLock.lockInterruptibly();
        try {
            for (WriteCache x : c) {
                x.resetWith(this.serviceMap);
                this.cleanList.addFirst(x);
            }
            assert (!this.cleanList.isEmpty());
            this.cleanListNotEmpty.signalAll();
            this.counters.get().nclean = this.cleanList.size();
        }
        finally {
            this.cleanListLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        if (!this.open.compareAndSet(true, false)) {
            return;
        }
        if (this.firstCause.compareAndSet(null, new AsynchronousCloseException())) {
            this.halt = true;
        }
        this.localWriteFuture.cancel(true);
        Future<?> rwf = this.remoteWriteFuture;
        if (rwf != null) {
            try {
                rwf.cancel(true);
            }
            catch (Throwable t) {
                log.warn(t, t);
            }
        }
        this.localWriteService.shutdownNow();
        boolean interrupted = false;
        this.dirtyListLock.lock();
        try {
            this.dirtyList.drainTo(new LinkedList());
            this.dirtyListEmpty.signalAll();
            this.dirtyListChange.signalAll();
        }
        finally {
            this.dirtyListLock.unlock();
        }
        this.cleanListLock.lock();
        try {
            this.cleanList.drainTo(new LinkedList());
        }
        finally {
            this.cleanListLock.unlock();
        }
        ReentrantReadWriteLock.WriteLock writeLock = this.lock.writeLock();
        writeLock.lock();
        try {
            for (WriteCache writeCache : this.writeBuffers) {
                try {
                    writeCache.close();
                }
                catch (InterruptedException ex) {
                    interrupted = true;
                }
            }
            for (WriteCache writeCache : this.readBuffers) {
                try {
                    writeCache.close();
                }
                catch (InterruptedException ex) {
                    interrupted = true;
                }
            }
            this.current.getAndSet(null);
            this.compactingCacheRef.getAndSet(null);
            this.readCache.getAndSet(null);
            AtomicReference<WriteCache.ReadCache> atomicReference = this.readCache;
            synchronized (atomicReference) {
                this.hotCache = null;
                this.hotReserve = null;
            }
            this.serviceMap.clear();
            this.fileExtent.set(-1L);
            if (interrupted) {
                Thread.currentThread().interrupt();
            }
        }
        finally {
            writeLock.unlock();
        }
        if (log.isInfoEnabled()) {
            log.info(this.counters.get().toString());
        }
    }

    protected void finalized() throws Throwable {
        this.close();
    }

    private void assertOpenForWriter() {
        if (!this.open.get()) {
            throw new IllegalStateException(this.firstCause.get());
        }
        if (this.halt) {
            throw new RuntimeException(this.firstCause.get());
        }
        if (this.localWriteFuture.isDone()) {
            try {
                this.localWriteFuture.get();
            }
            catch (Throwable t) {
                throw new RuntimeException(t);
            }
        }
    }

    private WriteCache acquireForWriter() throws InterruptedException, IllegalStateException {
        ReentrantReadWriteLock.ReadLock readLock = this.lock.readLock();
        readLock.lockInterruptibly();
        try {
            this.assertOpenForWriter();
            WriteCache tmp = this.current.get();
            if (tmp == null) {
                throw new RuntimeException();
            }
            return tmp;
        }
        catch (Throwable t) {
            readLock.unlock();
            if (t instanceof InterruptedException) {
                throw (InterruptedException)t;
            }
            if (t instanceof IllegalStateException) {
                throw (IllegalStateException)t;
            }
            throw new RuntimeException(t);
        }
    }

    private void release() {
        this.lock.readLock().unlock();
    }

    @Override
    public void flush(boolean force) throws InterruptedException {
        try {
            if (!this.flush(force, Long.MAX_VALUE, TimeUnit.NANOSECONDS)) {
                throw new RuntimeException();
            }
        }
        catch (TimeoutException e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean flush(boolean force, long timeout, TimeUnit units) throws TimeoutException, InterruptedException {
        long nanos;
        if (haLog.isInfoEnabled()) {
            haLog.info("Flushing the write cache: seq=" + this.cacheSequence);
        }
        long begin = System.nanoTime();
        long remaining = nanos = units.toNanos(timeout);
        ReentrantReadWriteLock.WriteLock writeLock = this.lock.writeLock();
        if (!writeLock.tryLock(remaining, TimeUnit.NANOSECONDS)) {
            throw new TimeoutException();
        }
        try {
            WriteCache tmp = this.current.getAndSet(null);
            remaining = nanos - (System.nanoTime() - begin);
            if (!this.dirtyListLock.tryLock(remaining, TimeUnit.NANOSECONDS)) {
                throw new TimeoutException();
            }
            try {
                this.flush = true;
                this.dirtyList.add(tmp);
                ++this.counters.get().ndirty;
                this.dirtyListChange.signalAll();
                while (!this.dirtyList.isEmpty() && !this.halt) {
                    remaining = nanos - (System.nanoTime() - begin);
                    if (this.dirtyListEmpty.await(remaining, TimeUnit.NANOSECONDS)) continue;
                    throw new TimeoutException();
                }
                WriteCache tmp2 = this.compactingCacheRef.getAndSet(null);
                if (tmp2 != null) {
                    this.directWrite = true;
                    try {
                        if (log.isInfoEnabled()) {
                            log.info("Adding compacting cache");
                        }
                        this.dirtyList.add(tmp2);
                        ++this.counters.get().ndirty;
                        this.dirtyListChange.signalAll();
                        while (!this.dirtyList.isEmpty() && !this.halt) {
                            remaining = nanos - (System.nanoTime() - begin);
                            if (this.dirtyListEmpty.await(remaining, TimeUnit.NANOSECONDS)) continue;
                            throw new TimeoutException();
                        }
                    }
                    finally {
                        this.directWrite = false;
                    }
                }
                if (this.halt) {
                    throw new RuntimeException(this.firstCause.get());
                }
            }
            finally {
                this.flush = false;
                try {
                    if (!this.halt) {
                        assert (this.dirtyList.size() == 0);
                        assert (this.compactingCacheRef.get() == null);
                        assert (this.current.get() == null);
                    }
                }
                finally {
                    this.dirtyListLock.unlock();
                }
            }
            remaining = nanos - (System.nanoTime() - begin);
            if (!this.cleanListLock.tryLock(remaining, TimeUnit.NANOSECONDS)) {
                throw new TimeoutException();
            }
            try {
                while (this.cleanList.isEmpty() && !this.halt) {
                    remaining = nanos - (System.nanoTime() - begin);
                    if (!this.cleanListNotEmpty.await(remaining, TimeUnit.NANOSECONDS)) {
                        throw new TimeoutException();
                    }
                    if (!this.halt) continue;
                    throw new RuntimeException(this.firstCause.get());
                }
                WriteCache nxt = this.cleanList.take();
                --this.counters.get().nclean;
                nxt.resetWith(this.serviceMap);
                this.current.set(nxt);
                if (haLog.isInfoEnabled()) {
                    haLog.info("Flushed the write cache: seq=" + this.cacheSequence);
                }
                boolean bl = true;
                this.cleanListLock.unlock();
                return bl;
            }
            catch (Throwable throwable) {
                this.cleanListLock.unlock();
                throw throwable;
            }
        }
        finally {
            writeLock.unlock();
        }
    }

    public void setExtent(long fileExtent) throws IllegalStateException, InterruptedException {
        if (fileExtent < 0L) {
            throw new IllegalArgumentException();
        }
        if (log.isDebugEnabled()) {
            log.debug("Set fileExtent: " + fileExtent);
        }
        this.fileExtent.set(fileExtent);
    }

    @Override
    public boolean write(long offset, ByteBuffer data, int chk) throws InterruptedException, IllegalStateException {
        return this.write(offset, data, chk, this.useChecksum, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean write(long offset, ByteBuffer data, int chk, boolean useChecksum, int latchedAddr) throws InterruptedException, IllegalStateException {
        boolean bl;
        long begin = System.nanoTime();
        try {
            bl = this.write_timed(offset, data, chk, useChecksum, latchedAddr);
        }
        catch (Throwable throwable) {
            long elapsed = System.nanoTime() - begin;
            WriteCacheServiceCounters c = this.counters.get();
            ++c.ncacheWrites;
            c.elapsedCacheWriteNanos += elapsed;
            throw throwable;
        }
        long elapsed = System.nanoTime() - begin;
        WriteCacheServiceCounters c = this.counters.get();
        ++c.ncacheWrites;
        c.elapsedCacheWriteNanos += elapsed;
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean write_timed(long offset, ByteBuffer data, int chk, boolean useChecksum, int latchedAddr) throws InterruptedException, IllegalStateException {
        if (log.isTraceEnabled()) {
            log.trace("offset: " + offset + ", length: " + data.limit() + ", chk=" + chk + ", useChecksum=" + useChecksum);
        }
        if (!this.open.get()) {
            throw new IllegalStateException(this.firstCause.get());
        }
        if (offset < 0L) {
            throw new IllegalArgumentException();
        }
        if (data == null) {
            throw new IllegalArgumentException("Buffer is null");
        }
        int remaining = data.remaining();
        int nwrite = remaining + (useChecksum ? 4 : 0);
        if (remaining == 0) {
            throw new IllegalArgumentException("Zero bytes remaining in buffer");
        }
        if (nwrite > this.capacity) {
            return this.writeLargeRecord(offset, data, chk, useChecksum);
        }
        WriteCache cache = this.acquireForWriter();
        try {
            this.debugAddrs(offset, data.remaining(), 'A');
            if (cache.write(offset, data, chk, useChecksum, latchedAddr)) {
                WriteCache old = this.serviceMap.put(offset, cache);
                if (old == cache) {
                    throw new AssertionError((Object)("Record already in cache: offset=" + offset + " " + this.addrDebugInfo(offset)));
                }
                boolean bl = true;
                return bl;
            }
        }
        finally {
            this.release();
        }
        ReentrantReadWriteLock.WriteLock writeLock = this.lock.writeLock();
        writeLock.lockInterruptibly();
        try {
            WriteCache cache2 = this.acquireForWriter();
            if (cache2.write(offset, data, chk, useChecksum, latchedAddr)) {
                if (this.serviceMap.put(offset, cache2) != null) {
                    throw new AssertionError((Object)("Record already in cache: offset=" + offset + " " + this.addrDebugInfo(offset)));
                }
                boolean bl = true;
                return bl;
            }
            if (!this.current.compareAndSet(cache2, null)) {
                throw new AssertionError();
            }
            this.dirtyListLock.lockInterruptibly();
            try {
                this.dirtyList.add(cache2);
                this.dirtyListChange.signalAll();
            }
            finally {
                this.dirtyListLock.unlock();
            }
            WriteCache newBuffer = this.takeFromClean();
            --this.counters.get().nclean;
            newBuffer.resetWith(this.serviceMap);
            cache2 = newBuffer;
            this.current.set(cache2);
            if (!cache2.write(offset, data, chk, useChecksum, latchedAddr)) throw new AssertionError((Object)("Unable to write into current WriteCache " + offset + " " + this.addrDebugInfo(offset)));
            if (this.serviceMap.put(offset, cache2) != null) {
                throw new AssertionError((Object)("Record already in cache: offset=" + offset + " " + this.addrDebugInfo(offset)));
            }
            boolean bl = true;
            return bl;
            finally {
                this.release();
            }
        }
        finally {
            writeLock.unlock();
        }
    }

    private WriteCache takeFromClean() throws InterruptedException {
        this.cleanListLock.lockInterruptibly();
        try {
            while (true) {
                if (log.isInfoEnabled() && this.cleanList.isEmpty()) {
                    log.info("Waiting for clean buffer");
                }
                while (this.cleanList.isEmpty() && !this.halt) {
                    this.cleanListNotEmpty.await();
                }
                if (this.halt) {
                    throw new RuntimeException(this.firstCause.get());
                }
                WriteCache ret = this.cleanList.poll();
                if (ret == null) continue;
                WriteCache writeCache = ret;
                return writeCache;
            }
        }
        finally {
            this.cleanListLock.unlock();
        }
    }

    public void debugAddrs(long offset, int length, char c) {
        if (this.addrsUsed != null) {
            this.addrsUsed[this.addrsUsedCurs] = offset;
            this.addrActions[this.addrsUsedCurs] = c;
            this.addrLens[this.addrsUsedCurs] = length;
            ++this.addrsUsedCurs;
            if (this.addrsUsedCurs >= this.addrsUsed.length) {
                this.addrsUsedCurs = 0;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean writeLargeRecord(long offset, ByteBuffer data, int chk, boolean useChecksum) throws InterruptedException, IllegalStateException {
        if (log.isTraceEnabled()) {
            log.trace("offset: " + offset + ", length: " + data.limit() + ", chk=" + chk + ", useChecksum=" + useChecksum);
        }
        if (offset < 0L) {
            throw new IllegalArgumentException();
        }
        if (data == null) {
            throw new IllegalArgumentException("Buffer is null");
        }
        int remaining = data.remaining();
        if (remaining == 0) {
            throw new IllegalArgumentException("Zero bytes remaining in buffer");
        }
        if (remaining < this.capacity) {
            throw new AssertionError();
        }
        ReentrantReadWriteLock.WriteLock writeLock = this.lock.writeLock();
        writeLock.lockInterruptibly();
        try {
            WriteCache cache;
            int p = 0;
            int r = remaining;
            while (r > 0) {
                cache = this.acquireForWriter();
                try {
                    int ncpy = Math.min(r, cache.remaining());
                    if (ncpy > 0) {
                        ByteBuffer tmp = data.duplicate();
                        tmp.limit(p + ncpy);
                        tmp.position(p);
                        if (!cache.write(offset + (long)p, tmp, chk, false, 0)) {
                            throw new AssertionError();
                        }
                        r -= ncpy;
                        p += ncpy;
                    }
                    if (cache.remaining() != 0) continue;
                    this.moveBufferToDirtyList();
                }
                finally {
                    this.release();
                }
            }
            if (useChecksum) {
                cache = this.acquireForWriter();
                try {
                    ByteBuffer t = ByteBuffer.allocate(4);
                    t.putInt(chk);
                    t.flip();
                    if (!cache.write(offset + (long)p, t, chk, false, 0)) {
                        throw new AssertionError();
                    }
                }
                finally {
                    this.release();
                }
            }
            cache = this.acquireForWriter();
            try {
                if (!cache.isEmpty()) {
                    this.moveBufferToDirtyList();
                }
            }
            finally {
                this.release();
            }
            if (log.isTraceEnabled()) {
                log.trace("FLUSHING LARGE RECORD");
            }
            this.flush(false);
            boolean bl = true;
            return bl;
        }
        finally {
            writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private WriteCache moveBufferToDirtyList() throws InterruptedException {
        if (!this.lock.isWriteLockedByCurrentThread()) {
            throw new IllegalMonitorStateException();
        }
        WriteCache cache = this.current.getAndSet(null);
        assert (cache != null);
        this.dirtyListLock.lockInterruptibly();
        try {
            this.dirtyList.add(cache);
            this.dirtyListChange.signalAll();
        }
        finally {
            this.dirtyListLock.unlock();
        }
        this.cleanListLock.lockInterruptibly();
        try {
            while (this.cleanList.isEmpty() && !this.halt) {
                this.cleanListNotEmpty.await();
            }
            if (this.halt) {
                throw new RuntimeException(this.firstCause.get());
            }
            WriteCache newBuffer = this.cleanList.take();
            --this.counters.get().nclean;
            newBuffer.resetWith(this.serviceMap);
            this.current.set(newBuffer);
            WriteCache writeCache = newBuffer;
            return writeCache;
        }
        finally {
            this.cleanListLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addClean(WriteCache cache, boolean addFirst) throws InterruptedException {
        if (cache == null) {
            throw new IllegalArgumentException();
        }
        if (this.readListSize > 0) {
            this.installReads(cache);
        } else {
            cache.resetWith(this.serviceMap);
        }
        this.cleanListLock.lockInterruptibly();
        try {
            assert (cache.isEmpty() || cache.isClosedForWrites());
            if (addFirst) {
                this.cleanList.addFirst(cache);
            } else {
                this.cleanList.addLast(cache);
            }
            this.cleanListNotEmpty.signalAll();
            this.counters.get().nclean = this.cleanList.size();
        }
        finally {
            this.cleanListLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean installReads(WriteCache cache) throws InterruptedException {
        if (this.readListSize == 0) {
            return false;
        }
        AtomicReference<WriteCache.ReadCache> atomicReference = this.readCache;
        synchronized (atomicReference) {
            WriteCache.ReadCache rcache = this.readCache.get();
            if (!WriteCache.transferTo(cache, rcache, this.serviceMap, 0)) {
                WriteCache.ReadCache ncache;
                this.readCache.set(null);
                if (rcache.decrementReferenceCount() == 0) {
                    this.readList.add(rcache);
                }
                if ((ncache = this.getDirectReadCache()) == null) {
                    throw new AssertionError();
                }
                if (ncache.remaining() < ncache.capacity()) {
                    throw new AssertionError((Object)("New Cache, remaining() < capacity(): " + ncache.remaining() + " < " + ncache.capacity()));
                }
                if (!WriteCache.transferTo(cache, ncache, this.serviceMap, 0)) {
                    throw new AssertionError((Object)("Unable to complete transfer to new cache with remaining: " + ncache.remaining()));
                }
                ncache.incrementReferenceCount();
                this.readCache.set(ncache);
            }
        }
        return true;
    }

    private WriteCache getDirectCleanCache() throws InterruptedException {
        WriteCache tmp = this.cleanList.poll();
        if (tmp != null) {
            --this.counters.get().nclean;
        }
        return tmp;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private WriteCache.ReadCache getDirectReadCache() throws InterruptedException {
        WriteCache.ReadCache tmp = (WriteCache.ReadCache)this.readList.poll();
        if (tmp == null) {
            return null;
        }
        try {
            AtomicReference<WriteCache.ReadCache> atomicReference = this.readCache;
            synchronized (atomicReference) {
                if (this.hotCache == null) {
                    tmp.resetWith(this.serviceMap);
                    return tmp;
                }
                int cycles = 0;
                while (tmp != null) {
                    if (log.isDebugEnabled() && !tmp.isEmpty()) {
                        int hitRecords = 0;
                        int hotRecords = 0;
                        int totalRecords = 0;
                        for (WriteCache.RecordMetadata md : tmp.recordMap.values()) {
                            ++totalRecords;
                            if (md.getHitCount() <= 0) continue;
                            ++hitRecords;
                            if (md.getHitCount() <= this.hotCacheThreshold) continue;
                            ++hotRecords;
                        }
                        log.debug("Recycled ReadCache, hot(>" + this.hotCacheThreshold + "): " + hotRecords + ", hit: " + hitRecords + " of " + totalRecords);
                    }
                    if (WriteCache.transferTo(tmp, this.hotCache, this.serviceMap, this.hotCacheThreshold)) {
                        if (!tmp.isEmpty()) {
                            throw new AssertionError();
                        }
                        tmp.reset();
                        break;
                    }
                    if (log.isDebugEnabled()) {
                        log.debug("Cycle HOTCACHE: " + ++cycles);
                    }
                    this.hotList.add(this.hotCache);
                    this.readList.add(((WriteCache.ReadCache)this.hotList.poll()).resetHitCounts());
                    if (!this.hotReserve.isEmpty()) {
                        throw new AssertionError();
                    }
                    this.hotCache = this.hotReserve;
                    this.hotReserve = null;
                    if (!WriteCache.transferTo(tmp, this.hotCache, this.serviceMap, this.hotCacheThreshold)) {
                        throw new AssertionError();
                    }
                    tmp.reset();
                    this.hotReserve = tmp;
                    tmp = (WriteCache.ReadCache)this.readList.poll();
                }
            }
        }
        catch (InterruptedException ex) {
            this.readList.put(tmp);
            Thread.currentThread().interrupt();
            return null;
        }
        return tmp;
    }

    @Override
    public ByteBuffer read(long offset, int nbytes) throws InterruptedException, ChecksumError {
        ByteBuffer tmp = this._readFromCache(offset, nbytes);
        if (tmp != null) {
            if (tmp.remaining() == 0) {
                throw new AssertionError();
            }
            return tmp;
        }
        this.counters.get().nmiss.increment();
        if (this.reader != null) {
            ByteBuffer ret = this.loadRecord(offset, nbytes);
            if (ret != null && ret.remaining() == 0) {
                throw new AssertionError();
            }
            return ret;
        }
        return null;
    }

    /*
     * Exception decompiling
     */
    public ByteBuffer _readFromCache(long offset, int nbytes) throws ChecksumError, InterruptedException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [2[DOLOOP]], but top level block is 0[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private ByteBuffer loadRecord(long offset, int nbytes) {
        try {
            this.counters.get().memoCacheSize.set(this.memo.size());
            ByteBuffer ret = (ByteBuffer)this.memo.compute(new LoadRecordRequest(this, offset, nbytes));
            return ret.duplicate();
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ByteBuffer _getRecord(long offset, int nbytes) throws IllegalStateException, InterruptedException {
        boolean directRead;
        ByteBuffer tmp = this._readFromCache(offset, nbytes);
        if (tmp != null) {
            if (tmp.remaining() == 0) {
                throw new AssertionError();
            }
            return tmp;
        }
        boolean largeRecord = nbytes > this.capacity;
        boolean bl = directRead = largeRecord || this.readListSize == 0;
        if (directRead) {
            ByteBuffer ret = this._readFromLocalDiskIntoNewHeapByteBuffer(offset, nbytes);
            if (ret != null && ret.remaining() == 0) {
                throw new AssertionError();
            }
            return ret;
        }
        WriteCache theCache = null;
        ByteBuffer bb = null;
        boolean willInstall = false;
        try {
            Object object = this.readCache;
            synchronized (object) {
                theCache = this.readCache.get();
                if (theCache != null) {
                    assert (theCache.getReferenceCount() > 0);
                    bb = theCache.allocate(nbytes);
                    if (bb != null) {
                        theCache.incrementReferenceCount();
                        willInstall = true;
                    } else {
                        this.readCache.set(null);
                        if (theCache.decrementReferenceCount() == 0) {
                            this.readList.add((WriteCache.ReadCache)theCache);
                        }
                    }
                }
                if (bb == null) {
                    assert (this.readCache.get() == null);
                    WriteCache.ReadCache newCache = this.getDirectReadCache();
                    if (newCache != null) {
                        assert (newCache.getReferenceCount() == 0);
                        newCache.incrementReferenceCount();
                        this.readCache.set(newCache);
                        bb = newCache.allocate(nbytes);
                        theCache = newCache;
                        theCache.incrementReferenceCount();
                        willInstall = true;
                    }
                }
            }
            if (bb == null) {
                assert (!willInstall);
                object = this._readFromLocalDiskIntoNewHeapByteBuffer(offset, nbytes);
                return object;
            }
            int pos = bb.position();
            ByteBuffer ret = this.reader.readRaw(offset, bb);
            byte[] b = new byte[nbytes - 4];
            ret.get(b);
            int datalen = nbytes - 4;
            int chk = ret.getInt(pos + datalen);
            if (chk != ChecksumUtility.threadChk.get().checksum(b, 0, datalen)) {
                throw new ChecksumError();
            }
            theCache.commitToMap(offset, pos, nbytes);
            this.serviceMap.put(offset, theCache);
            ByteBuffer byteBuffer = ByteBuffer.wrap(b);
            return byteBuffer;
        }
        catch (Throwable t) {
            t.printStackTrace(System.err);
            throw new RuntimeException(t);
        }
        finally {
            if (willInstall && theCache.decrementReferenceCount() == 0) {
                this.readList.add((WriteCache.ReadCache)theCache);
                if (theCache == this.readCache.get()) {
                    throw new AssertionError();
                }
            }
        }
    }

    private final ByteBuffer _readFromLocalDiskIntoNewHeapByteBuffer(long offset, int nbytes) {
        int tstchk;
        if (log.isDebugEnabled()) {
            log.debug("Allocating direct, nbytes: " + nbytes);
        }
        ByteBuffer ret = this.reader.readRaw(offset, ByteBuffer.allocate(nbytes));
        int chk = ChecksumUtility.getCHK().checksum(ret.array(), 0, nbytes - 4);
        if (chk != (tstchk = ret.getInt(nbytes - 4))) {
            throw new ChecksumError("offset=" + offset + ",nbytes=" + nbytes + ",expected=" + tstchk + ",actual=" + chk);
        }
        ret.limit(nbytes - 4);
        if (ret.remaining() == 0) {
            throw new AssertionError();
        }
        this.counters.get().nreadNotInstalled.increment();
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean clearWrite(long offset, int latchedAddr) {
        try {
            ++this.counters.get().nclearAddrRequests;
            while (true) {
                WriteCache cache;
                if ((cache = (WriteCache)this.serviceMap.get(offset)) == null) {
                    return false;
                }
                cache.transferLock.lock();
                try {
                    WriteCache oldValue;
                    WriteCache cache2 = (WriteCache)this.serviceMap.get(offset);
                    if (cache2 != cache || (oldValue = (WriteCache)this.serviceMap.remove(offset)) == null) continue;
                    if (oldValue != cache) {
                        throw new AssertionError((Object)("oldValue=" + oldValue + ", cache=" + cache + ", offset=" + offset + ", latchedAddr=" + latchedAddr));
                    }
                    if (!cache.clearAddrMap(offset, latchedAddr)) continue;
                    ++this.counters.get().nclearAddrCleared;
                    this.debugAddrs(offset, 0, 'F');
                    boolean bl = true;
                    return bl;
                }
                finally {
                    cache.transferLock.unlock();
                    continue;
                }
                break;
            }
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
    }

    public String addrDebugInfo(long paddr) {
        if (this.addrsUsed == null) {
            return "No WriteCache debug info";
        }
        StringBuffer ret = new StringBuffer();
        for (int i = 0; i < this.addrsUsed.length; ++i) {
            if (i == this.addrsUsedCurs) {
                ret.append("|...|");
            }
            if (this.addrsUsed[i] != paddr) continue;
            ret.append(this.addrActions[i]);
            if (this.addrActions[i] != 'A') continue;
            ret.append("[" + this.addrLens[i] + "]");
        }
        ret.append(":");
        ret.append(this.getCounters().toString());
        return ret.toString();
    }

    public boolean isPresent(long addr) {
        return this.serviceMap.get(addr) != null;
    }

    public CounterSet getCounters() {
        return this.counters.get().getCounters();
    }

    public long getSendCount() {
        return this.counters.get().nsend;
    }

    public static class AsynchronousCloseException
    extends IllegalStateException {
        private static final long serialVersionUID = 1L;
    }

    private static class ReadMemoizer
    extends Memoizer<LoadRecordRequest, ByteBuffer> {
        public ReadMemoizer(Computable<LoadRecordRequest, ByteBuffer> c) {
            super(c);
        }

        int size() {
            return this.cache.size();
        }

        void removeFromCache(LoadRecordRequest req) {
            if (this.cache.remove(req) == null) {
                throw new AssertionError();
            }
        }
    }

    private static class LoadRecordRequest {
        final WriteCacheService service;
        final long offset;
        final int nbytes;

        public LoadRecordRequest(WriteCacheService service, long offset, int nbytes) {
            this.service = service;
            this.offset = offset;
            this.nbytes = nbytes;
        }

        public boolean equals(Object o) {
            if (!(o instanceof LoadRecordRequest)) {
                return false;
            }
            LoadRecordRequest r = (LoadRecordRequest)o;
            return this.service == r.service && this.offset == r.offset && this.nbytes == r.nbytes;
        }

        public int hashCode() {
            return (int)(this.offset ^ this.offset >>> 32);
        }
    }

    class WriteTask
    implements Callable<Void> {
        private ByteBuffer checksumBuffer;

        WriteTask() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Void call() throws Exception {
            try {
                this.checksumBuffer = WriteCacheService.this.quorum != null ? ByteBuffer.allocate(WriteCacheService.this.writeBuffers[0].peek().capacity()) : null;
                this.doRun();
                Void void_ = null;
                return void_;
            }
            catch (InterruptedException t) {
                Void void_ = null;
                return void_;
            }
            catch (Throwable t) {
                if (InnerCause.isInnerCause(t, AsynchronousCloseException.class)) {
                    Void void_ = null;
                    return void_;
                }
                if (WriteCacheService.this.firstCause.compareAndSet(null, t)) {
                    WriteCacheService.this.halt = true;
                }
                WriteCacheService.this.dirtyListLock.lock();
                try {
                    WriteCacheService.this.dirtyListEmpty.signalAll();
                    WriteCacheService.this.dirtyListChange.signalAll();
                }
                finally {
                    WriteCacheService.this.dirtyListLock.unlock();
                }
                WriteCacheService.this.cleanListLock.lock();
                try {
                    WriteCacheService.this.cleanListNotEmpty.signalAll();
                }
                finally {
                    WriteCacheService.this.cleanListLock.unlock();
                }
                log.error(t, t);
                Void void_ = null;
                return void_;
            }
            finally {
                WriteCacheService.this.compactingCacheRef.set(null);
                this.checksumBuffer = null;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void doRun() throws Exception {
            while (true) {
                if (WriteCacheService.this.halt) {
                    throw new RuntimeException((Throwable)WriteCacheService.this.firstCause.get());
                }
                WriteCache cache = this.awaitDirtyBuffer();
                boolean didCompact = false;
                boolean didWrite = false;
                boolean wasEmpty = cache.isEmpty();
                if (!wasEmpty) {
                    int percentEmpty = cache.potentialCompaction();
                    if (WriteCacheService.this.compactionEnabled && !WriteCacheService.this.directWrite && percentEmpty >= 20) {
                        if (log.isDebugEnabled()) {
                            log.debug("percentEmpty=" + percentEmpty + "%");
                        }
                        if (this.compactCache(cache)) {
                            assert (cache.isEmpty());
                        } else {
                            this.writeCacheBlock(cache);
                            didWrite = true;
                        }
                        didCompact = true;
                    } else {
                        this.writeCacheBlock(cache);
                        didWrite = true;
                    }
                }
                if (WriteCacheService.this.dirtyList.take() != cache) {
                    throw new AssertionError();
                }
                --((WriteCacheServiceCounters)((WriteCacheService)WriteCacheService.this).counters.get()).ndirty;
                WriteCacheService.this.dirtyListLock.lockInterruptibly();
                try {
                    if (WriteCacheService.this.dirtyList.isEmpty()) {
                        WriteCacheService.this.dirtyListEmpty.signalAll();
                    }
                }
                finally {
                    WriteCacheService.this.dirtyListLock.unlock();
                }
                WriteCacheService.this.addClean(cache, false);
                if (wasEmpty || !log.isInfoEnabled()) continue;
                WriteCacheServiceCounters tmp = (WriteCacheServiceCounters)WriteCacheService.this.counters.get();
                long nhit = tmp.nhit.get();
                long ntests = nhit + tmp.nmiss.get();
                int hitRate = (int)(100.0 * (ntests == 0L ? 0.0 : (double)nhit / (double)ntests));
                WriteCacheServiceCounters c = (WriteCacheServiceCounters)WriteCacheService.this.counters.get();
                log.info("WriteCacheService: bufferCapacity=" + WriteCacheService.this.writeBuffers[0].capacity() + ",nbuffers=" + tmp.nbuffers + ",nclean=" + tmp.nclean + ",ndirty=" + tmp.ndirty + ",maxDirty=" + tmp.maxdirty + ",hitRate=" + hitRate + ",empty=" + wasEmpty + ",didCompact=" + didCompact + ",didWrite=" + didWrite + ",ncompact=" + c.ncompact + ",nbufferEvictedToChannel=" + c.nbufferEvictedToChannel);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private boolean compactCache(WriteCache cache) throws InterruptedException, Exception {
            assert (!cache.isClosedForWrites());
            if (WriteCacheService.this.compactingReserveRef.get() == null) {
                WriteCache tmp = WriteCacheService.this.getDirectCleanCache();
                if (tmp == null) {
                    return false;
                }
                tmp.resetWith(WriteCacheService.this.serviceMap);
                WriteCacheService.this.compactingReserveRef.set(tmp);
            }
            WriteCache curCompactingCache = null;
            WriteCacheService.this.dirtyListLock.lockInterruptibly();
            try {
                curCompactingCache = WriteCacheService.this.compactingCacheRef.getAndSet(null);
                boolean done = false;
                if (curCompactingCache != null) {
                    if (log.isTraceEnabled()) {
                        log.trace("Transferring to curCompactingCache");
                    }
                    if (done = WriteCache.transferTo(cache, curCompactingCache, WriteCacheService.this.serviceMap, 0)) {
                        this.sendAddressMetadata(cache);
                        if (log.isDebugEnabled()) {
                            log.debug("RETURNING RESERVE: curCompactingCache.bytesWritten=" + curCompactingCache.bytesWritten());
                        }
                        boolean bl = true;
                        return bl;
                    }
                    if (WriteCacheService.this.flush) {
                        this.writeCacheBlock(curCompactingCache);
                        WriteCacheService.this.addClean(curCompactingCache, true);
                        if (log.isTraceEnabled()) {
                            log.trace("Flushed curCompactingCache");
                        }
                    } else {
                        WriteCacheService.this.dirtyList.add(curCompactingCache);
                        if (log.isTraceEnabled()) {
                            log.trace("Added curCompactingCache to dirtyList");
                        }
                    }
                    curCompactingCache = null;
                }
                if (log.isTraceEnabled()) {
                    log.trace("Setting curCompactingCache to reserve");
                }
                curCompactingCache = WriteCacheService.this.compactingReserveRef.getAndSet(null);
                WriteCache tmp = WriteCacheService.this.getDirectCleanCache();
                if (tmp != null) {
                    tmp.resetWith(WriteCacheService.this.serviceMap);
                    WriteCacheService.this.compactingReserveRef.set(tmp);
                }
                if (log.isTraceEnabled()) {
                    log.trace("Transferring to curCompactingCache");
                }
                if (!(done = WriteCache.transferTo(cache, curCompactingCache, WriteCacheService.this.serviceMap, 0))) {
                    throw new AssertionError((Object)"We must be able to compact the cache");
                }
                if (log.isDebugEnabled()) {
                    log.debug("USING RESERVE: curCompactingCache.bytesWritten=" + curCompactingCache.bytesWritten());
                }
                this.sendAddressMetadata(cache);
                boolean bl = true;
                return bl;
            }
            finally {
                try {
                    WriteCacheService.this.compactingCacheRef.set(curCompactingCache);
                    ++((WriteCacheServiceCounters)((WriteCacheService)WriteCacheService.this).counters.get()).ncompact;
                }
                finally {
                    WriteCacheService.this.dirtyListLock.unlock();
                }
            }
        }

        private void sendAddressMetadata(WriteCache cache) throws IllegalStateException, InterruptedException, ExecutionException, IOException {
            if (WriteCacheService.this.quorum == null) {
                return;
            }
            if (cache.prepareAddressMetadataForHA()) {
                this.writeCacheBlock(cache);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private WriteCache awaitDirtyBuffer() throws InterruptedException {
            WriteCacheService.this.dirtyListLock.lockInterruptibly();
            try {
                WriteCache cache;
                assert (WriteCacheService.this.m_dirtyListThreshold >= 1 && WriteCacheService.this.m_dirtyListThreshold <= WriteCacheService.this.writeBuffers.length) : "dirtyListThreshold=" + WriteCacheService.access$1900(WriteCacheService.this) + ", #buffers=" + WriteCacheService.access$100(WriteCacheService.this).length;
                while (true) {
                    if (!WriteCacheService.this.flush) {
                        if (WriteCacheService.this.dirtyList.size() >= WriteCacheService.this.m_dirtyListThreshold || WriteCacheService.this.halt) break;
                        WriteCacheService.this.dirtyListChange.await();
                        continue;
                    }
                    if (!WriteCacheService.this.dirtyList.isEmpty() || WriteCacheService.this.halt) break;
                    WriteCacheService.this.dirtyListChange.await();
                }
                if (WriteCacheService.this.halt) {
                    throw new RuntimeException((Throwable)WriteCacheService.this.firstCause.get());
                }
                WriteCacheServiceCounters c = (WriteCacheServiceCounters)WriteCacheService.this.counters.get();
                c.ndirty = WriteCacheService.this.dirtyList.size();
                if (c.maxdirty < c.ndirty) {
                    c.maxdirty = c.ndirty;
                }
                if ((cache = (WriteCache)WriteCacheService.this.dirtyList.peek()) == null) {
                    throw new AssertionError();
                }
                WriteCache writeCache = cache;
                return writeCache;
            }
            finally {
                WriteCacheService.this.dirtyListLock.unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void writeCacheBlock(WriteCache cache) throws InterruptedException, ExecutionException, IOException {
            boolean isHALeader = WriteCacheService.this.quorum != null && ((QuorumMember)WriteCacheService.this.quorum.getClient()).isLeader(WriteCacheService.this.quorumToken);
            cache.closeForWrites();
            ByteBuffer b = cache.peek();
            if (b.position() == 0) {
                return;
            }
            long thisSequence = WriteCacheService.this.cacheSequence.getAndIncrement();
            cache.setFileExtent(WriteCacheService.this.fileExtent.get());
            if (isHALeader) {
                WriteCacheService.this.quorum.assertLeader(WriteCacheService.this.quorumToken);
                QuorumPipeline quorumMember = (QuorumPipeline)((Object)WriteCacheService.this.quorum.getMember());
                assert (quorumMember != null) : "Not quorum member?";
                WriteCache.HAPackage pkg = cache.newHAPackage(quorumMember.getStoreUUID(), WriteCacheService.this.quorumToken, quorumMember.getLastCommitCounter(), quorumMember.getLastCommitTime(), thisSequence, WriteCacheService.this.replicationFactor, this.checksumBuffer);
                assert (pkg.getData().remaining() > 0) : "Empty cache: " + cache;
                quorumMember.logWriteCacheBlock(pkg.getMessage(), pkg.getData().duplicate());
                if (WriteCacheService.this.quorum.replicationFactor() > 1) {
                    WriteCacheService.this.remoteWriteFuture = quorumMember.replicate(null, pkg.getMessage(), pkg.getData().duplicate());
                    ++((WriteCacheServiceCounters)((WriteCacheService)WriteCacheService.this).counters.get()).nsend;
                }
            }
            if (log.isDebugEnabled()) {
                log.debug("Writing to file: " + cache.toString());
            }
            long begin = System.nanoTime();
            long nrecs = cache.recordMap.size();
            try {
                cache.flush(false);
            }
            catch (Throwable throwable) {
                long elapsed = System.nanoTime() - begin;
                WriteCacheServiceCounters c = (WriteCacheServiceCounters)WriteCacheService.this.counters.get();
                ++c.nbufferEvictedToChannel;
                c.nrecordsEvictedToChannel += nrecs;
                c.elapsedBufferEvictedToChannelNanos += elapsed;
                throw throwable;
            }
            long elapsed = System.nanoTime() - begin;
            WriteCacheServiceCounters c = (WriteCacheServiceCounters)WriteCacheService.this.counters.get();
            ++c.nbufferEvictedToChannel;
            c.nrecordsEvictedToChannel += nrecs;
            c.elapsedBufferEvictedToChannelNanos += elapsed;
            if (WriteCacheService.this.remoteWriteFuture != null) {
                WriteCacheService.this.remoteWriteFuture.get();
            }
        }
    }
}

