/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.journal;

import com.bigdata.io.FileChannelUtility;
import com.bigdata.journal.BufferMode;
import com.bigdata.journal.IBufferStrategy;
import com.bigdata.journal.IDiskBasedStrategy;
import com.bigdata.journal.IRootBlockView;
import com.bigdata.mdi.IResourceMetadata;
import com.bigdata.rawstore.AbstractRawWormStore;
import com.bigdata.resources.ResourceManager;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.channels.FileChannel;
import java.text.NumberFormat;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;

public abstract class AbstractBufferStrategy
extends AbstractRawWormStore
implements IBufferStrategy {
    protected static final Logger log = Logger.getLogger(AbstractBufferStrategy.class);
    protected static final boolean WARN = log.getEffectiveLevel().toInt() <= Level.WARN.toInt();
    public static final String ERR_BUFFER_EMPTY = "Zero bytes remaining in buffer";
    public static final String ERR_BUFFER_NULL = "Buffer is null";
    public static final String ERR_ADDRESS_NOT_WRITTEN = "Address never written.";
    public static final String ERR_ADDRESS_IS_NULL = "Address is 0L";
    public static final String ERR_RECORD_LENGTH_ZERO = "Record length is zero";
    public static final String ERR_MAX_EXTENT = "Would exceed maximum extent.";
    public static final String ERR_TRUNCATE = "Would truncate written data.";
    public static final String ERR_READ_ONLY = "Read only";
    public static final String ERR_BAD_RECORD_SIZE = "Bad record size";
    public static final String ERR_NOT_OPEN = "Not open";
    public static final String ERR_OPEN = "Open";
    public static final String ERR_BUFFER_OVERRUN = "Would overrun buffer";
    private volatile boolean open = false;
    private boolean readOnly;
    protected final long initialExtent;
    protected final long maximumExtent;
    protected final BufferMode bufferMode;
    protected final AtomicLong nextOffset;
    protected final AtomicLong commitOffset;
    static final NumberFormat cf = NumberFormat.getIntegerInstance();

    @Override
    public final long getInitialExtent() {
        return this.initialExtent;
    }

    @Override
    public final long getMaximumExtent() {
        return this.maximumExtent;
    }

    protected long getMinimumExtension() {
        return 0x2000000L;
    }

    @Override
    public final BufferMode getBufferMode() {
        return this.bufferMode;
    }

    @Override
    public final long getNextOffset() {
        return this.nextOffset.get();
    }

    AbstractBufferStrategy(long initialExtent, long maximumExtent, int offsetBits, long nextOffset, BufferMode bufferMode, boolean readOnly) {
        super(offsetBits);
        assert (nextOffset >= 0L);
        if (bufferMode == null) {
            throw new IllegalArgumentException();
        }
        this.initialExtent = initialExtent;
        this.maximumExtent = maximumExtent;
        this.nextOffset = new AtomicLong(nextOffset);
        this.commitOffset = new AtomicLong(nextOffset);
        this.bufferMode = bufferMode;
        this.open = true;
        this.readOnly = readOnly;
    }

    @Override
    public final long size() {
        return this.nextOffset.get();
    }

    protected final void assertOpen() {
        if (!this.open) {
            throw new IllegalStateException(ERR_NOT_OPEN);
        }
    }

    @Override
    public boolean isOpen() {
        return this.open;
    }

    @Override
    public boolean isReadOnly() {
        this.assertOpen();
        return this.readOnly;
    }

    @Override
    public void close() {
        if (!this.open) {
            throw new IllegalStateException();
        }
        this.open = false;
    }

    @Override
    public final void destroy() {
        if (this.open) {
            this.close();
        }
        this.deleteResources();
    }

    public final boolean overflow(long needed) {
        long userExtent = this.getUserExtent();
        long required = userExtent + needed;
        if (required > this.bufferMode.getMaxExtent()) {
            log.error(ERR_MAX_EXTENT);
            return false;
        }
        if (this.maximumExtent != 0L && required > this.maximumExtent) {
            if (WARN) {
                log.warn("Would exceed maximumExtent=" + this.maximumExtent);
            }
            return false;
        }
        long newExtent = userExtent + Math.max(needed, Math.max(this.initialExtent, this.getMinimumExtension()));
        if (newExtent > this.bufferMode.getMaxExtent() && (newExtent = this.bufferMode.getMaxExtent()) - userExtent < needed) {
            log.error(ERR_MAX_EXTENT);
            return false;
        }
        this.truncate(newExtent);
        ResourceManager.extendJournal(this.getFile() == null ? null : this.getFile().toString(), newExtent);
        return true;
    }

    protected static long transferFromDiskTo(IDiskBasedStrategy src, RandomAccessFile out) throws IOException {
        long fromPosition = src.getHeaderSize();
        long count = src.getNextOffset();
        FileChannel srcChannel = src.getChannel();
        FileChannel outChannel = out.getChannel();
        long outPosition = outChannel.position();
        FileChannelUtility.transferAll(srcChannel, fromPosition, count, out, outPosition);
        return count;
    }

    @Override
    public UUID getUUID() {
        throw new UnsupportedOperationException();
    }

    @Override
    public IResourceMetadata getResourceMetadata() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void closeForWrites() {
        if (this.isReadOnly()) {
            throw new IllegalStateException();
        }
        this.readOnly = true;
    }

    @Override
    public void delete(long addr) {
    }

    @Override
    public boolean isDirty() {
        return this.commitOffset.get() != this.nextOffset.get();
    }

    @Override
    public void commit() {
        this.commitOffset.set(this.nextOffset.get());
    }

    @Override
    public void abort() {
        this.nextOffset.set(this.commitOffset.get());
    }

    @Override
    public long getMetaBitsAddr() {
        return 0L;
    }

    @Override
    public long getMetaStartAddr() {
        return 0L;
    }

    @Override
    public boolean requiresCommit(IRootBlockView block) {
        return this.getNextOffset() > block.getNextOffset();
    }

    @Override
    public int getMaxRecordSize() {
        return this.getAddressManager().getMaxByteCount() - (this.useChecksums() ? 4 : 0);
    }

    @Override
    public boolean useChecksums() {
        return false;
    }

    static {
        cf.setGroupingUsed(true);
    }
}

