/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.journal;

import com.bigdata.counters.CounterSet;
import com.bigdata.counters.Instrument;
import com.bigdata.journal.ILocalTransactionManager;
import com.bigdata.journal.ITransactionService;
import com.bigdata.journal.Tx;
import com.bigdata.service.ITxState;
import java.io.IOException;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.log4j.Logger;

public abstract class AbstractLocalTransactionManager
implements ILocalTransactionManager {
    private static final Logger log = Logger.getLogger(AbstractLocalTransactionManager.class);
    private final ConcurrentHashMap<Long, Tx> activeTx = new ConcurrentHashMap();
    private volatile boolean open = true;
    final long delay = 10L;
    final int maxtries = 100;

    @Override
    public ITxState[] getActiveTx() {
        return this.activeTx.values().toArray(new ITxState[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void activateTx(Tx localState) throws IllegalStateException {
        if (localState == null) {
            throw new IllegalArgumentException();
        }
        localState.lock.lock();
        try {
            if (this.activeTx.putIfAbsent(localState.getStartTimestamp(), localState) != null) {
                throw new IllegalStateException("Already in local table: tx=" + localState);
            }
        }
        finally {
            localState.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void deactivateTx(Tx localState) throws IllegalStateException {
        if (localState == null) {
            throw new IllegalArgumentException();
        }
        localState.lock.lock();
        try {
            if (!localState.isReadOnly() && !localState.isComplete()) {
                throw new IllegalStateException("Not complete: " + localState);
            }
            localState.releaseResources();
            if (this.activeTx.remove(localState.getStartTimestamp()) == null) {
                throw new IllegalStateException("Not in local tables: tx=" + localState);
            }
        }
        finally {
            localState.lock.unlock();
        }
    }

    @Override
    public Tx getTx(long tx) {
        return this.activeTx.get(tx);
    }

    @Override
    public boolean isOpen() {
        return this.open;
    }

    @Override
    public synchronized void shutdown() {
        if (!this.open) {
            return;
        }
        this.open = false;
    }

    @Override
    public synchronized void shutdownNow() {
        if (!this.open) {
            return;
        }
        this.open = false;
    }

    @Override
    public long nextTimestamp() {
        int ntries;
        long begin = System.currentTimeMillis();
        IOException cause = null;
        for (ntries = 1; ntries <= 100; ++ntries) {
            try {
                ITransactionService transactionService = this.getTransactionService();
                if (transactionService == null) {
                    log.warn("Service not discovered yet?");
                    try {
                        Thread.sleep(10L);
                        continue;
                    }
                    catch (InterruptedException e2) {
                        throw new RuntimeException("Interrupted awaiting timestamp service discovery: " + e2);
                    }
                }
                return transactionService.nextTimestamp();
            }
            catch (IOException e) {
                log.warn("Problem with timestamp service? : ntries=" + ntries + ", " + e, e);
                cause = e;
            }
        }
        long elapsed = System.currentTimeMillis() - begin;
        String msg = "Could not get timestamp after " + ntries + " tries and " + elapsed + "ms";
        log.error(msg, cause);
        throw new RuntimeException(msg, cause);
    }

    @Override
    public void notifyCommit(long commitTime) {
        int ntries;
        long begin = System.currentTimeMillis();
        IOException cause = null;
        for (ntries = 1; ntries <= 100; ++ntries) {
            try {
                ITransactionService transactionService = this.getTransactionService();
                if (transactionService == null) {
                    log.warn("Service not discovered?");
                    try {
                        Thread.sleep(10L);
                        continue;
                    }
                    catch (InterruptedException e2) {
                        throw new RuntimeException("Interrupted awaiting timestamp service discovery: " + e2);
                    }
                }
                transactionService.notifyCommit(commitTime);
                return;
            }
            catch (IOException e) {
                log.warn("Problem with timestamp service? : ntries=" + ntries + ", " + e, e);
                cause = e;
            }
        }
        long elapsed = System.currentTimeMillis() - begin;
        String msg = "Could not notify timestamp service after " + ntries + " tries and " + elapsed + "ms";
        log.error(msg, cause);
        throw new RuntimeException(msg, cause);
    }

    public CounterSet getCounters() {
        CounterSet countersRoot = new CounterSet();
        countersRoot.addCounter("#active", new Instrument<Integer>(){

            @Override
            protected void sample() {
                this.setValue(AbstractLocalTransactionManager.this.activeTx.size());
            }
        });
        return countersRoot;
    }
}

