/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.journal;

import com.bigdata.counters.CounterSet;
import com.bigdata.io.FileChannelUtility;
import com.bigdata.journal.AbstractBufferStrategy;
import com.bigdata.journal.BufferMode;
import com.bigdata.journal.OverflowException;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;

public abstract class BasicBufferStrategy
extends AbstractBufferStrategy {
    private volatile ByteBuffer buffer;
    final int headerSize;
    protected long extent;
    protected long userExtent;
    private CounterSet root;

    protected synchronized ByteBuffer getBufferView(boolean readOnly) {
        if (readOnly) {
            return this.buffer.asReadOnlyBuffer();
        }
        return this.buffer.duplicate();
    }

    @Override
    public long getExtent() {
        return this.extent;
    }

    @Override
    public long getUserExtent() {
        return this.userExtent;
    }

    BasicBufferStrategy(long maximumExtent, int offsetBits, long nextOffset, int headerSize, long extent, BufferMode bufferMode, ByteBuffer buffer, boolean readOnly) {
        super(extent, maximumExtent, offsetBits, nextOffset, bufferMode, readOnly);
        this.buffer = buffer;
        this.extent = extent;
        this.headerSize = headerSize;
        this.userExtent = extent - (long)headerSize;
    }

    @Override
    public void close() {
        super.close();
        this.buffer = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long write(ByteBuffer data) {
        long addr;
        if (data == null) {
            throw new IllegalArgumentException("Buffer is null");
        }
        if (this.isReadOnly()) {
            throw new IllegalStateException("Read only");
        }
        int nbytes = data.remaining();
        if (nbytes == 0) {
            throw new IllegalArgumentException("Zero bytes remaining in buffer");
        }
        BasicBufferStrategy basicBufferStrategy = this;
        synchronized (basicBufferStrategy) {
            long offset = this.nextOffset.get();
            addr = this.toAddr(nbytes, offset);
            long needed = offset + (long)nbytes - this.userExtent;
            if (offset + (long)nbytes > Integer.MAX_VALUE) {
                throw new RuntimeException("Would exceed maximum extent.");
            }
            if (needed > 0L && !this.overflow(needed)) {
                throw new OverflowException();
            }
            this.buffer.limit((int)offset + nbytes);
            this.buffer.position((int)offset);
            this.buffer.put(data);
            this.nextOffset.addAndGet(nbytes);
        }
        return addr;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ByteBuffer read(long addr) {
        ByteBuffer view;
        if (addr == 0L) {
            throw new IllegalArgumentException("Address is 0L");
        }
        long offset = this.getOffset(addr);
        int nbytes = this.getByteCount(addr);
        if (nbytes == 0) {
            throw new IllegalArgumentException("Record length is zero");
        }
        if (offset + (long)nbytes > this.nextOffset.get()) {
            throw new IllegalArgumentException("Address never written.");
        }
        BasicBufferStrategy basicBufferStrategy = this;
        synchronized (basicBufferStrategy) {
            view = this.buffer.asReadOnlyBuffer();
        }
        view.limit((int)offset + nbytes);
        view.position((int)offset);
        return view.slice();
    }

    @Override
    public synchronized void truncate(long newExtent) {
        long newUserExtent = newExtent - (long)this.headerSize;
        if (newUserExtent < this.getNextOffset()) {
            throw new IllegalArgumentException("Would truncate written data.");
        }
        if (newUserExtent > Integer.MAX_VALUE) {
            throw new IllegalArgumentException("Would exceed maximum extent.");
        }
        if (newUserExtent == this.getUserExtent()) {
            return;
        }
        boolean isDirect = this.buffer.isDirect();
        int newCapacity = (int)newUserExtent;
        ByteBuffer tmp = isDirect ? ByteBuffer.allocateDirect(newCapacity) : ByteBuffer.allocate(newCapacity);
        this.buffer.limit((int)Math.min(this.nextOffset.get(), (long)newCapacity));
        this.buffer.position(0);
        tmp.put(this.buffer);
        this.buffer = tmp;
        this.extent = newUserExtent + (long)this.headerSize;
        this.userExtent = newUserExtent;
        if (log.isInfoEnabled()) {
            log.info("Buffer: newCapacity=" + cf.format(newCapacity));
        }
    }

    @Override
    public synchronized long transferTo(RandomAccessFile out) throws IOException {
        long count = this.nextOffset.get();
        FileChannel outChannel = out.getChannel();
        long toPosition = outChannel.position();
        this.buffer.limit((int)count);
        this.buffer.position(0);
        FileChannelUtility.writeAll(outChannel, this.buffer, toPosition);
        outChannel.position(toPosition + count);
        return count;
    }

    @Override
    public synchronized CounterSet getCounters() {
        if (this.root == null) {
            this.root = new CounterSet();
        }
        return this.root;
    }
}

