/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.journal;

import com.bigdata.counters.CounterSet;
import com.bigdata.counters.Instrument;
import com.bigdata.counters.OneShotInstrument;
import com.bigdata.io.DirectBufferPool;
import com.bigdata.io.FileChannelUtility;
import com.bigdata.io.IBufferAccess;
import com.bigdata.io.IReopenChannel;
import com.bigdata.journal.AbstractBufferStrategy;
import com.bigdata.journal.BufferMode;
import com.bigdata.journal.CommitRecordIndex;
import com.bigdata.journal.FileMetadata;
import com.bigdata.journal.ForceEnum;
import com.bigdata.journal.IDiskBasedStrategy;
import com.bigdata.journal.IRootBlockView;
import com.bigdata.journal.OverflowException;
import com.bigdata.journal.WORMStrategy;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class DiskOnlyStrategy
extends AbstractBufferStrategy
implements IDiskBasedStrategy {
    private final File file;
    private final String fileMode;
    private final boolean temporaryStore;
    private boolean fileOpened;
    RandomAccessFile raf;
    private final int headerSize;
    private long extent;
    private long userExtent;
    private final WriteCache writeCache;
    private long writeCacheOffset;
    private WORMStrategy.StoreCounters storeCounters = new WORMStrategy.StoreCounters();
    private final IReopenChannel<FileChannel> opener = new IReopenChannel<FileChannel>(){

        @Override
        public String toString() {
            return DiskOnlyStrategy.this.file.toString();
        }

        @Override
        public FileChannel reopenChannel() throws IOException {
            return DiskOnlyStrategy.this.reopenChannel();
        }
    };

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void commit() {
        if (this.writeCache != null) {
            DiskOnlyStrategy diskOnlyStrategy = this;
            synchronized (diskOnlyStrategy) {
                this.flushWriteCache();
            }
        }
        super.commit();
    }

    void flushWriteCache() {
        if (this.writeCache == null) {
            return;
        }
        this.writeCache.flush();
    }

    @Override
    public final int getHeaderSize() {
        return this.headerSize;
    }

    @Override
    public final File getFile() {
        return this.file;
    }

    @Override
    public final RandomAccessFile getRandomAccessFile() {
        return this.raf;
    }

    @Override
    public final FileChannel getChannel() {
        RandomAccessFile raf = this.getRandomAccessFile();
        if (raf == null) {
            return null;
        }
        return raf.getChannel();
    }

    public WORMStrategy.StoreCounters getStoreCounters() {
        return this.storeCounters;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setStoreCounters(WORMStrategy.StoreCounters storeCounters) {
        if (storeCounters == null) {
            throw new IllegalArgumentException();
        }
        DiskOnlyStrategy diskOnlyStrategy = this;
        synchronized (diskOnlyStrategy) {
            this.storeCounters = storeCounters;
        }
    }

    @Override
    public CounterSet getCounters() {
        CounterSet root = new CounterSet();
        root.addCounter("nextOffset", new Instrument<Long>(){

            @Override
            public void sample() {
                this.setValue(DiskOnlyStrategy.this.nextOffset.get());
            }
        });
        root.addCounter("extent", new Instrument<Long>(){

            @Override
            public void sample() {
                this.setValue(DiskOnlyStrategy.this.extent);
            }
        });
        root.attach(this.storeCounters.getCounters());
        CounterSet writeCache = root.makePath("writeCache");
        WriteCache tmp = this.writeCache;
        writeCache.addCounter("capacity", new OneShotInstrument<Long>(tmp == null ? 0L : (long)tmp.capacity()));
        return root;
    }

    DiskOnlyStrategy(long maximumExtent, FileMetadata fileMetadata) {
        super(fileMetadata.extent, maximumExtent, fileMetadata.offsetBits, fileMetadata.nextOffset, fileMetadata.getBufferMode(), fileMetadata.readOnly);
        this.file = fileMetadata.file;
        this.fileMode = fileMetadata.fileMode;
        this.temporaryStore = fileMetadata.getBufferMode() == BufferMode.Temporary;
        this.raf = fileMetadata.raf;
        boolean bl = this.fileOpened = this.raf != null;
        if (!this.temporaryStore && !this.fileOpened) {
            throw new RuntimeException("File not open and not a temporary store");
        }
        this.extent = fileMetadata.extent;
        this.headerSize = 688;
        this.userExtent = this.extent - (long)this.headerSize;
        if (fileMetadata.writeCacheEnabled && !fileMetadata.readOnly && fileMetadata.closeTime == 0L) {
            IBufferAccess tmp;
            try {
                tmp = DirectBufferPool.INSTANCE.acquire();
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
            if (log.isInfoEnabled()) {
                log.info("Enabling writeCache: capacity=" + tmp.buffer().capacity());
            }
            this.writeCache = new WriteCache(tmp);
        } else {
            this.writeCache = null;
        }
        this.writeCacheOffset = fileMetadata.nextOffset;
    }

    @Override
    public final boolean isStable() {
        return true;
    }

    @Override
    public boolean isFullyBuffered() {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void force(boolean metadata) {
        this.assertOpen();
        DiskOnlyStrategy diskOnlyStrategy = this;
        synchronized (diskOnlyStrategy) {
            this.flushWriteCache();
        }
        try {
            if (!this.temporaryStore) {
                this.getChannel().force(metadata);
            }
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
        ++this.storeCounters.nforce;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void close() {
        block7: {
            super.close();
            this.releaseWriteCache();
            try {
                if (this.raf == null) break block7;
                DiskOnlyStrategy diskOnlyStrategy = this;
                synchronized (diskOnlyStrategy) {
                    if (this.raf != null && this.raf.getChannel().isOpen()) {
                        this.raf.close();
                    }
                }
            }
            catch (IOException ex) {
                throw new RuntimeException(ex);
            }
        }
        if (!this.bufferMode.isStable() && this.file.exists() && !this.file.delete()) {
            log.warn("Unable to delete temporary file: " + this.file);
        }
    }

    @Override
    public void deleteResources() {
        if (this.isOpen()) {
            throw new IllegalStateException();
        }
        if (this.fileOpened && this.file.exists() && !this.file.delete()) {
            log.warn("Could not delete file: " + this.file.getAbsoluteFile());
        }
    }

    @Override
    public final long getExtent() {
        return this.extent;
    }

    @Override
    public final long getUserExtent() {
        return this.userExtent;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ByteBuffer read(long addr) {
        long begin = System.nanoTime();
        if (addr == 0L) {
            throw new IllegalArgumentException("Address is 0L");
        }
        long offset = this.getOffset(addr);
        int nbytes = this.getByteCount(addr);
        if (nbytes == 0) {
            throw new IllegalArgumentException("Record length is zero");
        }
        if (offset + (long)nbytes > this.nextOffset.get()) {
            throw new IllegalArgumentException("Address never written.");
        }
        ByteBuffer dst = ByteBuffer.allocate(nbytes);
        DiskOnlyStrategy diskOnlyStrategy = this;
        synchronized (diskOnlyStrategy) {
            if ((long)nbytes > this.storeCounters.maxReadSize) {
                this.storeCounters.maxReadSize = nbytes;
            }
            if (this.writeCache != null) {
                long beginCache = System.nanoTime();
                ByteBuffer tmp = this.writeCache.read(addr, nbytes);
                if (tmp != null) {
                    dst.put(tmp);
                    dst.flip();
                    ++this.storeCounters.nreads;
                    this.storeCounters.bytesRead += (long)nbytes;
                    this.storeCounters.elapsedReadNanos += System.nanoTime() - begin;
                    return dst;
                }
            }
            long beginDisk = System.nanoTime();
            long pos = offset + (long)this.headerSize;
            try {
                this.storeCounters.ndiskRead += (long)FileChannelUtility.readAll(this.opener, dst, pos);
            }
            catch (IOException ex) {
                throw new RuntimeException(ex);
            }
            dst.flip();
            ++this.storeCounters.nreads;
            this.storeCounters.bytesRead += (long)nbytes;
            this.storeCounters.bytesReadFromDisk += (long)nbytes;
            this.storeCounters.elapsedReadNanos += System.nanoTime() - begin;
            this.storeCounters.elapsedDiskReadNanos += System.nanoTime() - beginDisk;
            return dst;
        }
    }

    private synchronized FileChannel reopenChannel() throws IOException {
        block7: {
            this.assertOpen();
            if (this.raf != null && this.raf.getChannel().isOpen()) {
                return this.raf.getChannel();
            }
            if (this.temporaryStore && !this.fileOpened) {
                throw new AssertionError((Object)("TemporaryStore not yet open: " + this.file));
            }
            this.raf = new RandomAccessFile(this.file, this.fileMode);
            if (log.isInfoEnabled()) {
                log.info("(Re-)opened file: " + this.file);
            }
            try {
                boolean readOnly = "r".equals(this.fileMode);
                if (this.raf.getChannel().tryLock(0L, Long.MAX_VALUE, readOnly) != null) break block7;
                try {
                    this.raf.close();
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                throw new IOException("File already locked? file=" + this.file);
            }
            catch (IOException ex) {
                if (!log.isInfoEnabled()) break block7;
                log.info("FileLock not supported: file=" + this.file, ex);
            }
        }
        ++this.storeCounters.nreopen;
        return this.raf.getChannel();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long allocate(int nbytes) {
        long addr;
        if (this.isReadOnly()) {
            throw new IllegalStateException("Read only");
        }
        if (nbytes <= 0) {
            throw new IllegalArgumentException("Bad record size");
        }
        DiskOnlyStrategy diskOnlyStrategy = this;
        synchronized (diskOnlyStrategy) {
            long offset = this.nextOffset.get();
            this.overflow(offset, nbytes);
            addr = this.toAddr(nbytes, offset);
            this.nextOffset.addAndGet(nbytes);
        }
        return addr;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long write(ByteBuffer data) {
        long addr;
        if (data == null) {
            throw new IllegalArgumentException("Buffer is null");
        }
        if (this.isReadOnly()) {
            throw new IllegalStateException("Read only");
        }
        int nbytes = data.remaining();
        if (nbytes == 0) {
            throw new IllegalArgumentException("Zero bytes remaining in buffer");
        }
        long begin = System.nanoTime();
        DiskOnlyStrategy diskOnlyStrategy = this;
        synchronized (diskOnlyStrategy) {
            addr = this.allocate(nbytes);
            long offset = this.getOffset(addr);
            if (this.writeCache != null) {
                if (nbytes + this.writeCache.position() > this.writeCache.capacity()) {
                    this.flushWriteCache();
                }
                if (nbytes > this.writeCache.capacity()) {
                    this.writeOnDisk(data, offset, true);
                } else {
                    long beginCache = System.nanoTime();
                    this.writeCache.write(addr, data);
                }
            } else {
                this.writeOnDisk(data, offset, true);
            }
            ++this.storeCounters.nwrites;
            this.storeCounters.bytesWritten += (long)nbytes;
            this.storeCounters.elapsedWriteNanos += System.nanoTime() - begin;
            if ((long)nbytes > this.storeCounters.maxWriteSize) {
                this.storeCounters.maxWriteSize = nbytes;
            }
        }
        return addr;
    }

    private void overflow(long offset, int nbytes) {
        long needed = offset + (long)nbytes - this.userExtent;
        if (needed > 0L && !this.overflow(needed)) {
            throw new OverflowException();
        }
    }

    private final void createBackingFile() {
        if (!this.fileOpened && this.temporaryStore) {
            try {
                this.fileOpened = true;
                this.reopenChannel();
                if (log.isInfoEnabled()) {
                    log.info("Opened backing file for temporary store: " + this.file);
                }
            }
            catch (IOException e) {
                throw new RuntimeException("Could not open temp file: file=" + this.file, e);
            }
        }
    }

    private void writeOnDisk(ByteBuffer data, long offset, boolean append) {
        long begin = System.nanoTime();
        this.createBackingFile();
        int nbytes = data.remaining();
        this.overflow(offset, nbytes);
        long pos = offset + (long)this.headerSize;
        try {
            this.storeCounters.ndiskWrite += (long)FileChannelUtility.writeAll(this.getChannel(), data, pos);
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
        if (append) {
            this.writeCacheOffset += (long)nbytes;
        }
        long elapsed = System.nanoTime() - begin;
        this.storeCounters.bytesWrittenOnDisk += (long)nbytes;
        this.storeCounters.elapsedDiskWriteNanos += elapsed;
    }

    @Override
    public ByteBuffer readRootBlock(boolean rootBlock0) {
        if (!this.isOpen()) {
            throw new IllegalStateException();
        }
        ByteBuffer tmp = ByteBuffer.allocate(340);
        try {
            FileChannelUtility.readAll(this.opener, tmp, rootBlock0 ? 8L : 348L);
            tmp.position(0);
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
        return tmp;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void writeRootBlock(IRootBlockView rootBlock, ForceEnum forceOnCommit) {
        if (rootBlock == null) {
            throw new IllegalArgumentException();
        }
        try {
            ByteBuffer data = rootBlock.asReadOnlyBuffer();
            long pos = rootBlock.isRootBlock0() ? 8L : 348L;
            DiskOnlyStrategy diskOnlyStrategy = this;
            synchronized (diskOnlyStrategy) {
                FileChannelUtility.writeAll(this.getChannel(), data, pos);
            }
            if (forceOnCommit != ForceEnum.No) {
                this.force(forceOnCommit == ForceEnum.ForceMetadata);
            }
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
        if (log.isDebugEnabled()) {
            log.debug("wrote root block: " + rootBlock);
        }
        ++this.storeCounters.nwriteRootBlock;
    }

    @Override
    public synchronized void truncate(long newExtent) {
        long newUserExtent = newExtent - (long)this.headerSize;
        if (newUserExtent < this.getNextOffset()) {
            throw new IllegalArgumentException("Would truncate written data.");
        }
        if (newUserExtent == this.getUserExtent()) {
            return;
        }
        this.createBackingFile();
        try {
            this.getRandomAccessFile().setLength(newExtent);
            if (!this.temporaryStore) {
                this.force(true);
            }
            ++this.storeCounters.ntruncate;
            if (log.isInfoEnabled()) {
                log.info("newLength=" + cf.format(newExtent) + ", file=" + this.file);
            }
            if (log.isInfoEnabled()) {
                log.info(this.getCounters().toString());
            }
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
        this.userExtent = newUserExtent;
        this.extent = newExtent;
    }

    @Override
    public synchronized long transferTo(RandomAccessFile out) throws IOException {
        if (out == null) {
            throw new IllegalArgumentException();
        }
        this.flushWriteCache();
        return AbstractBufferStrategy.transferFromDiskTo(this, out);
    }

    @Override
    public void closeForWrites() {
        super.closeForWrites();
        this.releaseWriteCache();
    }

    private final synchronized void releaseWriteCache() {
        IBufferAccess tmp;
        IBufferAccess iBufferAccess = tmp = this.writeCache == null ? null : this.writeCache.buf;
        if (tmp == null) {
            return;
        }
        try {
            tmp.release();
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
        finally {
            this.writeCache.buf = null;
        }
    }

    @Override
    public void delete(long addr) {
    }

    public void setNextOffset(long lastOffset) {
    }

    public void setCommitRecordIndex(CommitRecordIndex commitRecordIndex) {
    }

    private class WriteCache {
        private IBufferAccess buf;
        private final Map<Long, Integer> writeCacheIndex;

        public WriteCache(IBufferAccess writeCache) {
            if (writeCache == null) {
                throw new IllegalArgumentException();
            }
            this.buf = writeCache;
            int capacity = writeCache.buffer().capacity();
            writeCache.buffer().clear();
            int indexDefaultCapacity = capacity / 1024;
            this.writeCacheIndex = new ConcurrentHashMap<Long, Integer>(indexDefaultCapacity);
        }

        final int position() {
            return this.buf.buffer().position();
        }

        final int capacity() {
            return this.buf.buffer().capacity();
        }

        void flush() {
            int nbytes = this.buf.buffer().position();
            if (nbytes == 0) {
                return;
            }
            this.buf.buffer().flip();
            DiskOnlyStrategy.this.writeOnDisk(this.buf.buffer(), DiskOnlyStrategy.this.writeCacheOffset, true);
            this.buf.buffer().clear();
            this.writeCacheIndex.clear();
        }

        void write(long addr, ByteBuffer data) {
            int position = this.buf.buffer().position();
            this.buf.buffer().put(data);
            this.writeCacheIndex.put(addr, position);
        }

        ByteBuffer read(long addr, int nbytes) {
            Integer writeCachePosition = this.writeCacheIndex.get(addr);
            if (writeCachePosition == null) {
                return null;
            }
            int pos = writeCachePosition;
            ByteBuffer tmp = this.buf.buffer().duplicate();
            tmp.limit(pos + nbytes);
            tmp.position(pos);
            return tmp.slice();
        }
    }
}

