/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.journal;

import com.bigdata.Banner;
import com.bigdata.config.Configuration;
import com.bigdata.config.IValidator;
import com.bigdata.config.IntegerRangeValidator;
import com.bigdata.config.LongRangeValidator;
import com.bigdata.io.FileChannelUtility;
import com.bigdata.io.IReopenChannel;
import com.bigdata.journal.BufferMode;
import com.bigdata.journal.ForceEnum;
import com.bigdata.journal.IRootBlockView;
import com.bigdata.journal.Options;
import com.bigdata.journal.RootBlockUtility;
import com.bigdata.journal.StoreTypeEnum;
import com.bigdata.rawstore.WormAddressManager;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.channels.OverlappingFileLockException;
import java.util.Properties;
import java.util.UUID;
import org.apache.log4j.Logger;

public class FileMetadata {
    protected static final Logger log = Logger.getLogger(FileMetadata.class);
    protected static final boolean INFO = log.isInfoEnabled();
    protected static final boolean DEBUG = log.isDebugEnabled();
    static final int SIZE_MAGIC = 4;
    static final int SIZE_VERSION = 4;
    static final int SIZEOF_ROOT_BLOCK = 340;
    public static final int MAGIC = -424361355;
    public static final int VERSION1 = 1;
    public static final int CURRENT_VERSION = 1;
    public final File file;
    final String fileMode;
    final BufferMode bufferMode;
    RandomAccessFile raf;
    final int magic;
    final int version;
    final long extent;
    final long userExtent;
    final int offsetBits;
    final boolean writeCacheEnabled;
    public final int writeCacheBufferCount;
    final boolean useChecksums;
    final long nextOffset;
    public final boolean readOnly;
    final long createTime;
    final long closeTime;
    public static final int OFFSET_ROOT_BLOCK0 = 8;
    public static final int OFFSET_ROOT_BLOCK1 = 348;
    public static final int headerSize0 = 688;
    final ByteBuffer buffer;
    final boolean exists;
    public final IRootBlockView rootBlock;
    final Properties properties;
    private final IReopenChannel<FileChannel> opener = new IReopenChannel<FileChannel>(){

        @Override
        public String toString() {
            return FileMetadata.this.file.toString();
        }

        @Override
        public FileChannel reopenChannel() throws IOException {
            return FileMetadata.this.reopenChannel();
        }
    };

    public RandomAccessFile getRandomAccessFile() {
        return this.raf;
    }

    FileMetadata(File file, BufferMode bufferMode, boolean useDirectBuffers, long initialExtent, long maximumExtent, boolean create, boolean isEmptyFile, boolean deleteOnExit, boolean readOnly, ForceEnum forceWrites, int offsetBits, boolean writeCacheEnabled, int writeCacheBufferCount, boolean validateChecksum, long createTime, long quorumToken, boolean alternateRootBlock, Properties properties) throws RuntimeException {
        if (file == null) {
            throw new IllegalArgumentException();
        }
        if (bufferMode == null) {
            throw new IllegalArgumentException();
        }
        if (bufferMode == BufferMode.Transient) {
            throw new IllegalArgumentException();
        }
        if (file.exists() && file.length() != 0L) {
            throw new IllegalArgumentException("File exists and is not empty: " + file.getAbsolutePath());
        }
        if (readOnly && create) {
            throw new IllegalArgumentException("'" + Options.CREATE + "' may not be used with '" + Options.READ_ONLY + "'");
        }
        if (readOnly && forceWrites != ForceEnum.No) {
            throw new IllegalArgumentException("'" + Options.FORCE_WRITES + "'='" + (Object)((Object)forceWrites) + "' may not be used with '" + Options.READ_ONLY + "'");
        }
        WormAddressManager.assertOffsetBits(offsetBits);
        this.bufferMode = bufferMode;
        this.writeCacheEnabled = writeCacheEnabled;
        this.writeCacheBufferCount = writeCacheBufferCount;
        this.fileMode = readOnly ? "r" : forceWrites.asFileMode();
        this.readOnly = readOnly;
        this.exists = false;
        this.properties = properties;
        boolean temporary = bufferMode.equals((Object)BufferMode.Temporary);
        if (temporary) {
            deleteOnExit = true;
        }
        this.file = file;
        if (this.exists && !temporary) {
            if (INFO) {
                log.info("Opening existing file: " + file.getAbsoluteFile());
            }
        } else {
            if (readOnly) {
                throw new RuntimeException("File does not exist and '" + Options.READ_ONLY + "' was specified: " + file.getAbsoluteFile());
            }
            if (!create && !isEmptyFile) {
                throw new RuntimeException("File does not exist and '" + Options.CREATE + "' was not specified: " + file.getAbsoluteFile());
            }
            if (INFO) {
                log.info("Backing file: exists=" + this.exists + ", temporary=" + temporary + ", create=" + create + ", readOnly=" + readOnly + ", file=" + file.getAbsoluteFile());
            }
        }
        try {
            if (!temporary) {
                this.opener.reopenChannel();
            }
            if (deleteOnExit) {
                try {
                    file.deleteOnExit();
                }
                catch (NullPointerException ex) {
                    // empty catch block
                }
            }
            this.extent = bufferMode == BufferMode.Mapped ? maximumExtent : initialExtent;
            this.userExtent = this.extent - 688L;
            if (this.userExtent > bufferMode.getMaxExtent()) {
                throw new RuntimeException("Would exceed maximum extent.");
            }
            RootBlockUtility rbu = new RootBlockUtility(bufferMode, offsetBits, createTime, quorumToken, UUID.randomUUID());
            this.magic = -424361355;
            this.version = 1;
            if (!temporary) {
                this.raf.setLength(this.extent);
                this.raf.seek(0L);
                this.raf.writeInt(-424361355);
                this.raf.writeInt(this.version);
            }
            this.nextOffset = rbu.rootBlock.getNextOffset();
            this.offsetBits = rbu.rootBlock.getOffsetBits();
            this.createTime = rbu.rootBlock.getCreateTime();
            this.closeTime = rbu.rootBlock.getCloseTime();
            IRootBlockView rootBlock0 = rbu.rootBlock0;
            IRootBlockView rootBlock1 = rbu.rootBlock1;
            if (!temporary) {
                FileChannelUtility.writeAll(this.opener, rootBlock0.asReadOnlyBuffer(), 8L);
                FileChannelUtility.writeAll(this.opener, rootBlock1.asReadOnlyBuffer(), 348L);
                this.opener.reopenChannel().force(true);
            }
            this.rootBlock = rootBlock0;
            switch (bufferMode) {
                case Direct: {
                    this.buffer = useDirectBuffers ? ByteBuffer.allocateDirect((int)this.userExtent) : ByteBuffer.allocate((int)this.userExtent);
                    break;
                }
                case Mapped: {
                    if (INFO) {
                        log.info("Mapping file=" + file);
                    }
                    this.buffer = this.opener.reopenChannel().map(FileChannel.MapMode.READ_WRITE, 688L, this.userExtent);
                    break;
                }
                case TemporaryRW: 
                case DiskRW: {
                    this.buffer = null;
                    break;
                }
                case Disk: {
                    this.buffer = null;
                    break;
                }
                case DiskWORM: {
                    this.buffer = null;
                    break;
                }
                case Temporary: {
                    this.buffer = null;
                    break;
                }
                case MemStore: {
                    this.buffer = null;
                    break;
                }
                default: {
                    throw new AssertionError();
                }
            }
            this.useChecksums = FileMetadata.useChecksums(this.rootBlock);
        }
        catch (IOException ex) {
            throw new RuntimeException("file=" + file, ex);
        }
    }

    FileMetadata(File file, boolean useDirectBuffers, boolean readOnly, ForceEnum forceWrites, boolean writeCacheEnabled, int writeCacheBufferCount, boolean validateChecksum, boolean alternateRootBlock, boolean ignoreBadRootBlock, Properties properties) throws RuntimeException {
        if (file == null) {
            throw new IllegalArgumentException();
        }
        if (!file.exists() || file.length() == 0L) {
            throw new IllegalArgumentException("File does not exist or is empty: " + file.getAbsolutePath());
        }
        if (readOnly && forceWrites != ForceEnum.No) {
            throw new IllegalArgumentException("'" + Options.FORCE_WRITES + "'='" + (Object)((Object)forceWrites) + "' may not be used with '" + Options.READ_ONLY + "'");
        }
        this.writeCacheEnabled = writeCacheEnabled;
        this.writeCacheBufferCount = writeCacheBufferCount;
        this.fileMode = readOnly ? "r" : forceWrites.asFileMode();
        this.readOnly = readOnly;
        this.exists = file.exists();
        this.file = file;
        this.properties = properties;
        try {
            this.opener.reopenChannel();
            this.extent = this.raf.length();
            this.userExtent = this.extent - 688L;
            if (this.extent <= 688L) {
                throw new RuntimeException("File too small to contain a valid journal: " + file.getAbsoluteFile());
            }
            this.raf.seek(0L);
            try {
                this.magic = this.raf.readInt();
            }
            catch (IOException ex) {
                throw new RuntimeException("Can not read magic. Is file locked by another process? file=" + file, ex);
            }
            if (this.magic != -424361355) {
                throw new RuntimeException("Bad journal magic: file=" + file + ", expected=" + -424361355 + ", actual=" + this.magic);
            }
            this.version = this.raf.readInt();
            if (this.version != 1) {
                throw new RuntimeException("Bad journal version: file=" + file + ", expected=" + 1 + ", actual=" + this.version);
            }
            RootBlockUtility tmp = new RootBlockUtility(this.opener, file, validateChecksum, alternateRootBlock, ignoreBadRootBlock);
            this.rootBlock = tmp.rootBlock;
            this.bufferMode = BufferMode.getDefaultBufferMode(this.rootBlock.getStoreType());
            if (this.userExtent > this.bufferMode.getMaxExtent()) {
                throw new RuntimeException("Would exceed maximum extent.");
            }
            this.offsetBits = this.rootBlock.getOffsetBits();
            this.nextOffset = this.rootBlock.getNextOffset();
            this.createTime = this.rootBlock.getCreateTime();
            this.closeTime = this.rootBlock.getCloseTime();
            if (this.closeTime != 0L && !readOnly) {
                throw new RuntimeException("Journal is closed for writes: file=" + file + ", closedTime=" + this.closeTime);
            }
            switch (this.bufferMode) {
                case Direct: {
                    ByteBuffer byteBuffer = this.buffer = useDirectBuffers ? ByteBuffer.allocateDirect((int)this.userExtent) : ByteBuffer.allocate((int)this.userExtent);
                    if (this.nextOffset > Integer.MAX_VALUE) {
                        throw new RuntimeException("This file is too large for a buffered mode: use " + (Object)((Object)BufferMode.Disk));
                    }
                    this.buffer.limit((int)this.nextOffset);
                    this.buffer.position(0);
                    if (this.nextOffset <= 0L) break;
                    FileChannelUtility.readAll(this.opener, this.buffer, 688L);
                    break;
                }
                case Mapped: {
                    boolean loadMappedFile = false;
                    this.buffer = this.opener.reopenChannel().map(FileChannel.MapMode.READ_WRITE, 688L, this.extent);
                    if (!loadMappedFile) break;
                    ((MappedByteBuffer)this.buffer).load();
                    break;
                }
                case Disk: {
                    this.buffer = null;
                    break;
                }
                case DiskWORM: {
                    this.buffer = null;
                    break;
                }
                case DiskRW: {
                    this.buffer = null;
                    break;
                }
                default: {
                    throw new AssertionError();
                }
            }
            this.useChecksums = FileMetadata.useChecksums(this.rootBlock);
        }
        catch (IOException ex) {
            throw new RuntimeException("file=" + file, ex);
        }
    }

    private final synchronized FileChannel reopenChannel() throws IOException {
        block10: {
            if (this.raf != null && this.raf.getChannel().isOpen()) {
                return this.raf.getChannel();
            }
            this.raf = new RandomAccessFile(this.file, this.fileMode);
            if (INFO) {
                log.info("(Re-)opened file: " + this.file);
            }
            if (this.bufferMode != BufferMode.Mapped) {
                try {
                    boolean readOnly = "r".equals(this.fileMode);
                    if (this.raf.getChannel().tryLock(0L, Long.MAX_VALUE, readOnly) != null) break block10;
                    try {
                        this.raf.close();
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                    throw new IOException("File already locked? file=" + this.file);
                }
                catch (IOException ex) {
                    if (INFO) {
                        log.info("FileLock not supported: file=" + this.file, ex);
                    }
                }
                catch (OverlappingFileLockException ex) {
                    if (INFO) {
                        log.info("FileLock problem: file=" + this.file, ex);
                    }
                    throw new RuntimeException("FileLock Overlap", ex);
                }
            }
        }
        return this.raf.getChannel();
    }

    private static boolean useChecksums(IRootBlockView rootBlock) {
        return rootBlock.getVersion() >= 2 || rootBlock.getVersion() == 1 && rootBlock.getStoreType() == StoreTypeEnum.RW;
    }

    public static FileMetadata createInstance(Properties properties, boolean isScaleout, long quorumToken) {
        Banner.banner();
        BufferMode bufferMode = BufferMode.valueOf(FileMetadata.getProperty(properties, Options.BUFFER_MODE, Options.DEFAULT_BUFFER_MODE));
        boolean create = Boolean.parseBoolean("true");
        boolean isEmptyFile = false;
        boolean createTempFile = Boolean.parseBoolean(FileMetadata.getProperty(properties, Options.CREATE_TEMP_FILE, "false"));
        File tmpDir = new File(FileMetadata.getProperty(properties, Options.TMP_DIR, System.getProperty("java.io.tmpdir")));
        if (createTempFile) {
            create = false;
            isEmptyFile = true;
            if (!tmpDir.exists() && !tmpDir.mkdirs()) {
                throw new RuntimeException("Could not create directory: " + tmpDir.getAbsolutePath());
            }
            if (!tmpDir.isDirectory()) {
                throw new RuntimeException("Not a directory: " + tmpDir.getAbsolutePath());
            }
        }
        String fname = FileMetadata.getProperty(properties, Options.FILE, null);
        if (createTempFile) {
            if (fname != null) {
                throw new RuntimeException("Can not use option '" + Options.CREATE_TEMP_FILE + "' with option '" + Options.FILE + "'");
            }
            try {
                fname = File.createTempFile("bigdata-" + (Object)((Object)bufferMode) + "-", ".jnl", tmpDir).toString();
            }
            catch (IOException ex) {
                throw new RuntimeException(ex);
            }
        } else if (fname == null) {
            throw new RuntimeException("Required property: '" + Options.FILE + "'");
        }
        File file = new File(fname);
        if (file.exists() && file.length() == 0L) {
            isEmptyFile = true;
        } else {
            File parent = file.getParentFile();
            if (parent != null && !parent.exists() && !parent.mkdirs()) {
                throw new RuntimeException("Could not create parent directory: " + parent);
            }
        }
        boolean useDirectBuffers = Boolean.parseBoolean(FileMetadata.getProperty(properties, Options.USE_DIRECT_BUFFERS, "false"));
        boolean readOnly = Boolean.parseBoolean(FileMetadata.getProperty(properties, Options.READ_ONLY, "false"));
        ForceEnum forceWrites = ForceEnum.parse(FileMetadata.getProperty(properties, Options.FORCE_WRITES, Options.DEFAULT_FORCE_WRITES));
        boolean deleteOnExit = Boolean.parseBoolean(FileMetadata.getProperty(properties, Options.DELETE_ON_EXIT, "false"));
        boolean writeCacheEnabled = Boolean.parseBoolean(FileMetadata.getProperty(properties, Options.WRITE_CACHE_ENABLED, "true"));
        int writeCacheBufferCount = Integer.parseInt(FileMetadata.getProperty(properties, Options.WRITE_CACHE_BUFFER_COUNT, "6"));
        boolean validateChecksum = Boolean.parseBoolean(FileMetadata.getProperty(properties, Options.VALIDATE_CHECKSUM, "true"));
        boolean alternateRootBlock = Boolean.parseBoolean(FileMetadata.getProperty(properties, Options.ALTERNATE_ROOT_BLOCK, "false"));
        boolean ignoreBadRootBlock = Boolean.parseBoolean(FileMetadata.getProperty(properties, Options.IGNORE_BAD_ROOT_BLOCK, "false"));
        if (alternateRootBlock && !readOnly) {
            log.warn("*** Using the alternate root block: Data will be lost on the next commit! ***");
        }
        if (file.exists() && !isEmptyFile) {
            return new FileMetadata(file, useDirectBuffers, readOnly, forceWrites, writeCacheEnabled, writeCacheBufferCount, validateChecksum, alternateRootBlock, ignoreBadRootBlock, properties);
        }
        long initialExtent = FileMetadata.getProperty(properties, Options.INITIAL_EXTENT, "10485760", new LongRangeValidator(0x100000L, Long.MAX_VALUE));
        long maximumExtent = FileMetadata.getProperty(properties, Options.MAXIMUM_EXTENT, "209715200", new LongRangeValidator(initialExtent, Long.MAX_VALUE));
        long createTime = Long.parseLong(FileMetadata.getProperty(properties, Options.CREATE_TIME, "" + System.currentTimeMillis()));
        int offsetBits = FileMetadata.getProperty(properties, Options.OFFSET_BITS, Integer.toString(!isScaleout ? 42 : 38), new IntegerRangeValidator(31, 60));
        return new FileMetadata(file, bufferMode, useDirectBuffers, initialExtent, maximumExtent, create, isEmptyFile, deleteOnExit, readOnly, forceWrites, offsetBits, writeCacheEnabled, writeCacheBufferCount, validateChecksum, createTime, quorumToken, alternateRootBlock, properties);
    }

    protected static String getProperty(Properties properties, String name, String defaultValue) {
        return Configuration.getProperty(null, properties, "", name, defaultValue);
    }

    protected static <E> E getProperty(Properties properties, String name, String defaultValue, IValidator<E> validator) {
        return Configuration.getProperty(null, properties, "", name, defaultValue, validator);
    }

    public String getProperty(String name, String defaultValue) {
        return FileMetadata.getProperty(this.properties, name, defaultValue);
    }

    public BufferMode getBufferMode() {
        return this.bufferMode;
    }
}

