/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.journal;

import com.bigdata.counters.AbstractStatisticsCollector;
import com.bigdata.counters.httpd.CounterSetHTTPD;
import com.bigdata.journal.IPlugIn;
import com.bigdata.journal.Journal;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import org.apache.log4j.Logger;

public class HttpPlugin
implements IPlugIn<Journal, CounterSetHTTPD> {
    private static final Logger log = Logger.getLogger(HttpPlugin.class);
    private CounterSetHTTPD httpd = null;
    private String httpdURL = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void startService(Journal indexManager) {
        String httpdURL;
        CounterSetHTTPD httpd;
        int httpdPort = Integer.valueOf(indexManager.getProperty(Options.HTTPD_PORT, "-1"));
        if (log.isInfoEnabled()) {
            log.info(Options.HTTPD_PORT + "=" + httpdPort + (httpdPort == -1 ? " (disabled)" : ""));
        }
        if (httpdPort == -1) {
            return;
        }
        try {
            httpd = new CounterSetHTTPD(httpdPort, indexManager);
        }
        catch (IOException e) {
            log.error("Could not start httpd: port=" + httpdPort, e);
            return;
        }
        try {
            httpdURL = "http://" + AbstractStatisticsCollector.fullyQualifiedHostName + ":" + httpd.getPort() + "/?path=" + URLEncoder.encode("", "UTF-8");
        }
        catch (UnsupportedEncodingException ex) {
            log.error("Could not start httpd: " + ex, ex);
            httpd.shutdownNow();
            return;
        }
        HttpPlugin httpPlugin = this;
        synchronized (httpPlugin) {
            this.httpd = httpd;
            this.httpdURL = httpdURL;
            if (log.isInfoEnabled()) {
                log.info("Performance counters: " + httpdURL);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void stopService(boolean immediateShutdown) {
        HttpPlugin httpPlugin = this;
        synchronized (httpPlugin) {
            if (this.httpd != null) {
                this.httpd.shutdown();
                this.httpd = null;
                this.httpdURL = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CounterSetHTTPD getService() {
        HttpPlugin httpPlugin = this;
        synchronized (httpPlugin) {
            return this.httpd;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isRunning() {
        HttpPlugin httpPlugin = this;
        synchronized (httpPlugin) {
            return this.httpd != null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final String getHttpdURL() {
        HttpPlugin httpPlugin = this;
        synchronized (httpPlugin) {
            return this.httpdURL;
        }
    }

    public static interface Options {
        public static final String HTTPD_PORT = Journal.class.getName() + ".httpdPort";
        public static final String DEFAULT_HTTPD_PORT = "-1";
    }
}

