/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.journal;

import com.bigdata.journal.BufferMode;
import com.bigdata.journal.DiskBackedBufferStrategy;
import com.bigdata.journal.FileMetadata;
import java.nio.MappedByteBuffer;

public class MappedBufferStrategy
extends DiskBackedBufferStrategy {
    final MappedByteBuffer mappedBuffer;

    @Override
    public boolean isFullyBuffered() {
        return false;
    }

    MappedBufferStrategy(long maximumExtent, FileMetadata fileMetadata) {
        super(maximumExtent, BufferMode.Mapped, fileMetadata);
        this.mappedBuffer = (MappedByteBuffer)fileMetadata.buffer;
    }

    @Override
    public void force(boolean metadata) {
        this.mappedBuffer.force();
        super.force(metadata);
    }

    @Override
    public void close() {
        super.close();
    }

    @Override
    public void deleteResources() {
        if (this.isOpen()) {
            throw new IllegalStateException();
        }
        if (!this.file.delete()) {
            log.warn("Could not delete memory-mapped file: " + this.file.getAbsoluteFile() + " - marked for deletion on exit");
            try {
                this.file.deleteOnExit();
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
        }
    }

    @Override
    public void truncate(long newExtent) {
        throw new UnsupportedOperationException("Mapped file may not be extended or truncated.");
    }
}

