/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.journal;

import com.bigdata.btree.BTree;
import com.bigdata.btree.Checkpoint;
import com.bigdata.btree.DefaultTupleSerializer;
import com.bigdata.btree.ICheckpointProtocol;
import com.bigdata.btree.IDirtyListener;
import com.bigdata.btree.IIndex;
import com.bigdata.btree.ITuple;
import com.bigdata.btree.ITupleIterator;
import com.bigdata.btree.IndexMetadata;
import com.bigdata.btree.keys.DefaultKeyBuilderFactory;
import com.bigdata.btree.keys.IKeyBuilder;
import com.bigdata.btree.keys.IKeyBuilderFactory;
import com.bigdata.btree.keys.KeyBuilder;
import com.bigdata.btree.keys.StrengthEnum;
import com.bigdata.btree.keys.SuccessorUtil;
import com.bigdata.cache.ConcurrentWeakValueCache;
import com.bigdata.cache.ConcurrentWeakValueCacheWithTimeout;
import com.bigdata.counters.CounterSet;
import com.bigdata.io.DataInputBuffer;
import com.bigdata.journal.ICommitter;
import com.bigdata.journal.IIndexManager;
import com.bigdata.journal.IndexExistsException;
import com.bigdata.journal.NoSuchIndexException;
import com.bigdata.mdi.LocalPartitionMetadata;
import com.bigdata.rawstore.IRawStore;
import com.bigdata.resources.ResourceManager;
import com.bigdata.util.BytesUtil;
import com.bigdata.util.concurrent.ExecutionExceptions;
import cutthecrap.utils.striterators.IStriterator;
import cutthecrap.utils.striterators.Resolver;
import cutthecrap.utils.striterators.Striterator;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.log4j.Logger;

public class Name2Addr
extends BTree {
    private static final Logger log = Logger.getLogger(Name2Addr.class);
    private ConcurrentWeakValueCache<String, ICheckpointProtocol> indexCache = null;
    private ConcurrentHashMap<String, DirtyListener> commitList = new ConcurrentHashMap();

    public static Name2Addr create(IRawStore store) {
        IndexMetadata metadata = new IndexMetadata(UUID.randomUUID());
        metadata.setBTreeClassName(Name2Addr.class.getName());
        Properties p = new Properties();
        p.setProperty(KeyBuilder.Options.STRENGTH, StrengthEnum.Identical.name());
        metadata.setTupleSerializer(new Name2AddrTupleSerializer(new DefaultKeyBuilderFactory(p)));
        return (Name2Addr)BTree.create(store, metadata);
    }

    public Name2Addr(IRawStore store, Checkpoint checkpoint, IndexMetadata metadata, boolean readOnly) {
        super(store, checkpoint, metadata, readOnly);
    }

    protected final void assertUnisolatedInstance() {
        if (this.indexCache == null) {
            throw new IllegalStateException();
        }
    }

    protected final boolean isUnisolatedInstance() {
        return this.indexCache != null;
    }

    protected void setupCache(int cacheCapacity, long cacheTimeout) {
        if (this.indexCache != null) {
            throw new IllegalStateException();
        }
        this.indexCache = new ConcurrentWeakValueCacheWithTimeout<String, ICheckpointProtocol>(cacheCapacity, TimeUnit.MILLISECONDS.toNanos(cacheTimeout));
    }

    private Iterator<Map.Entry<String, WeakReference<ICheckpointProtocol>>> indexCacheEntryIterator() {
        this.assertUnisolatedInstance();
        return this.indexCache.entryIterator();
    }

    public int getIndexCacheSize() {
        this.assertUnisolatedInstance();
        return this.indexCache.size();
    }

    public synchronized boolean willCommit(String name) {
        this.assertUnisolatedInstance();
        return this.commitList.containsKey(name);
    }

    @Override
    public synchronized long handleCommit(long commitTime) {
        List futures;
        this.assertUnisolatedInstance();
        Object[] a = this.commitList.values().toArray(new DirtyListener[0]);
        this.commitList.clear();
        Arrays.sort(a);
        if (log.isInfoEnabled()) {
            log.info("Store file=" + this.getStore().getFile());
            log.info("There are " + a.length + " dirty indices : " + Arrays.toString(a));
        }
        ArrayList<CommitIndexTask> tasks = new ArrayList<CommitIndexTask>(a.length);
        for (int i = 0; i < a.length; ++i) {
            Object l = a[i];
            if (log.isInfoEnabled()) {
                log.info("Will commit: " + ((DirtyListener)l).name);
            }
            tasks.add(new CommitIndexTask((DirtyListener)l, commitTime));
        }
        try {
            ExecutorService executorService = ((IIndexManager)((Object)this.getStore())).getExecutorService();
            futures = executorService.invokeAll(tasks);
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
        LinkedList<Exception> causes = new LinkedList<Exception>();
        for (Future f : futures) {
            try {
                Entry oldEntry;
                CommitIndexTask task = (CommitIndexTask)f.get();
                DirtyListener l = task.l;
                long checkpointAddr = task.getCheckpointAddr();
                byte[] key = this.getKey(l.name);
                byte[] val = this.lookup(key);
                Entry entry = oldEntry = val == null ? null : EntrySerializer.INSTANCE.deserialize(new DataInputBuffer(val));
                if (oldEntry != null && oldEntry.checkpointAddr == checkpointAddr && oldEntry.commitTime != 0L) continue;
                Entry entry2 = new Entry(l.name, checkpointAddr, commitTime);
                this.insert(key, EntrySerializer.INSTANCE.serialize(entry2));
            }
            catch (InterruptedException e) {
                log.error("l.name: " + e, e);
                causes.add(e);
            }
            catch (ExecutionException e) {
                log.error("l.name: " + e, e);
                causes.add(e);
            }
        }
        if (!causes.isEmpty()) {
            if (causes.size() == 1) {
                throw new RuntimeException((Throwable)causes.get(0));
            }
            throw new RuntimeException("nerrors=" + causes.size(), new ExecutionExceptions(causes));
        }
        return super.handleCommit(commitTime);
    }

    private byte[] getKey(String name) {
        byte[] a = this.metadata.getTupleSerializer().serializeKey(name);
        return a;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ICheckpointProtocol getIndex(String name) {
        ICheckpointProtocol ndx;
        this.assertUnisolatedInstance();
        if (name == null) {
            throw new IllegalArgumentException();
        }
        Name2Addr name2Addr = this;
        synchronized (name2Addr) {
            ndx = this.indexCache.get(name);
        }
        if (ndx != null) {
            if (ndx.getDirtyListener() == null) {
                throw new AssertionError();
            }
            assert (((DirtyListener)ndx.getDirtyListener()).getName2Addr() == this);
            return ndx;
        }
        byte[] val = super.lookup(this.getKey(name));
        if (val == null) {
            return null;
        }
        Entry entry = EntrySerializer.INSTANCE.deserialize(new DataInputStream(new ByteArrayInputStream(val)));
        ndx = Checkpoint.loadFromCheckpoint(this.store, entry.checkpointAddr, false);
        ndx.setLastCommitTime(entry.commitTime);
        this.putIndexCache(name, ndx, false);
        DirtyListener l = new DirtyListener(name, ndx, false);
        ndx.setDirtyListener(l);
        ResourceManager.openUnisolatedIndex(name);
        return ndx;
    }

    public Entry getEntry(String name) {
        byte[] val = super.lookup(this.getKey(name));
        Entry entry = null;
        if (val != null) {
            entry = EntrySerializer.INSTANCE.deserialize(new DataInputBuffer(val));
        }
        return entry;
    }

    public synchronized void registerIndex(String name, ICheckpointProtocol btree) {
        this.assertUnisolatedInstance();
        if (name == null) {
            throw new IllegalArgumentException();
        }
        if (btree == null) {
            throw new IllegalArgumentException();
        }
        byte[] key = this.getKey(name);
        if (super.contains(key)) {
            throw new IndexExistsException(name);
        }
        long checkpointAddr = btree.writeCheckpoint();
        Entry entry = new Entry(name, checkpointAddr, 0L);
        super.insert(key, EntrySerializer.INSTANCE.serialize(entry));
        this.putOnCommitList(name, btree, false);
        ResourceManager.openUnisolatedIndex(name);
    }

    protected synchronized void putOnCommitList(String name, ICheckpointProtocol btree, boolean needsCheckpoint) {
        this.assertUnisolatedInstance();
        if (name == null) {
            throw new IllegalArgumentException();
        }
        if (btree == null) {
            throw new IllegalArgumentException();
        }
        DirtyListener l = new DirtyListener(name, btree, needsCheckpoint);
        btree.setDirtyListener(l);
        this.putIndexCache(name, btree, true);
        this.commitList.put(name, l);
        if (log.isInfoEnabled()) {
            log.info("name=" + name + ", commitListSize=" + this.commitList.size() + ", needsCheckpoint=" + needsCheckpoint + ", file=" + this.getStore().getFile());
        }
    }

    protected synchronized void putIndexCache(String name, ICheckpointProtocol btree, boolean replace) {
        this.assertUnisolatedInstance();
        if (replace) {
            this.indexCache.put(name, btree);
        } else {
            this.indexCache.putIfAbsent(name, btree);
        }
    }

    protected synchronized ICheckpointProtocol getIndexCache(String name) {
        this.assertUnisolatedInstance();
        return this.indexCache.get(name);
    }

    public synchronized void dropIndex(String name) {
        byte[] key;
        this.assertUnisolatedInstance();
        if (name == null) {
            throw new IllegalArgumentException();
        }
        if (log.isInfoEnabled()) {
            log.info("name=" + name);
        }
        if (!super.contains(key = this.getKey(name))) {
            throw new NoSuchIndexException("Not registered: " + name);
        }
        ICommitter btree = this.indexCache.remove(name);
        if (btree != null) {
            this.commitList.remove(name);
            ((ICheckpointProtocol)btree).setDirtyListener(null);
        }
        super.remove(key);
        ResourceManager.dropUnisolatedIndex(name);
    }

    @Override
    public void invalidate(Throwable t) {
        if (t == null) {
            throw new IllegalArgumentException();
        }
        Iterator<Map.Entry<String, WeakReference<ICheckpointProtocol>>> itr = this.indexCacheEntryIterator();
        while (itr.hasNext()) {
            Map.Entry<String, WeakReference<ICheckpointProtocol>> e = itr.next();
            ICheckpointProtocol chk = (ICheckpointProtocol)e.getValue().get();
            if (chk == null) continue;
            chk.invalidate(t);
        }
        this.indexCache.clear();
    }

    protected CounterSet getIndexCounters(CounterSet counterSet, Set<String> found) {
        this.assertUnisolatedInstance();
        CounterSet tmp = counterSet == null ? new CounterSet() : counterSet;
        Iterator<Map.Entry<String, WeakReference<ICheckpointProtocol>>> itr = this.indexCacheEntryIterator();
        while (itr.hasNext()) {
            Map.Entry<String, WeakReference<ICheckpointProtocol>> entry = itr.next();
            String name = entry.getKey();
            ICheckpointProtocol btree = (ICheckpointProtocol)entry.getValue().get();
            if (btree == null) continue;
            IndexMetadata md = btree.getIndexMetadata();
            LocalPartitionMetadata pmd = md.getPartitionMetadata();
            String path = pmd != null ? md.getName() + "/" + name : name;
            tmp.makePath(path).attach(btree.getCounters());
            if (found == null) continue;
            found.add(name);
        }
        return tmp;
    }

    public static final Iterator<String> indexNameScan(String prefix, IIndex n2a) {
        byte[] toKey;
        byte[] fromKey;
        boolean hasPrefix;
        boolean bl = hasPrefix = prefix != null && prefix.length() > 0;
        if (hasPrefix) {
            IKeyBuilder keyBuilder = n2a.getIndexMetadata().getPrimaryKeyBuilder();
            fromKey = keyBuilder.reset().append(prefix).getKey();
            toKey = SuccessorUtil.successor((byte[])fromKey.clone());
            if (log.isDebugEnabled()) {
                log.error("fromKey=" + BytesUtil.toString(fromKey));
                log.error("toKey  =" + BytesUtil.toString(toKey));
            }
        } else {
            fromKey = null;
            toKey = null;
        }
        ITupleIterator itr = n2a.rangeIterator(fromKey, toKey);
        IStriterator sitr = new Striterator(itr).addFilter(new Resolver(){
            private static final long serialVersionUID = 1L;

            @Override
            protected Object resolve(Object obj) {
                return ((Entry)((ITuple)obj).getObject()).name;
            }
        });
        return sitr;
    }

    public static class Name2AddrTupleSerializer
    extends DefaultTupleSerializer<String, Entry> {
        private static final long serialVersionUID = 5699568938604974463L;
        private final EntrySerializer ser = EntrySerializer.INSTANCE;
        private static final transient byte VERSION0 = 0;
        private static final transient byte VERSION = 0;

        public Name2AddrTupleSerializer() {
        }

        public Name2AddrTupleSerializer(IKeyBuilderFactory keyBuilderFactory) {
            super(keyBuilderFactory);
        }

        @Override
        public byte[] serializeKey(Object obj) {
            IKeyBuilder keyBuilder = this.getKeyBuilder();
            byte[] a = keyBuilder.reset().append((String)obj).getKey();
            return a;
        }

        @Override
        public byte[] serializeVal(Entry entry) {
            return this.ser.serialize(entry);
        }

        @Override
        public Entry deserialize(ITuple tuple) {
            return this.ser.deserialize(tuple.getValueStream());
        }

        @Override
        public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
            super.readExternal(in);
            byte version = in.readByte();
            switch (version) {
                case 0: {
                    break;
                }
                default: {
                    throw new UnsupportedOperationException("Unknown version: " + version);
                }
            }
        }

        @Override
        public void writeExternal(ObjectOutput out) throws IOException {
            super.writeExternal(out);
            out.writeByte(0);
        }
    }

    public static class EntrySerializer {
        public static final transient EntrySerializer INSTANCE = new EntrySerializer();

        private EntrySerializer() {
        }

        public byte[] serialize(Entry entry) {
            try {
                int capacity = 8 + entry.name.length() * 2;
                ByteArrayOutputStream baos = new ByteArrayOutputStream(capacity);
                DataOutputStream os = new DataOutputStream(baos);
                os.writeLong(entry.commitTime);
                os.writeLong(entry.checkpointAddr);
                os.writeUTF(entry.name);
                return baos.toByteArray();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }

        public Entry deserialize(DataInput in) {
            try {
                long commitTime = in.readLong();
                long checkpointAddr = in.readLong();
                String name = in.readUTF();
                return new Entry(name, checkpointAddr, commitTime);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }

    public static class Entry {
        public final String name;
        public final long checkpointAddr;
        public final long commitTime;

        public Entry(String name, long checkpointAddr, long commitTime) {
            this.name = name;
            this.checkpointAddr = checkpointAddr;
            this.commitTime = commitTime;
        }

        public String toString() {
            return "Entry{name=" + this.name + ",checkpointAddr=" + this.checkpointAddr + ",commitTime=" + this.commitTime + "}";
        }
    }

    private static class CommitIndexTask
    implements Callable<CommitIndexTask> {
        private final DirtyListener l;
        private final long commitTime;
        private final AtomicLong checkpointAddr = new AtomicLong(0L);

        public long getCheckpointAddr() {
            return this.checkpointAddr.get();
        }

        public CommitIndexTask(DirtyListener l, long commitTime) {
            if (l == null) {
                throw new IllegalArgumentException();
            }
            this.l = l;
            this.commitTime = commitTime;
        }

        @Override
        public CommitIndexTask call() throws Exception {
            long checkpointAddr;
            if (log.isInfoEnabled()) {
                log.info("Will commit: " + this.l.name);
            }
            if (this.l.needsCheckpoint) {
                try {
                    checkpointAddr = this.l.btree.handleCommit(this.commitTime);
                    this.l.needsCheckpoint = false;
                }
                catch (Throwable t) {
                    throw new RuntimeException("Could not commit index: name=" + this.l.name, t);
                }
            } else {
                checkpointAddr = this.l.checkpointAddr;
                if (checkpointAddr == 0L) {
                    throw new RuntimeException("Checkpoint address not written: name=" + this.l.name);
                }
            }
            this.l.btree.setLastCommitTime(this.commitTime);
            this.checkpointAddr.set(checkpointAddr);
            return this;
        }
    }

    private class DirtyListener
    implements IDirtyListener,
    Comparable<DirtyListener> {
        final String name;
        final ICheckpointProtocol btree;
        boolean needsCheckpoint;
        long checkpointAddr = 0L;

        public String toString() {
            return "DirtyListener{name=" + this.name + "," + (this.needsCheckpoint ? "needsCheckpoint" : "checkpointAddr=" + this.checkpointAddr) + "}";
        }

        private DirtyListener(String name, ICheckpointProtocol btree, boolean needsCheckpoint) {
            assert (name != null);
            assert (btree != null);
            this.name = name;
            this.btree = btree;
            this.needsCheckpoint = needsCheckpoint;
            if (!needsCheckpoint) {
                try {
                    this.checkpointAddr = btree.getCheckpoint().getCheckpointAddr();
                }
                catch (IllegalStateException ex) {
                    throw new RuntimeException("Checkpoint record not written: " + name);
                }
            }
        }

        private Name2Addr getName2Addr() {
            return Name2Addr.this;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void dirtyEvent(ICheckpointProtocol btree) {
            assert (btree == this.btree);
            Name2Addr name2Addr = Name2Addr.this;
            synchronized (name2Addr) {
                ICheckpointProtocol cached = (ICheckpointProtocol)Name2Addr.this.indexCache.get(this.name);
                if (cached == null) {
                    throw new RuntimeException("No index in cache: name=" + this.name);
                }
                if (cached != btree) {
                    throw new RuntimeException("Different index in cache: " + this.name);
                }
                boolean added = Name2Addr.this.commitList.putIfAbsent(this.name, this) != null;
                this.needsCheckpoint = true;
                this.checkpointAddr = 0L;
                if (log.isInfoEnabled()) {
                    log.info("name=" + this.name + ", commitListSize=" + Name2Addr.this.commitList.size() + ", file=" + Name2Addr.this.getStore().getFile());
                }
            }
        }

        @Override
        public int compareTo(DirtyListener arg0) {
            return this.name.compareTo(arg0.name);
        }
    }
}

