/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.journal;

import com.bigdata.counters.AbstractStatisticsCollector;
import com.bigdata.journal.IPlugIn;
import com.bigdata.journal.Journal;
import java.util.Properties;
import org.apache.log4j.Logger;

public class PlatformStatsPlugIn
implements IPlugIn<Journal, AbstractStatisticsCollector> {
    private static final Logger log = Logger.getLogger(PlatformStatsPlugIn.class);
    private AbstractStatisticsCollector platformStatisticsCollector = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void startService(Journal indexManager) {
        boolean collectPlatformStatistics = Boolean.valueOf(indexManager.getProperty(Options.COLLECT_PLATFORM_STATISTICS, "false"));
        if (log.isInfoEnabled()) {
            log.info(Options.COLLECT_PLATFORM_STATISTICS + "=" + collectPlatformStatistics);
        }
        if (!collectPlatformStatistics) {
            return;
        }
        Properties p = indexManager.getProperties();
        if (p.getProperty(AbstractStatisticsCollector.Options.PROCESS_NAME) == null) {
            p.setProperty(AbstractStatisticsCollector.Options.PROCESS_NAME, "service/" + Journal.class.getName());
        }
        try {
            AbstractStatisticsCollector tmp = AbstractStatisticsCollector.newInstance(p);
            tmp.start();
            PlatformStatsPlugIn platformStatsPlugIn = this;
            synchronized (platformStatsPlugIn) {
                this.platformStatisticsCollector = tmp;
            }
            if (log.isInfoEnabled()) {
                log.info("Collecting platform statistics.");
            }
        }
        catch (Throwable t) {
            log.error(t, t);
        }
    }

    @Override
    public void stopService(boolean immediateShutdown) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public AbstractStatisticsCollector getService() {
        PlatformStatsPlugIn platformStatsPlugIn = this;
        synchronized (platformStatsPlugIn) {
            return this.platformStatisticsCollector;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isRunning() {
        PlatformStatsPlugIn platformStatsPlugIn = this;
        synchronized (platformStatsPlugIn) {
            return this.platformStatisticsCollector != null;
        }
    }

    public static interface Options
    extends AbstractStatisticsCollector.Options {
        public static final String COLLECT_PLATFORM_STATISTICS = Journal.class.getName() + ".collectPlatformStatistics";
        public static final String DEFAULT_COLLECT_PLATFORM_STATISTICS = "false";
    }
}

