/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.journal;

import com.bigdata.btree.IIndex;
import com.bigdata.btree.IndexMetadata;
import com.bigdata.journal.AbstractTask;
import com.bigdata.journal.IConcurrencyManager;
import java.util.UUID;

public class RegisterIndexTask
extends AbstractTask<UUID> {
    private final IndexMetadata metadata;

    public RegisterIndexTask(IConcurrencyManager concurrencyManager, String name, IndexMetadata metadata) {
        super(concurrencyManager, 0L, name);
        if (metadata == null) {
            throw new NullPointerException();
        }
        this.metadata = metadata;
    }

    @Override
    protected UUID doTask() throws Exception {
        String name = this.getOnlyResource();
        IIndex ndx = this.getJournal().getIndex(name);
        if (ndx != null) {
            UUID indexUUID = ndx.getIndexMetadata().getIndexUUID();
            if (log.isInfoEnabled()) {
                log.info("Index exists: name=" + name + ", indexUUID=" + indexUUID);
            }
            return indexUUID;
        }
        ndx = this.getJournal().registerIndex(name, this.metadata);
        UUID indexUUID = ndx.getIndexMetadata().getIndexUUID();
        if (log.isInfoEnabled()) {
            log.info("Registered index: name=" + name + ", class=" + ndx.getClass() + ", indexUUID=" + indexUUID);
        }
        return indexUUID;
    }
}

