/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.journal;

import com.bigdata.io.ChecksumUtility;
import com.bigdata.journal.IRootBlockView;
import com.bigdata.journal.RWAddressManager;
import com.bigdata.journal.RootBlockException;
import com.bigdata.journal.StoreTypeEnum;
import com.bigdata.rawstore.IAddressManager;
import com.bigdata.rawstore.WormAddressManager;
import java.nio.ByteBuffer;
import java.sql.Date;
import java.text.DateFormat;
import java.util.UUID;
import org.apache.log4j.Logger;

public class RootBlockView
implements IRootBlockView {
    private static final Logger log = Logger.getLogger(RootBlockView.class);
    static final transient short SIZEOF_TIMESTAMP = 8;
    static final transient short SIZEOF_MAGIC = 4;
    static final transient short SIZEOF_VERSION = 4;
    static final transient short SIZEOF_ADDR = 8;
    static final transient short SIZEOF_COUNTER = 8;
    static final transient short SIZEOF_OFFSET = 8;
    static final transient short SIZEOF_CHECKSUM = 4;
    static final transient short SIZEOF_QTOKEN = 8;
    static final transient short SIZEOF_BLOCKSEQ = 8;
    static final transient short SIZEOF_UNUSED = 190;
    static final transient short OFFSET_CHALLIS0 = 0;
    static final transient short OFFSET_MAGIC = 8;
    static final transient short OFFSET_VERSION = 12;
    static final transient short OFFSET_OFFSET_BITS = 16;
    static final transient short OFFSET_NEXT_OFFSET = 17;
    static final transient short OFFSET_LOCAL_TIME = 25;
    static final transient short OFFSET_FIRST_CMIT = 33;
    static final transient short OFFSET_LAST_CMIT = 41;
    static final transient short OFFSET_COMMIT_CTR = 49;
    static final transient short OFFSET_COMMIT_REC = 57;
    static final transient short OFFSET_COMMIT_NDX = 65;
    static final transient short OFFSET_CREATE_TIME = 73;
    static final transient short OFFSET_CLOSE_TIME = 81;
    static final transient short OFFSET_UNUSED = 89;
    static final transient short OFFSET_BLOCKSEQ = 279;
    static final transient short OFFSET_QTOKEN = 287;
    static final transient short OFFSET_META_BITS = 295;
    static final transient short OFFSET_META_START = 303;
    static final transient short OFFSET_STORETYPE = 311;
    static final transient short OFFSET_UUID = 312;
    static final transient short OFFSET_CHALLIS1 = 328;
    static final transient short OFFSET_CHECKSUM = 336;
    public static final transient short SIZEOF_ROOT_BLOCK = 340;
    static final int MAGIC = 1711153596;
    static final int VERSION0 = 0;
    static final int VERSION1 = 1;
    static final int VERSION2 = 2;
    static final int VERSION3 = 3;
    public static final int currentVersion = 3;
    private final ByteBuffer buf;
    private final boolean rootBlock0;
    private final ChecksumUtility checker;
    private final IAddressManager am;
    private volatile int hash = 0;

    @Override
    public boolean isRootBlock0() {
        return this.rootBlock0;
    }

    private static void assertLegalAddr(IAddressManager am, long nextOffset, long addr, String label) {
        int nbytes;
        if (addr == 0L) {
            return;
        }
        if (am instanceof RWAddressManager) {
            return;
        }
        long offset = am.getOffset(addr);
        long nextOffset2 = offset + (long)(nbytes = am.getByteCount(addr));
        if (nextOffset2 > nextOffset) {
            throw new IllegalArgumentException(label + " address range [" + am.getOffset(addr) + ":" + am.getOffset(addr) + am.getByteCount(addr) + "] exceeds use extent: nextOffset=" + nextOffset + ", addr=" + am.toString(addr));
        }
    }

    public RootBlockView(boolean rootBlock0, int offsetBits, long nextOffset, long firstCommitTime, long lastCommitTime, long commitCounter, long commitRecordAddr, long commitRecordIndexAddr, UUID uuid, long blockSequence, long quorumToken, long metaStartAddr, long metaBitsAddr, StoreTypeEnum storeTypeEnum, long createTime, long closeTime, int version, ChecksumUtility checker) {
        if (storeTypeEnum == null) {
            throw new IllegalArgumentException("storeType is null");
        }
        switch (storeTypeEnum) {
            case RW: {
                this.am = new RWAddressManager(null);
                break;
            }
            case WORM: {
                if (metaStartAddr != 0L) {
                    throw new RootBlockException("metaStartAddr must be ZERO (0L) for WORM.");
                }
                if (metaBitsAddr != 0L) {
                    throw new RootBlockException("metaBitsAddr must be ZERO (0L) for WORM.");
                }
                this.am = new WormAddressManager(offsetBits);
                WormAddressManager.assertOffsetBits(offsetBits);
                ((WormAddressManager)this.am).assertOffset(nextOffset);
                break;
            }
            default: {
                throw new RootBlockException("Unknown storeType: " + (Object)((Object)storeTypeEnum));
            }
        }
        if (firstCommitTime == 0L && lastCommitTime != 0L) {
            throw new IllegalArgumentException("first transaction identifier is zero, but last transaction identifier is not: lastCommitTime=" + lastCommitTime);
        }
        if (firstCommitTime != 0L && lastCommitTime < firstCommitTime) {
            log.warn("last transaction identifier is less than first transaction identifier: lastCommitTime=" + lastCommitTime + ", firstCommitTime=" + firstCommitTime);
        }
        if (commitCounter < 0L) {
            throw new IllegalArgumentException("commit counter is negative: commitCounter=" + commitCounter);
        }
        if (commitCounter == Long.MAX_VALUE) {
            throw new IllegalArgumentException("commit counter would overflow.");
        }
        RootBlockView.assertLegalAddr(this.am, nextOffset, commitRecordAddr, "Commit record");
        RootBlockView.assertLegalAddr(this.am, nextOffset, commitRecordIndexAddr, "Commit record index");
        if (commitCounter > 0L) {
            if (commitRecordAddr == 0L) {
                throw new IllegalArgumentException("The commit record must exist if the commit counter is non-zero: commitCounter=" + commitCounter);
            }
            if (commitRecordIndexAddr == 0L) {
                throw new IllegalArgumentException("The commit record index must exist if the commit counter is non-zero: commitCounter=" + commitCounter);
            }
        }
        if (commitRecordAddr != 0L && commitCounter == 0L) {
            throw new IllegalArgumentException("The commit counter must be greter than zero if there is a commit record: commitRecordAddr=" + commitRecordAddr + ", but commitCounter=" + commitCounter);
        }
        if (commitRecordAddr != 0L && commitRecordIndexAddr == 0L) {
            throw new IllegalArgumentException("The commit record index must exist if there is a commit record: commitRecordAddr=" + commitRecordAddr + ", but commitRecordIndexAddr=" + commitRecordIndexAddr);
        }
        if (commitRecordIndexAddr != 0L && commitRecordAddr == 0L) {
            throw new IllegalArgumentException("The commit record address must exist if there is a commit record index: commitRecordIndexAddr=" + commitRecordIndexAddr + ", but commitRecordAddr=" + commitRecordAddr);
        }
        if (uuid == null) {
            throw new IllegalArgumentException("UUID is null");
        }
        if (blockSequence < 0L) {
            throw new IllegalArgumentException("blockSequence is negative.");
        }
        if (quorumToken < 0L && quorumToken != -1L) {
            throw new IllegalArgumentException("quorum is negative but value is not NO_QUORUM(-1)");
        }
        if (createTime == 0L) {
            throw new IllegalArgumentException("Create time is zero.");
        }
        if (closeTime != 0L && closeTime < createTime) {
            throw new IllegalArgumentException("Close time proceeds create time: closeTime=" + closeTime + ", createTime=" + createTime);
        }
        if (checker == null) {
            throw new IllegalArgumentException("Checker is null");
        }
        this.checker = checker;
        this.buf = ByteBuffer.allocate(340);
        this.rootBlock0 = rootBlock0;
        long challisField = commitCounter;
        long localTime = System.currentTimeMillis();
        this.buf.putLong(challisField);
        this.buf.putInt(1711153596);
        this.buf.putInt(version);
        this.buf.put((byte)offsetBits);
        this.buf.putLong(nextOffset);
        this.buf.putLong(localTime);
        this.buf.putLong(firstCommitTime);
        this.buf.putLong(lastCommitTime);
        this.buf.putLong(commitCounter);
        this.buf.putLong(commitRecordAddr);
        this.buf.putLong(commitRecordIndexAddr);
        this.buf.putLong(createTime);
        this.buf.putLong(closeTime);
        this.buf.position(this.buf.position() + 190);
        this.buf.putLong(blockSequence);
        this.buf.putLong(quorumToken);
        this.buf.putLong(metaBitsAddr);
        this.buf.putLong(metaStartAddr);
        this.buf.put(storeTypeEnum.getType());
        this.buf.putLong(uuid.getMostSignificantBits());
        this.buf.putLong(uuid.getLeastSignificantBits());
        this.buf.putLong(challisField);
        this.buf.putInt(this.calcChecksum(checker));
        assert (this.buf.position() == 340) : "position=" + this.buf.position() + " but root block is " + 340 + " bytes";
        assert (this.buf.limit() == 340);
        this.buf.position(0);
    }

    @Override
    public ByteBuffer asReadOnlyBuffer() {
        return this.buf.asReadOnlyBuffer();
    }

    @Override
    public IRootBlockView asRootBlock(boolean rootBlock0) {
        if (rootBlock0 && this.isRootBlock0()) {
            return this;
        }
        if (!rootBlock0 && !this.isRootBlock0()) {
            return this;
        }
        return new RootBlockView(rootBlock0, this.asReadOnlyBuffer(), this.checker);
    }

    public int hashCode() {
        if (this.hash == 0) {
            this.hash = this.buf.asReadOnlyBuffer().hashCode();
        }
        return this.hash;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof IRootBlockView)) {
            return false;
        }
        IRootBlockView o2 = (IRootBlockView)o;
        return this.buf.asReadOnlyBuffer().equals(o2.asReadOnlyBuffer());
    }

    public RootBlockView(boolean rootBlock0, ByteBuffer buf, ChecksumUtility checker) throws RootBlockException {
        if (buf == null) {
            throw new IllegalArgumentException();
        }
        if (buf.remaining() != 340) {
            throw new IllegalArgumentException("Expecting 340 remaining, actual=" + buf.remaining());
        }
        this.buf = buf.asReadOnlyBuffer();
        this.rootBlock0 = rootBlock0;
        switch (this.getStoreType()) {
            case RW: {
                this.am = new RWAddressManager(null);
                break;
            }
            case WORM: {
                int offsetBits = this.getOffsetBits();
                this.am = new WormAddressManager(offsetBits);
                break;
            }
            default: {
                throw new RootBlockException("Unknown storeType=" + (Object)((Object)this.getStoreType()));
            }
        }
        if (checker == null) {
            log.warn("Checksum will not be validated");
        }
        this.checker = checker;
        this.valid();
    }

    @Override
    public int getVersion() {
        return this.buf.getInt(12);
    }

    @Override
    public int getOffsetBits() {
        return this.buf.get(16);
    }

    @Override
    public long getNextOffset() {
        return this.buf.getLong(17);
    }

    public long getLocalTime() {
        return this.buf.getLong(25);
    }

    @Override
    public long getFirstCommitTime() {
        return this.buf.getLong(33);
    }

    @Override
    public long getLastCommitTime() {
        return this.buf.getLong(41);
    }

    public long getChallisField() throws RootBlockException {
        long timestamp1;
        long timestamp0 = this.buf.getLong(0);
        if (timestamp0 != (timestamp1 = this.buf.getLong(328))) {
            throw new RootBlockException("Timestamps differ: " + timestamp0 + " vs " + timestamp1);
        }
        return timestamp0;
    }

    @Override
    public long getCommitCounter() {
        return this.buf.getLong(49);
    }

    @Override
    public long getCommitRecordAddr() {
        return this.buf.getLong(57);
    }

    @Override
    public long getCommitRecordIndexAddr() {
        return this.buf.getLong(65);
    }

    @Override
    public void valid() {
        int magic = this.buf.getInt(8);
        if (magic != 1711153596) {
            throw new RootBlockException("MAGIC: expected=1711153596, actual=" + magic);
        }
        int version = this.buf.getInt(12);
        switch (version) {
            case 0: 
            case 1: 
            case 2: 
            case 3: {
                break;
            }
            default: {
                throw new RootBlockException("Unknown version: " + version);
            }
        }
        this.getChecksum(this.checker);
        this.getChallisField();
        if (this.getCreateTime() == 0L) {
            throw new RootBlockException("Create time should not be zero.");
        }
    }

    @Override
    public UUID getUUID() {
        return new UUID(this.buf.getLong(312), this.buf.getLong(320));
    }

    @Override
    public long getCreateTime() {
        return this.buf.getLong(73);
    }

    @Override
    public long getCloseTime() {
        return this.buf.getLong(81);
    }

    public int getChecksum(ChecksumUtility checker) throws RootBlockException {
        int storedChecksum = this.buf.getInt(336);
        if (checker == null) {
            log.info("Checksum not validated");
            return storedChecksum;
        }
        int actualChecksum = this.calcChecksum(checker);
        if (storedChecksum != 0 && storedChecksum != actualChecksum) {
            throw new RootBlockException("Checksum error");
        }
        return storedChecksum;
    }

    public int calcChecksum(ChecksumUtility checker) {
        if (checker == null) {
            throw new IllegalArgumentException();
        }
        return checker.checksum(this.buf, 0, 336);
    }

    public String toString() {
        DateFormat df = DateFormat.getDateTimeInstance(0, 0);
        StringBuilder sb = new StringBuilder();
        sb.append("rootBlock");
        sb.append("{ rootBlock=" + (this.isRootBlock0() ? 0 : 1));
        sb.append(", challisField=" + this.getChallisField());
        sb.append(", version=" + this.getVersion());
        sb.append(", nextOffset=" + this.getNextOffset());
        sb.append(", localTime=" + RootBlockView.toString(df, this.getLocalTime()));
        sb.append(", firstCommitTime=" + RootBlockView.toString(df, this.getFirstCommitTime()));
        sb.append(", lastCommitTime=" + RootBlockView.toString(df, this.getLastCommitTime()));
        sb.append(", commitCounter=" + this.getCommitCounter());
        sb.append(", commitRecordAddr=" + this.am.toString(this.getCommitRecordAddr()));
        sb.append(", commitRecordIndexAddr=" + this.am.toString(this.getCommitRecordIndexAddr()));
        sb.append(", blockSequence=" + this.getBlockSequence());
        sb.append(", quorumToken=" + this.getQuorumToken());
        sb.append(", metaBitsAddr=" + this.getMetaBitsAddr());
        sb.append(", metaStartAddr=" + this.getMetaStartAddr());
        sb.append(", storeType=" + (Object)((Object)this.getStoreType()));
        sb.append(", uuid=" + this.getUUID());
        sb.append(", offsetBits=" + this.getOffsetBits());
        sb.append(", checksum=" + (this.checker == null ? "N/A" : "" + this.calcChecksum(this.checker)));
        sb.append(", createTime=" + RootBlockView.toString(df, this.getCreateTime()));
        sb.append(", closeTime=" + RootBlockView.toString(df, this.getCloseTime()));
        sb.append("}");
        return sb.toString();
    }

    private static final String toString(DateFormat df, long t) {
        return Long.toString(t) + (t != 0L ? " [" + df.format(new Date(t)) + "]" : "");
    }

    private static DateFormat getDateFormat() {
        DateFormat df = DateFormat.getDateTimeInstance(0, 0);
        return df;
    }

    public static String toString(long t) {
        return RootBlockView.toString(RootBlockView.getDateFormat(), t);
    }

    @Override
    public long getMetaBitsAddr() {
        if (this.getVersion() < 1) {
            return 0L;
        }
        return this.buf.getLong(295);
    }

    @Override
    public long getMetaStartAddr() {
        if (this.getVersion() < 1) {
            return 0L;
        }
        return this.buf.getLong(303);
    }

    @Override
    public StoreTypeEnum getStoreType() {
        if (this.getVersion() < 1) {
            return StoreTypeEnum.WORM;
        }
        return StoreTypeEnum.valueOf(this.buf.get(311));
    }

    @Override
    public long getQuorumToken() {
        if (this.getVersion() < 2) {
            return -1L;
        }
        return this.buf.getLong(287);
    }

    @Override
    public long getBlockSequence() {
        if (this.getVersion() < 3) {
            return 0L;
        }
        return this.buf.getLong(279);
    }
}

