/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.journal;

import com.bigdata.btree.AbstractBTree;
import com.bigdata.btree.BTree;
import com.bigdata.btree.ILocalBTreeView;
import com.bigdata.btree.isolation.IsolatedFusedView;
import com.bigdata.journal.AbstractLocalTransactionManager;
import com.bigdata.journal.IResourceManager;
import com.bigdata.journal.ITx;
import com.bigdata.journal.RunState;
import com.bigdata.journal.TimestampUtility;
import com.bigdata.journal.ValidationError;
import com.bigdata.rawstore.IRawStore;
import com.bigdata.resources.ResourceManager;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.log4j.Logger;

public class Tx
implements ITx {
    private static final Logger log = Logger.getLogger(Tx.class);
    protected static final String NOT_ACTIVE = "Not active";
    protected static final String NOT_PREPARED = "Transaction is not prepared";
    protected static final String NOT_COMMITTED = "Transaction is not committed";
    protected static final String IS_COMPLETE = "Transaction is complete";
    public final ReentrantLock lock = new ReentrantLock();
    private final IResourceManager resourceManager;
    private final long startTime;
    private final long readsOnCommitTime;
    private final int hashCode;
    private final boolean readOnly;
    private long revisionTime = 0L;
    private final AtomicReference<RunState> runState = new AtomicReference();
    private final ConcurrentHashMap<String, ILocalBTreeView> indices;
    private static final String[] EMPTY_ARRAY = new String[0];

    public long getRevisionTime() {
        return this.revisionTime;
    }

    @Override
    public long getReadsOnCommitTime() {
        return this.readsOnCommitTime;
    }

    @Override
    public boolean isReadOnly() {
        return this.readOnly;
    }

    public Tx(AbstractLocalTransactionManager localTransactionManager, IResourceManager resourceManager, long startTime, long readsOnCommitTime) {
        if (localTransactionManager == null) {
            throw new IllegalArgumentException();
        }
        if (resourceManager == null) {
            throw new IllegalArgumentException();
        }
        this.readOnly = !TimestampUtility.isReadWriteTx(startTime);
        this.indices = this.readOnly ? null : new ConcurrentHashMap();
        this.resourceManager = resourceManager;
        this.startTime = startTime;
        this.readsOnCommitTime = readsOnCommitTime == 0L ? 1L : readsOnCommitTime;
        this.runState.set(RunState.Active);
        this.hashCode = Long.valueOf(startTime).hashCode();
        localTransactionManager.activateTx(this);
        ResourceManager.openTx(startTime);
    }

    public void setRunState(RunState newval) {
        if (!this.lock.isHeldByCurrentThread()) {
            throw new IllegalMonitorStateException();
        }
        if (newval == null) {
            throw new IllegalArgumentException();
        }
        if (!this.runState.get().isTransitionAllowed(newval)) {
            throw new IllegalStateException("runState=" + this.runState + ", newValue=" + (Object)((Object)newval));
        }
        this.runState.set(newval);
    }

    public final int hashCode() {
        return this.hashCode;
    }

    public final boolean equals(ITx o) {
        return this == o || o != null && this.startTime == o.getStartTimestamp();
    }

    @Override
    public final long getStartTimestamp() {
        return this.startTime;
    }

    public final String toString() {
        return "LocalTxState{startTime=" + this.startTime + ",readsOnCommitTime=" + this.readsOnCommitTime + ",runState=" + this.runState + "}";
    }

    @Override
    public final boolean isActive() {
        return this.runState.get() == RunState.Active;
    }

    @Override
    public final boolean isPrepared() {
        return this.runState.get() == RunState.Prepared;
    }

    @Override
    public final boolean isComplete() {
        RunState runState = this.runState.get();
        return runState == RunState.Committed || runState == RunState.Aborted;
    }

    @Override
    public final boolean isCommitted() {
        return this.runState.get() == RunState.Committed;
    }

    @Override
    public final boolean isAborted() {
        return this.runState.get() == RunState.Aborted;
    }

    public void prepare(long revisionTime) {
        if (this.readOnly) {
            throw new UnsupportedOperationException();
        }
        if (!this.lock.isHeldByCurrentThread()) {
            throw new IllegalMonitorStateException();
        }
        if (log.isInfoEnabled()) {
            log.info("tx=" + this);
        }
        if (!this.isActive()) {
            throw new IllegalStateException(NOT_ACTIVE);
        }
        if (!this.isEmptyWriteSet()) {
            if (!this.validateWriteSets()) {
                throw new ValidationError();
            }
            this.mergeOntoGlobalState(revisionTime);
        }
    }

    protected void releaseResources() {
        if (this.readOnly) {
            return;
        }
        assert (this.lock.isHeldByCurrentThread());
        if (!this.isComplete()) {
            throw new IllegalStateException();
        }
        this.indices.clear();
    }

    private IRawStore getTemporaryStore() {
        return this.resourceManager.getLiveJournal().getTempStore();
    }

    public boolean validateWriteSets() {
        for (Map.Entry<String, ILocalBTreeView> entry : this.indices.entrySet()) {
            String name = entry.getKey();
            IsolatedFusedView isolated = (IsolatedFusedView)entry.getValue();
            AbstractBTree[] sources = this.resourceManager.getIndexSources(name, 0L);
            if (sources == null) {
                log.warn("Index does not exist: " + name);
                return false;
            }
            if (isolated.validate(sources)) continue;
            if (log.isInfoEnabled()) {
                log.info("validation failed: " + name);
            }
            return false;
        }
        return true;
    }

    protected void mergeOntoGlobalState(long revisionTime) {
        List futures;
        this.revisionTime = revisionTime;
        LinkedList<CheckpointIndexTask> tasks = new LinkedList<CheckpointIndexTask>();
        for (Map.Entry<String, ILocalBTreeView> entry : this.indices.entrySet()) {
            String name = entry.getKey();
            IsolatedFusedView isolated = (IsolatedFusedView)entry.getValue();
            tasks.add(new CheckpointIndexTask(name, isolated));
        }
        try {
            futures = this.resourceManager.getLiveJournal().getExecutorService().invokeAll(tasks);
        }
        catch (InterruptedException ex) {
            throw new RuntimeException(ex);
        }
        for (Future f : futures) {
            try {
                f.get();
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
            catch (ExecutionException e) {
                throw new RuntimeException(e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ILocalBTreeView getIndex(String name) {
        if (name == null) {
            throw new IllegalArgumentException();
        }
        if (this.readOnly) {
            throw new UnsupportedOperationException();
        }
        this.lock.lock();
        try {
            if (!this.isActive()) {
                throw new IllegalStateException(NOT_ACTIVE);
            }
            if (this.indices.containsKey(name)) {
                ILocalBTreeView iLocalBTreeView = this.indices.get(name);
                return iLocalBTreeView;
            }
            AbstractBTree[] sources = this.resourceManager.getIndexSources(name, this.readsOnCommitTime);
            if (sources == null) {
                if (log.isInfoEnabled()) {
                    log.info("No such index: " + name + ", startTime=" + this.startTime);
                }
                ILocalBTreeView iLocalBTreeView = null;
                return iLocalBTreeView;
            }
            if (!sources[0].getIndexMetadata().isIsolatable()) {
                throw new RuntimeException("Not isolatable: " + name);
            }
            AbstractBTree[] b = new AbstractBTree[sources.length + 1];
            b[0] = BTree.create(this.getTemporaryStore(), sources[0].getIndexMetadata().clone());
            System.arraycopy(sources, 0, b, 1, sources.length);
            IsolatedFusedView index = new IsolatedFusedView(-this.startTime, b);
            ResourceManager.isolateIndex(this.startTime, name);
            this.indices.put(name, index);
            IsolatedFusedView isolatedFusedView = index;
            return isolatedFusedView;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final boolean isEmptyWriteSet() {
        if (this.readOnly) {
            return true;
        }
        this.lock.lock();
        try {
            for (IsolatedFusedView isolatedFusedView : this.indices.values()) {
                if (isolatedFusedView.isEmptyWriteSet()) continue;
                boolean bl = false;
                return bl;
            }
            boolean bl = true;
            return bl;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final String[] getDirtyResource() {
        if (this.readOnly) {
            return EMPTY_ARRAY;
        }
        this.lock.lock();
        try {
            String[] stringArray = this.indices.keySet().toArray(new String[this.indices.size()]);
            return stringArray;
        }
        finally {
            this.lock.unlock();
        }
    }

    private class CheckpointIndexTask
    implements Callable<Void> {
        private final String name;
        private final IsolatedFusedView isolated;

        public CheckpointIndexTask(String name, IsolatedFusedView isolated) {
            if (name == null) {
                throw new IllegalArgumentException();
            }
            if (isolated == null) {
                throw new IllegalArgumentException();
            }
            this.name = name;
            this.isolated = isolated;
        }

        @Override
        public Void call() throws Exception {
            if (log.isInfoEnabled()) {
                log.info("Writing checkpoint: " + this.name);
            }
            try {
                AbstractBTree[] sources = Tx.this.resourceManager.getIndexSources(this.name, 0L);
                if (sources == null) {
                    throw new AssertionError();
                }
                this.isolated.mergeDown(Tx.this.revisionTime, sources);
                this.isolated.getWriteSet().writeCheckpoint();
            }
            catch (Throwable t) {
                throw new RuntimeException("Could not commit index: name=" + this.name, t);
            }
            return null;
        }
    }
}

