/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.rdf;

import info.aduna.lang.service.FileFormatServiceRegistry;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.nio.charset.Charset;
import java.util.Arrays;
import org.apache.log4j.Logger;
import org.openrdf.query.resultio.TupleQueryResultParserFactory;
import org.openrdf.query.resultio.TupleQueryResultParserRegistry;
import org.openrdf.query.resultio.TupleQueryResultWriterFactory;
import org.openrdf.query.resultio.TupleQueryResultWriterRegistry;
import org.openrdf.rio.RDFFormat;
import org.openrdf.rio.RDFParserFactory;
import org.openrdf.rio.RDFParserRegistry;
import org.openrdf.rio.RDFWriterFactory;
import org.openrdf.rio.RDFWriterRegistry;

public class ServiceProviderHook {
    private static final Logger log = Logger.getLogger(ServiceProviderHook.class);
    public static final String NTRIPLES_PARSER_FACTORY = "com.bigdata.rdf.rio.ntriples.BigdataNTriplesParserFactory";
    public static final String TURTLE_PARSER_FACTORY = "com.bigdata.rdf.rio.turtle.BigdataTurtleParserFactory";
    public static final String TURTLE_WRITER_FACTORY = "com.bigdata.rdf.rio.turtle.BigdataTurtleWriterFactory";
    public static final String JSON_WRITER_FACTORY = "com.bigdata.rdf.rio.json.BigdataSPARQLResultsJSONWriterFactory";
    public static final String JSON_CONSTRUCT_WRITER_FACTORY = "com.bigdata.rdf.rio.json.BigdataSPARQLResultsJSONWriterForConstructFactory";
    public static final String JSON_RESULT_PARSER_FACTORY = "com.bigdata.rdf.rio.json.BigdataSPARQLResultsJSONParserFactory";
    public static final String JSON_CONSTRUCT_PARSER_FACTORY = "com.bigdata.rdf.rio.json.BigdataSPARQLResultsJSONParserForConstructFactory";
    private static boolean loaded = false;
    public static final RDFFormat TURTLE_RDR = new RDFFormat("Turtle-RDR", Arrays.asList("application/x-turtle-RDR"), Charset.forName("UTF-8"), Arrays.asList("ttlx"), true, false);
    public static final RDFFormat NTRIPLES_RDR = new RDFFormat("N-Triples-RDR", "application/x-n-triples-RDR", Charset.forName("US-ASCII"), "ntx", false, false);
    public static final RDFFormat JSON_RDR = new RDFFormat("SPARQL/JSON", Arrays.asList("application/sparql-results+json", "application/json"), Charset.forName("UTF-8"), Arrays.asList("srj", "json"), false, true);

    public static synchronized void forceLoad() {
        if (loaded) {
            return;
        }
        log.warn("Running.");
        if (log.isInfoEnabled()) {
            for (RDFFormat rDFFormat : RDFFormat.values()) {
                log.info("RDFFormat: before: " + rDFFormat);
            }
            for (RDFParserFactory rDFParserFactory : RDFParserRegistry.getInstance().getAll()) {
                log.info("RDFParserFactory: before: " + rDFParserFactory);
            }
            for (RDFWriterFactory rDFWriterFactory : RDFWriterRegistry.getInstance().getAll()) {
                log.info("RDFWriterFactory: before: " + rDFWriterFactory);
            }
            for (TupleQueryResultWriterFactory tupleQueryResultWriterFactory : TupleQueryResultWriterRegistry.getInstance().getAll()) {
                log.info("TupleQueryResultWriterFactory: before: " + tupleQueryResultWriterFactory);
            }
        }
        RDFFormat.register(TURTLE_RDR);
        RDFFormat.register(NTRIPLES_RDR);
        RDFFormat.register(JSON_RDR);
        FileFormatServiceRegistry r = RDFParserRegistry.getInstance();
        r.add((RDFParserFactory)ServiceProviderHook.getInstanceForClass(NTRIPLES_PARSER_FACTORY));
        assert (r.has(((RDFParserFactory)ServiceProviderHook.getInstanceForClass(NTRIPLES_PARSER_FACTORY)).getRDFFormat()));
        r.add((RDFParserFactory)ServiceProviderHook.getInstanceForClass(TURTLE_PARSER_FACTORY));
        assert (r.has(((RDFParserFactory)ServiceProviderHook.getInstanceForClass(TURTLE_PARSER_FACTORY)).getRDFFormat()));
        r.add((RDFParserFactory)ServiceProviderHook.getInstanceForClass(JSON_CONSTRUCT_PARSER_FACTORY));
        r = TupleQueryResultWriterRegistry.getInstance();
        r.add((TupleQueryResultWriterFactory)ServiceProviderHook.getInstanceForClass(JSON_WRITER_FACTORY));
        r = TupleQueryResultParserRegistry.getInstance();
        r.add((TupleQueryResultParserFactory)ServiceProviderHook.getInstanceForClass(JSON_RESULT_PARSER_FACTORY));
        r = RDFWriterRegistry.getInstance();
        r.add((RDFWriterFactory)ServiceProviderHook.getInstanceForClass(TURTLE_WRITER_FACTORY));
        r.add((RDFWriterFactory)ServiceProviderHook.getInstanceForClass(JSON_CONSTRUCT_WRITER_FACTORY));
        if (log.isInfoEnabled()) {
            for (RDFFormat rDFFormat : RDFFormat.values()) {
                log.info("RDFFormat: after: " + rDFFormat);
            }
            for (RDFParserFactory rDFParserFactory : RDFParserRegistry.getInstance().getAll()) {
                log.info("RDFParserFactory: after: " + rDFParserFactory);
            }
            for (RDFWriterFactory rDFWriterFactory : RDFWriterRegistry.getInstance().getAll()) {
                log.info("RDFWriterFactory: after: " + rDFWriterFactory);
            }
            for (TupleQueryResultWriterFactory tupleQueryResultWriterFactory : TupleQueryResultWriterRegistry.getInstance().getAll()) {
                log.info("TupleQueryResultWriterFactory: after: " + tupleQueryResultWriterFactory);
            }
        }
        loaded = true;
    }

    protected static Object getInstanceForClass(String className) {
        try {
            Class<?> c = Class.forName(className);
            Constructor<?> cons = c.getConstructor(new Class[0]);
            Object classInstance = cons.newInstance(new Object[0]);
            return classInstance;
        }
        catch (ClassNotFoundException | IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
            throw new RuntimeException(className + " is not found in the classpath.");
        }
    }

    static {
        ServiceProviderHook.forceLoad();
    }
}

