/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.rdf.graph.analytics;

import com.bigdata.rdf.graph.BinderBase;
import com.bigdata.rdf.graph.EdgesEnum;
import com.bigdata.rdf.graph.Factory;
import com.bigdata.rdf.graph.FrontierEnum;
import com.bigdata.rdf.graph.IBinder;
import com.bigdata.rdf.graph.IGASScheduler;
import com.bigdata.rdf.graph.IGASState;
import com.bigdata.rdf.graph.IReducer;
import com.bigdata.rdf.graph.impl.BaseGASProgram;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.log4j.Logger;
import org.openrdf.model.Statement;
import org.openrdf.model.Value;
import org.openrdf.model.ValueFactory;

public class CC
extends BaseGASProgram<VS, ES, Value> {
    private static final Logger log = Logger.getLogger(CC.class);
    private static final Factory<Value, VS> vertexStateFactory = new Factory<Value, VS>(){

        @Override
        public VS initialValue(Value value) {
            return new VS(value);
        }
    };

    @Override
    public Factory<Value, VS> getVertexStateFactory() {
        return vertexStateFactory;
    }

    @Override
    public Factory<Statement, ES> getEdgeStateFactory() {
        return null;
    }

    @Override
    public FrontierEnum getInitialFrontierEnum() {
        return FrontierEnum.AllVertices;
    }

    @Override
    public EdgesEnum getSampleEdgesFilter() {
        return EdgesEnum.NoEdges;
    }

    @Override
    public EdgesEnum getGatherEdges() {
        return EdgesEnum.AllEdges;
    }

    @Override
    public EdgesEnum getScatterEdges() {
        return EdgesEnum.AllEdges;
    }

    @Override
    public Value gather(IGASState<VS, ES, Value> state, Value u, Statement e) {
        Value v = state.getOtherVertex(u, e);
        VS vs = state.getState(v);
        return vs.getLabel();
    }

    @Override
    public Value sum(IGASState<VS, ES, Value> state, Value left, Value right) {
        if (state.compareTo(left, right) < 0) {
            return left;
        }
        return right;
    }

    @Override
    public VS apply(IGASState<VS, ES, Value> state, Value u, Value sum) {
        VS us = state.getState(u);
        if (sum == null) {
            us.changed = false;
            return null;
        }
        Value oldval = us.getLabel();
        if (state.compareTo(oldval, sum) <= 0) {
            us.changed = false;
            if (log.isDebugEnabled()) {
                log.debug(" NO CHANGE: " + u + ", val=" + oldval);
            }
        } else {
            us.setLabel(sum);
            us.changed = true;
            if (log.isDebugEnabled()) {
                log.debug("DID CHANGE: " + u + ", old=" + oldval + ", new=" + sum);
            }
        }
        return us;
    }

    @Override
    public boolean isChanged(IGASState<VS, ES, Value> state, Value u) {
        VS us = state.getState(u);
        return us.changed;
    }

    @Override
    public void scatter(IGASState<VS, ES, Value> state, IGASScheduler sch, Value u, Statement e) {
        Value v = state.getOtherVertex(u, e);
        sch.schedule(v);
    }

    @Override
    public List<IBinder<VS, ES, Value>> getBinderList() {
        List<IBinder<VS, ES, Value>> tmp = super.getBinderList();
        tmp.add(new BinderBase<VS, ES, Value>(){

            @Override
            public int getIndex() {
                return 1;
            }

            @Override
            public Value bind(ValueFactory vf, IGASState<VS, ES, Value> state, Value u) {
                return (Value)state.getState(u).label.get();
            }
        });
        return tmp;
    }

    public Map<Value, AtomicInteger> getConnectedComponents(IGASState<VS, ES, Value> state) {
        return state.reduce(new ConnectedComponentsReducer());
    }

    public class ConnectedComponentsReducer
    implements IReducer<VS, ES, Value, Map<Value, AtomicInteger>> {
        final ConcurrentHashMap<Value, AtomicInteger> labels = new ConcurrentHashMap();

        @Override
        public void visit(IGASState<VS, ES, Value> state, Value u) {
            VS us = state.getState(u);
            if (us != null) {
                AtomicInteger oldval;
                Value label = us.getLabel();
                if (log.isDebugEnabled()) {
                    log.debug("v=" + u + ", label=" + label);
                }
                if ((oldval = this.labels.putIfAbsent(label, new AtomicInteger(1))) != null) {
                    oldval.incrementAndGet();
                }
            }
        }

        @Override
        public Map<Value, AtomicInteger> get() {
            return Collections.unmodifiableMap(this.labels);
        }
    }

    public static interface Bindings
    extends BaseGASProgram.Bindings {
        public static final int LABEL = 1;
    }

    public static class ES {
    }

    public static class VS {
        private final AtomicReference<Value> label;
        private boolean changed = false;

        public VS(Value v) {
            this.label = new AtomicReference<Value>(v);
        }

        public Value getLabel() {
            return this.label.get();
        }

        private void setLabel(Value v) {
            this.label.set(v);
        }

        public String toString() {
            return "{label=" + this.label + ",changed=" + this.changed + "}";
        }
    }
}

