/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.rdf.graph.analytics;

import com.bigdata.rdf.graph.IGASContext;
import com.bigdata.rdf.graph.IGASEngine;
import com.bigdata.rdf.graph.IGASState;
import com.bigdata.rdf.graph.IGraphAccessor;
import com.bigdata.rdf.graph.IStaticFrontier;
import com.bigdata.rdf.graph.analytics.BFS;
import com.bigdata.rdf.graph.analytics.SSSP;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.openrdf.model.Value;

public class FuzzySSSP
implements Callable<FuzzySSSPResult> {
    private final Value[] src;
    private final Value[] tgt;
    private final int N;
    private final IGASEngine gasEngine;
    private final IGraphAccessor graphAccessor;

    public FuzzySSSP(Value[] src, Value[] tgt, int N, IGASEngine gasEngine, IGraphAccessor graphAccessor) {
        if (src == null) {
            throw new IllegalArgumentException();
        }
        if (src.length == 0) {
            throw new IllegalArgumentException();
        }
        for (Value v : src) {
            if (v != null) continue;
            throw new IllegalArgumentException();
        }
        if (tgt == null) {
            throw new IllegalArgumentException();
        }
        if (tgt.length == 0) {
            throw new IllegalArgumentException();
        }
        for (Value v : tgt) {
            if (v != null) continue;
            throw new IllegalArgumentException();
        }
        if (N <= 0) {
            throw new IllegalArgumentException();
        }
        if (gasEngine == null) {
            throw new IllegalArgumentException();
        }
        if (graphAccessor == null) {
            throw new IllegalArgumentException();
        }
        this.src = src;
        this.tgt = tgt;
        this.N = N;
        this.gasEngine = gasEngine;
        this.graphAccessor = graphAccessor;
    }

    @Override
    public FuzzySSSPResult call() throws Exception {
        final FuzzySSSPResult result = new FuzzySSSPResult();
        LinkedHashSet setAll = new LinkedHashSet();
        for (Value src : this.src) {
            IGASContext<SSSP.VS, SSSP.ES, Integer> gasContext = this.gasEngine.newGASContext(this.graphAccessor, new SSSP());
            IGASState<SSSP.VS, SSSP.ES, Integer> gasState = gasContext.getGASState();
            gasState.setFrontier(gasContext, src);
            gasContext.call();
            LinkedHashSet set = new LinkedHashSet();
            for (Value tgt : this.tgt) {
                if (!gasState.isVisited(tgt)) continue;
                result.addReachable(src, tgt);
            }
            setAll.addAll(set);
        }
        IGASContext<BFS.VS, BFS.ES, Void> gasContext = this.gasEngine.newGASContext(this.graphAccessor, new BFS(){

            @Override
            public boolean nextRound(IGASContext<BFS.VS, BFS.ES, Void> ctx) {
                IStaticFrontier frontier = ctx.getGASState().frontier();
                for (Value v : frontier) {
                    if (!result.addVisited(v) || result.getVisitedCount() < FuzzySSSP.this.N) continue;
                    return false;
                }
                return super.nextRound(ctx);
            }
        });
        IGASState<BFS.VS, BFS.ES, Void> gasState = gasContext.getGASState();
        for (Value v : setAll) {
            gasState.setFrontier(gasContext, v);
            result.addVisited(v);
        }
        gasContext.call();
        return result;
    }

    public class FuzzySSSPResult {
        private ConcurrentMap<Value, ConcurrentMap<Value, Value>> reachable = new ConcurrentHashMap<Value, ConcurrentMap<Value, Value>>();
        private Set<Value> visited = new LinkedHashSet<Value>();

        private boolean addVisited(Value v) {
            return this.visited.add(v);
        }

        private void addReachable(Value src, Value tgt) {
            ConcurrentMap old;
            if (src == null) {
                throw new IllegalArgumentException();
            }
            if (tgt == null) {
                throw new IllegalArgumentException();
            }
            ConcurrentMap<Value, Value> tmp = (ConcurrentHashMap<Value, Value>)this.reachable.get(src);
            if (tmp == null && (old = (ConcurrentMap)this.reachable.putIfAbsent(src, tmp = new ConcurrentHashMap<Value, Value>())) != null) {
                tmp = old;
            }
            tmp.putIfAbsent(tgt, tgt);
        }

        public int getVisitedCount() {
            return this.visited.size();
        }

        public boolean getReachable(Value src, Value tgt) {
            throw new UnsupportedOperationException();
        }

        public Set<Value> getVisitedVertices() {
            throw new UnsupportedOperationException();
        }

        public String toString() {
            return this.getClass().getName() + "{nvisited=" + this.visited.size() + "}";
        }
    }
}

