/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.rdf.graph.analytics;

import com.bigdata.rdf.graph.BinderBase;
import com.bigdata.rdf.graph.EdgesEnum;
import com.bigdata.rdf.graph.Factory;
import com.bigdata.rdf.graph.FrontierEnum;
import com.bigdata.rdf.graph.IBinder;
import com.bigdata.rdf.graph.IGASContext;
import com.bigdata.rdf.graph.IGASScheduler;
import com.bigdata.rdf.graph.IGASState;
import com.bigdata.rdf.graph.IReducer;
import com.bigdata.rdf.graph.impl.BaseGASProgram;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.log4j.Logger;
import org.openrdf.model.Statement;
import org.openrdf.model.Value;
import org.openrdf.model.ValueFactory;

public class PR
extends BaseGASProgram<VS, ES, Double> {
    private static final Logger log = Logger.getLogger(PR.class);
    protected static final int DEFAULT_LIMIT = 100;
    protected static final double DEFAULT_RESET_PROB = 0.15;
    protected static final double DEFAULT_EPSILON = 0.01;
    protected static final double DEFAULT_MIN_PAGE_RANK = 1.0;
    private final double resetProb = 0.15;
    private final double epsilon = 0.01;
    private final int limit = 100;
    private final double minPageRank = 1.0;
    private static final Factory<Value, VS> vertexStateFactory = new Factory<Value, VS>(){

        @Override
        public VS initialValue(Value value) {
            return new VS();
        }
    };

    @Override
    public Factory<Value, VS> getVertexStateFactory() {
        return vertexStateFactory;
    }

    @Override
    public Factory<Statement, ES> getEdgeStateFactory() {
        return null;
    }

    @Override
    public FrontierEnum getInitialFrontierEnum() {
        return FrontierEnum.AllVertices;
    }

    @Override
    public EdgesEnum getGatherEdges() {
        return EdgesEnum.InEdges;
    }

    @Override
    public EdgesEnum getScatterEdges() {
        return EdgesEnum.OutEdges;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void initVertex(IGASContext<VS, ES, Double> ctx, IGASState<VS, ES, Double> state, Value u) {
        VS us;
        VS vS = us = state.getState(u);
        synchronized (vS) {
            us.value = 0.15;
            us.outEdges = ctx.getGraphAccessor().getEdgeCount(ctx, u, EdgesEnum.OutEdges);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Double gather(IGASState<VS, ES, Double> state, Value u, Statement e) {
        VS vs;
        Value v = state.getOtherVertex(u, e);
        VS vS = vs = state.getState(v);
        synchronized (vS) {
            return vs.value / (double)vs.outEdges;
        }
    }

    @Override
    public Double sum(IGASState<VS, ES, Double> state, Double left, Double right) {
        return left + right;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public VS apply(IGASState<VS, ES, Double> state, Value u, Double sum) {
        VS us = state.getState(u);
        if (sum == null) {
            VS vS = us;
            synchronized (vS) {
                us.lastChange = 0.0;
            }
            return null;
        }
        double newval = 0.15 + 0.85 * sum;
        VS vS = us;
        synchronized (vS) {
            us.lastChange = newval - us.value;
            us.value = newval;
        }
        return us;
    }

    @Override
    public boolean isChanged(IGASState<VS, ES, Double> state, Value u) {
        VS us = state.getState(u);
        return us.lastChange > 0.01;
    }

    @Override
    public void scatter(IGASState<VS, ES, Double> state, IGASScheduler sch, Value u, Statement e) {
        Value v = state.getOtherVertex(u, e);
        sch.schedule(v);
    }

    @Override
    public boolean nextRound(IGASContext<VS, ES, Double> ctx) {
        return ctx.getGASState().round() < 100;
    }

    @Override
    public List<IBinder<VS, ES, Double>> getBinderList() {
        List<IBinder<VS, ES, Double>> tmp = super.getBinderList();
        tmp.add(new BinderBase<VS, ES, Double>(){

            @Override
            public int getIndex() {
                return 1;
            }

            @Override
            public Value bind(ValueFactory vf, IGASState<VS, ES, Double> state, Value u) {
                return vf.createLiteral(state.getState(u).getValue());
            }
        });
        return tmp;
    }

    public class PageRankReducer
    implements IReducer<VS, ES, Double, Map<Value, Double>> {
        private final ConcurrentHashMap<Value, Double> values = new ConcurrentHashMap();

        @Override
        public void visit(IGASState<VS, ES, Double> state, Value u) {
            VS us = state.getState(u);
            if (us != null) {
                double pageRank = us.getValue();
                if (Double.isNaN(pageRank)) {
                    return;
                }
                if (Double.isInfinite(pageRank)) {
                    return;
                }
                if (pageRank < 1.0) {
                    return;
                }
                if (log.isDebugEnabled()) {
                    log.debug("v=" + u + ", pageRank=" + pageRank);
                }
                this.values.put(u, pageRank);
            }
        }

        @Override
        public Map<Value, Double> get() {
            return Collections.unmodifiableMap(this.values);
        }
    }

    public static interface Bindings
    extends BaseGASProgram.Bindings {
        public static final int RANK = 1;
    }

    public static class ES {
    }

    public static class VS {
        private double value;
        private long outEdges;
        private double lastChange = 0.0;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public double getValue() {
            VS vS = this;
            synchronized (vS) {
                return this.value;
            }
        }

        public String toString() {
            return "{value=" + this.value + ",lastChange=" + this.lastChange + "}";
        }
    }
}

