/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.rdf.graph.analytics;

import com.bigdata.rdf.graph.BinderBase;
import com.bigdata.rdf.graph.EdgesEnum;
import com.bigdata.rdf.graph.Factory;
import com.bigdata.rdf.graph.FrontierEnum;
import com.bigdata.rdf.graph.IBinder;
import com.bigdata.rdf.graph.IGASContext;
import com.bigdata.rdf.graph.IGASScheduler;
import com.bigdata.rdf.graph.IGASState;
import com.bigdata.rdf.graph.IPredecessor;
import com.bigdata.rdf.graph.impl.BaseGASProgram;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.log4j.Logger;
import org.openrdf.model.Literal;
import org.openrdf.model.Statement;
import org.openrdf.model.Value;
import org.openrdf.model.ValueFactory;

public class SSSP
extends BaseGASProgram<VS, ES, Integer>
implements IPredecessor<VS, ES, Integer> {
    private static final Logger log = Logger.getLogger(SSSP.class);
    private static final double EDGE_LENGTH = 1.0;
    private static final Factory<Value, VS> vertexStateFactory = new Factory<Value, VS>(){

        @Override
        public VS initialValue(Value value) {
            return new VS();
        }
    };

    @Override
    public Factory<Value, VS> getVertexStateFactory() {
        return vertexStateFactory;
    }

    @Override
    public FrontierEnum getInitialFrontierEnum() {
        return FrontierEnum.SingleVertex;
    }

    @Override
    public EdgesEnum getGatherEdges() {
        return EdgesEnum.NoEdges;
    }

    @Override
    public EdgesEnum getScatterEdges() {
        return EdgesEnum.OutEdges;
    }

    @Override
    public void initVertex(IGASContext<VS, ES, Integer> ctx, IGASState<VS, ES, Integer> state, Value u) {
        VS us = state.getState(u);
        us.setStartingVertex();
    }

    @Override
    public Integer gather(IGASState<VS, ES, Integer> state, Value u, Statement e) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Integer sum(IGASState<VS, ES, Integer> state, Integer left, Integer right) {
        throw new UnsupportedOperationException();
    }

    @Override
    public VS apply(IGASState<VS, ES, Integer> state, Value u, Integer sum) {
        return null;
    }

    @Override
    public void scatter(IGASState<VS, ES, Integer> state, IGASScheduler sch, Value u, Statement e) {
        double edgeLength;
        Value other = state.getOtherVertex(u, e);
        VS selfState = state.getState(u);
        VS otherState = state.getState(other);
        Literal l = state.getLinkAttr(u, e);
        if (l != null) {
            if (log.isDebugEnabled()) {
                log.debug(l);
            }
            edgeLength = l.doubleValue();
        } else {
            edgeLength = 1.0;
        }
        double newDist = selfState.dist() + edgeLength;
        double otherDist = otherState.dist();
        if (newDist < otherDist && otherState.scatter(u, newDist)) {
            if (log.isDebugEnabled()) {
                log.debug("u=" + u + " @ " + selfState.dist() + ", scheduling: " + other + " with newDist=" + newDist);
            }
            sch.schedule(other);
        }
    }

    @Override
    public boolean nextRound(IGASContext<VS, ES, Integer> ctx) {
        return true;
    }

    @Override
    public List<IBinder<VS, ES, Integer>> getBinderList() {
        List<IBinder<VS, ES, Integer>> tmp = super.getBinderList();
        tmp.add(new BinderBase<VS, ES, Integer>(){

            @Override
            public int getIndex() {
                return 1;
            }

            @Override
            public Value bind(ValueFactory vf, IGASState<VS, ES, Integer> state, Value u) {
                return vf.createLiteral(state.getState(u).dist());
            }
        });
        tmp.add(new BinderBase<VS, ES, Integer>(){

            @Override
            public int getIndex() {
                return 2;
            }

            @Override
            public Value bind(ValueFactory vf, IGASState<VS, ES, Integer> state, Value u) {
                return (Value)state.getState(u).predecessor.get();
            }
        });
        return tmp;
    }

    @Override
    public void prunePaths(IGASContext<VS, ES, Integer> ctx, Value[] targetVertices) {
        if (ctx == null) {
            throw new IllegalArgumentException();
        }
        if (targetVertices == null) {
            throw new IllegalArgumentException();
        }
        IGASState<VS, ES, Integer> gasState = ctx.getGASState();
        HashSet<Value> retainSet = new HashSet<Value>();
        for (Value v : targetVertices) {
            if (!gasState.isVisited(v)) continue;
            Value current = v;
            while (current != null) {
                Value predecessor;
                retainSet.add(current);
                VS currentState = gasState.getState(current);
                current = predecessor = currentState.predecessor();
            }
        }
        gasState.retainAll(retainSet);
    }

    public static interface Bindings
    extends BaseGASProgram.Bindings {
        public static final int DISTANCE = 1;
        public static final int PREDECESSOR = 2;
    }

    public static class ES {
    }

    public static class VS {
        private Double dist = Double.MAX_VALUE;
        private final AtomicReference<Value> predecessor = new AtomicReference();

        public Value predecessor() {
            return this.predecessor.get();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public double dist() {
            VS vS = this;
            synchronized (vS) {
                return this.dist;
            }
        }

        public String toString() {
            return "{dist=" + this.dist() + ", predecessor=" + this.predecessor.get() + "}";
        }

        private synchronized void setStartingVertex() {
            this.dist = 0.0;
            this.predecessor.set(null);
        }

        private synchronized boolean scatter(Value predecessor, double newDist) {
            if (newDist < this.dist) {
                this.dist = newDist;
                this.predecessor.set(predecessor);
                return true;
            }
            return false;
        }
    }
}

