/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.rdf.graph.impl;

import com.bigdata.rdf.graph.Factory;
import com.bigdata.rdf.graph.IGASContext;
import com.bigdata.rdf.graph.IGASEngine;
import com.bigdata.rdf.graph.IGASProgram;
import com.bigdata.rdf.graph.IGASSchedulerImpl;
import com.bigdata.rdf.graph.IGASState;
import com.bigdata.rdf.graph.IGraphAccessor;
import com.bigdata.rdf.graph.IReducer;
import com.bigdata.rdf.graph.IStaticFrontier;
import com.bigdata.rdf.graph.util.GASUtil;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.log4j.Logger;
import org.openrdf.model.Literal;
import org.openrdf.model.Resource;
import org.openrdf.model.Statement;
import org.openrdf.model.URI;
import org.openrdf.model.Value;
import org.openrdf.query.algebra.evaluation.util.ValueComparator;

public class GASState<VS, ES, ST>
implements IGASState<VS, ES, ST> {
    private static final Logger log = Logger.getLogger(GASState.class);
    private final boolean sortFrontier;
    private final IGASProgram<VS, ES, ST> gasProgram;
    private final Factory<Value, VS> vsf;
    private final Factory<Statement, ES> esf;
    private final IStaticFrontier frontier;
    private final IGASSchedulerImpl scheduler;
    private final AtomicInteger round = new AtomicInteger(0);
    protected final ConcurrentMap<Value, VS> vertexState = new ConcurrentHashMap<Value, VS>();
    protected final ConcurrentMap<Statement, ES> edgeState = null;
    private final IGraphAccessor graphAccessor;
    private final Comparator<Value> valueComparator;

    public GASState(IGASEngine gasEngine, IGraphAccessor graphAccessor, IStaticFrontier frontier, IGASSchedulerImpl gasScheduler, IGASProgram<VS, ES, ST> gasProgram) {
        if (gasEngine == null) {
            throw new IllegalArgumentException();
        }
        if (graphAccessor == null) {
            throw new IllegalArgumentException();
        }
        if (frontier == null) {
            throw new IllegalArgumentException();
        }
        if (gasScheduler == null) {
            throw new IllegalArgumentException();
        }
        if (gasProgram == null) {
            throw new IllegalArgumentException();
        }
        this.sortFrontier = gasEngine.getSortFrontier();
        this.graphAccessor = graphAccessor;
        this.gasProgram = gasProgram;
        this.vsf = gasProgram.getVertexStateFactory();
        this.esf = gasProgram.getEdgeStateFactory();
        this.frontier = frontier;
        this.scheduler = gasScheduler;
        this.valueComparator = new ValueComparator();
    }

    protected IGraphAccessor getGraphAccessor() {
        return this.graphAccessor;
    }

    @Override
    public IStaticFrontier frontier() {
        return this.frontier;
    }

    @Override
    public IGASSchedulerImpl getScheduler() {
        return this.scheduler;
    }

    @Override
    public VS getState(Value v) {
        VS old;
        Object vs = this.vertexState.get(v);
        if (vs == null && (old = this.vertexState.putIfAbsent(v, vs = this.vsf.initialValue(v))) != null) {
            vs = old;
        }
        return (VS)vs;
    }

    @Override
    public boolean isVisited(Value v) {
        return this.vertexState.get(v) != null;
    }

    @Override
    public boolean isVisited(Set<Value> v) {
        return this.vertexState.keySet().containsAll(v);
    }

    @Override
    public ES getState(Statement e) {
        ES old;
        if (this.edgeState == null) {
            return null;
        }
        Object es = this.edgeState.get(e);
        if (es == null && (old = this.edgeState.putIfAbsent(e, es = this.esf.initialValue(e))) != null) {
            es = old;
        }
        return (ES)es;
    }

    @Override
    public void retainAll(Set<Value> retainSet) {
        for (Value v : this.vertexState.keySet()) {
            if (retainSet.contains(v)) continue;
            this.vertexState.remove(v);
        }
    }

    @Override
    public int round() {
        return this.round.get();
    }

    @Override
    public void reset() {
        this.round.set(0);
        this.vertexState.clear();
        if (this.edgeState != null) {
            this.edgeState.clear();
        }
        this.frontier.resetFrontier(0, false, GASUtil.EMPTY_VERTICES_ITERATOR);
    }

    @Override
    public void setFrontier(IGASContext<VS, ES, ST> ctx, Value ... vertices) {
        if (vertices == null) {
            throw new IllegalArgumentException();
        }
        this.reset();
        HashSet<Value> tmp = new HashSet<Value>();
        for (Value v : vertices) {
            tmp.add(this.asValue(v));
        }
        for (Value v : tmp) {
            this.gasProgram.initVertex(ctx, this, v);
        }
        this.frontier.resetFrontier(tmp.size(), tmp.size() > 1 && this.sortFrontier, tmp.iterator());
    }

    @Override
    public void traceState() {
        if (log.isInfoEnabled()) {
            log.info("Round=" + this.round + ", frontierSize=" + this.frontier().size() + ", vertexStateSize=" + this.vertexState.size());
        }
    }

    @Override
    public void endRound() {
        this.round.incrementAndGet();
        this.scheduler.compactFrontier(this.frontier);
        this.scheduler.clear();
    }

    @Override
    public <T> T reduce(IReducer<VS, ES, ST, T> op) {
        for (Value v : this.vertexState.keySet()) {
            op.visit(this, v);
        }
        return op.get();
    }

    @Override
    public String toString(Statement e) {
        return e.toString();
    }

    @Override
    public Value getOtherVertex(Value u, Statement e) {
        if (e.getSubject().equals(u)) {
            return e.getObject();
        }
        return e.getSubject();
    }

    @Override
    public Literal getLinkAttr(Value u, Statement e) {
        return null;
    }

    @Override
    public boolean isEdge(Statement e) {
        return e.getObject() instanceof Resource;
    }

    @Override
    public boolean isAttrib(Statement e) {
        return !this.isEdge(e);
    }

    @Override
    public boolean isLinkAttrib(Statement e, URI linkAttribType) {
        return false;
    }

    @Override
    public Statement decodeStatement(Value v) {
        return null;
    }

    @Override
    public int compareTo(Value u, Value v) {
        int ret = this.valueComparator.compare(u, v);
        return ret;
    }

    @Override
    public Value asValue(Value value) {
        return value;
    }
}

