/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.rdf.graph.impl.bd;

import com.bigdata.rdf.graph.IGASEngine;
import com.bigdata.rdf.graph.IGASProgram;
import com.bigdata.rdf.graph.IGASSchedulerImpl;
import com.bigdata.rdf.graph.IStaticFrontier;
import com.bigdata.rdf.graph.impl.GASState;
import com.bigdata.rdf.graph.impl.bd.BigdataGASEngine;
import com.bigdata.rdf.internal.IV;
import com.bigdata.rdf.internal.IVUtility;
import com.bigdata.rdf.internal.impl.bnode.SidIV;
import com.bigdata.rdf.model.BigdataValue;
import com.bigdata.rdf.spo.ISPO;
import com.bigdata.rdf.store.AbstractTripleStore;
import java.util.HashSet;
import java.util.Map;
import org.apache.log4j.Logger;
import org.openrdf.model.Literal;
import org.openrdf.model.Statement;
import org.openrdf.model.URI;
import org.openrdf.model.Value;

public class BigdataGASState<VS, ES, ST>
extends GASState<VS, ES, ST> {
    private static final Logger log = Logger.getLogger(BigdataGASState.class);

    @Override
    protected BigdataGASEngine.BigdataGraphAccessor getGraphAccessor() {
        return (BigdataGASEngine.BigdataGraphAccessor)super.getGraphAccessor();
    }

    public BigdataGASState(IGASEngine gasEngine, BigdataGASEngine.BigdataGraphAccessor graphAccessor, IStaticFrontier frontier, IGASSchedulerImpl gasScheduler, IGASProgram<VS, ES, ST> gasProgram) {
        super(gasEngine, graphAccessor, frontier, gasScheduler, gasProgram);
    }

    @Override
    public void traceState() {
        super.traceState();
        if (!log.isTraceEnabled()) {
            return;
        }
        AbstractTripleStore kb = this.getGraphAccessor().getKB();
        HashSet tmp = new HashSet();
        for (Value v : this.frontier()) {
            tmp.add((IV)v);
        }
        tmp.addAll(this.vertexState.keySet());
        Map<IV<?, ?>, BigdataValue> m = kb.getLexiconRelation().getTerms(tmp);
        log.trace("frontier: size=" + this.frontier().size());
        for (Value value : this.frontier()) {
            log.trace("frontier: iv=" + value + " (" + m.get(value) + ")");
        }
        log.trace("vertexState: size=" + this.vertexState.size());
        for (Map.Entry entry : this.vertexState.entrySet()) {
            Value v = (Value)entry.getKey();
            BigdataValue val = m.get(v);
            log.trace("vertexState: vertex=" + v + " (" + val + "), state=" + entry.getValue());
        }
    }

    @Override
    public String toString(Statement e) {
        return this.getGraphAccessor().getKB().toString((ISPO)e);
    }

    @Override
    public boolean isEdge(Statement e) {
        ISPO spo = (ISPO)e;
        return spo.o().isResource();
    }

    @Override
    public boolean isAttrib(Statement e) {
        return !this.isEdge(e);
    }

    @Override
    public boolean isLinkAttrib(Statement e, URI linkAttribType) {
        ISPO edge = (ISPO)e;
        if (!edge.p().equals(linkAttribType)) {
            return false;
        }
        return edge.s() instanceof SidIV;
    }

    @Override
    public Statement decodeStatement(Value v) {
        if (!(v instanceof IV)) {
            return null;
        }
        IV tmp = (IV)v;
        if (!tmp.isStatement()) {
            return null;
        }
        ISPO decodedEdge = (ISPO)tmp.getInlineValue();
        return decodedEdge;
    }

    @Override
    public int compareTo(Value u, Value v) {
        return IVUtility.compare((IV)u, (IV)v);
    }

    @Override
    public Value getOtherVertex(Value u, Statement e) {
        if (e.getSubject() instanceof SidIV) {
            ISPO spo = ((SidIV)e.getSubject()).getInlineValue();
            if (spo.s().equals(u)) {
                return spo.o();
            }
            return spo.s();
        }
        if (e.getSubject().equals(u)) {
            return e.getObject();
        }
        return e.getSubject();
    }

    @Override
    public Literal getLinkAttr(Value u, Statement e) {
        if (e.getObject() instanceof IV) {
            IV iv = (IV)e.getObject();
            if (iv.isLiteral()) {
                if (iv.isInline()) {
                    return (Literal)((Object)iv);
                }
                return (Literal)iv.getValue();
            }
        } else if (e.getObject() instanceof Literal) {
            return (Literal)e.getObject();
        }
        return null;
    }
}

