/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.rdf.graph.impl.bd;

import com.bigdata.rdf.graph.IGraphAccessor;
import com.bigdata.rdf.graph.impl.bd.BigdataGASEngine;
import com.bigdata.rdf.graph.util.AbstractGraphFixture;
import com.bigdata.rdf.graph.util.SailGraphLoader;
import com.bigdata.rdf.sail.BigdataSail;
import com.bigdata.rdf.store.AbstractTripleStore;
import java.util.Properties;
import org.openrdf.model.ValueFactory;
import org.openrdf.sail.SailConnection;
import org.openrdf.sail.SailException;

public class BigdataGraphFixture
extends AbstractGraphFixture {
    private final BigdataSail sail;

    public BigdataGraphFixture(Properties properties) throws SailException {
        this.sail = new BigdataSail(properties);
        this.sail.initialize();
    }

    public BigdataGraphFixture(AbstractTripleStore kb) throws SailException {
        this.sail = new BigdataSail(kb);
        this.sail.initialize();
    }

    @Override
    public BigdataSail getSail() {
        return this.sail;
    }

    @Override
    public void destroy() throws Exception {
        if (this.sail.isOpen()) {
            this.sail.shutDown();
        }
        if (this.sail instanceof BigdataSail) {
            this.sail.__tearDownUnitTest();
        }
    }

    @Override
    protected SailGraphLoader newSailGraphLoader(SailConnection cxn) {
        return new BigdataSailGraphLoader(cxn);
    }

    @Override
    public BigdataGASEngine newGASEngine(int nthreads) {
        return new BigdataGASEngine(this.sail, nthreads);
    }

    @Override
    public IGraphAccessor newGraphAccessor(SailConnection ignored) {
        return new BigdataGASEngine.BigdataGraphAccessor(this.sail.getIndexManager());
    }

    public static class BigdataSailGraphLoader
    extends SailGraphLoader {
        private final ValueFactory valueFactory;

        public BigdataSailGraphLoader(SailConnection cxn) {
            super(cxn);
            this.valueFactory = ((BigdataSail.BigdataSailConnection)cxn).getBigdataSail().getValueFactory();
        }

        @Override
        protected ValueFactory getValueFactory() {
            return this.valueFactory;
        }
    }
}

