/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.rdf.graph.impl.bd;

import com.bigdata.rdf.graph.IGASScheduler;
import com.bigdata.rdf.graph.IGASSchedulerImpl;
import com.bigdata.rdf.graph.IStaticFrontier;
import com.bigdata.rdf.graph.impl.GASEngine;
import com.bigdata.rdf.graph.impl.frontier.StaticFrontier2;
import com.bigdata.rdf.graph.impl.scheduler.STScheduler;
import com.bigdata.rdf.graph.impl.util.GASImplUtil;
import com.bigdata.rdf.graph.impl.util.IArraySlice;
import com.bigdata.rdf.graph.impl.util.ManagedArray;
import com.bigdata.rdf.graph.util.GASUtil;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import org.apache.log4j.Logger;
import org.openrdf.model.Value;

public class TLScheduler2
implements IGASSchedulerImpl {
    private static final Logger log = Logger.getLogger(TLScheduler2.class);
    private final GASEngine gasEngine;
    private final int nthreads;
    private final ConcurrentHashMap<Long, MySTScheduler> map;

    public TLScheduler2(GASEngine gasEngine) {
        this.gasEngine = gasEngine;
        this.nthreads = gasEngine.getNThreads();
        this.map = new ConcurrentHashMap(this.nthreads, 0.75f, this.nthreads);
    }

    private IGASScheduler threadLocalScheduler() {
        IGASScheduler old;
        Long id = Thread.currentThread().getId();
        MySTScheduler s = this.map.get(id);
        if (s == null && (old = (IGASScheduler)this.map.putIfAbsent(id, s = new MySTScheduler(this.gasEngine))) != null) {
            throw new AssertionError();
        }
        return s;
    }

    @Override
    public void schedule(Value v) {
        this.threadLocalScheduler().schedule(v);
    }

    @Override
    public void clear() {
        this.map.clear();
    }

    @Override
    public void compactFrontier(IStaticFrontier frontier) {
        List futures;
        final int[] off = new int[this.nthreads];
        int ns = 0;
        int nv = 0;
        Iterator<MySTScheduler> i$ = this.map.values().iterator();
        while (i$.hasNext()) {
            MySTScheduler s;
            MySTScheduler t = s = i$.next();
            int sz = t.size();
            off[ns] = nv;
            ++ns;
            nv += sz;
        }
        int nsources = ns;
        int nvertices = nv;
        if (nsources > this.nthreads) {
            throw new AssertionError((Object)("nsources=" + nsources + ", nthreads=" + this.nthreads));
        }
        if (nvertices == 0) {
            frontier.resetFrontier(0, false, GASUtil.EMPTY_VERTICES_ITERATOR);
            return;
        }
        final StaticFrontier2 f2 = (StaticFrontier2)frontier;
        f2.resetAndEnsureCapacity(nvertices);
        f2.setCompact(false);
        ArrayList<1> tasks = new ArrayList<1>(nsources);
        int i = 0;
        Iterator<MySTScheduler> i$2 = this.map.values().iterator();
        while (i$2.hasNext()) {
            MySTScheduler s;
            final MySTScheduler t = s = i$2.next();
            final int index = i++;
            tasks.add(new Callable<Void>(){

                @Override
                public Void call() throws Exception {
                    IArraySlice<Value> orderedSegment = GASImplUtil.compactAndSort(t.getVertices(), t.tmp);
                    f2.copyIntoResetFrontier(off[index], orderedSegment);
                    return null;
                }
            });
        }
        try {
            futures = this.gasEngine.getGASThreadPool().invokeAll(tasks);
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
        for (Future f : futures) {
            try {
                f.get();
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
            catch (ExecutionException e) {
                throw new RuntimeException(e);
            }
        }
        if (log.isInfoEnabled()) {
            log.info("Done: " + this.getClass().getCanonicalName() + ",frontier=" + frontier);
        }
    }

    private static class MySTScheduler
    extends STScheduler {
        private final ManagedArray<Value> tmp = new ManagedArray<Value>(Value.class, 64);

        public MySTScheduler(GASEngine gasEngine) {
            super(gasEngine);
        }
    }
}

