/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.rdf.graph.impl.ram;

import com.bigdata.rdf.graph.EdgesEnum;
import com.bigdata.rdf.graph.IGASContext;
import com.bigdata.rdf.graph.IGraphAccessor;
import com.bigdata.rdf.graph.impl.EdgeOnlyFilter;
import com.bigdata.rdf.graph.impl.GASEngine;
import com.bigdata.rdf.graph.impl.util.VertexDistribution;
import cutthecrap.utils.striterators.EmptyIterator;
import cutthecrap.utils.striterators.IStriterator;
import cutthecrap.utils.striterators.Striterator;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.openrdf.model.Resource;
import org.openrdf.model.Statement;
import org.openrdf.model.URI;
import org.openrdf.model.Value;
import org.openrdf.model.ValueFactory;
import org.openrdf.model.impl.ValueFactoryImpl;
import org.openrdf.sail.SailException;

public class RAMGASEngine
extends GASEngine {
    public RAMGASEngine(int nthreads) {
        super(nthreads);
    }

    @Override
    public boolean getSortFrontier() {
        return false;
    }

    public static class RAMGraphAccessor
    implements IGraphAccessor {
        private final RAMGraph g;

        public RAMGraphAccessor(RAMGraph g) {
            if (g == null) {
                throw new IllegalArgumentException();
            }
            this.g = g;
        }

        @Override
        public void advanceView() {
        }

        @Override
        public long getEdgeCount(IGASContext<?, ?, ?> ctx, Value u, EdgesEnum edges) {
            long n = 0L;
            Iterator<Statement> itr = this.getEdges(ctx, u, edges);
            while (itr.hasNext()) {
                itr.next();
                ++n;
            }
            return n;
        }

        @Override
        public Iterator<Statement> getEdges(IGASContext<?, ?, ?> ctx, Value u, EdgesEnum edges) {
            try {
                switch (edges) {
                    case NoEdges: {
                        return EmptyIterator.DEFAULT;
                    }
                    case InEdges: {
                        return this.getEdges(true, ctx, u);
                    }
                    case OutEdges: {
                        return this.getEdges(false, ctx, u);
                    }
                    case AllEdges: {
                        IStriterator a = this.getEdges(true, ctx, u);
                        IStriterator b = this.getEdges(false, ctx, u);
                        a.append(b);
                        return a;
                    }
                }
                throw new UnsupportedOperationException(edges.name());
            }
            catch (SailException ex) {
                throw new RuntimeException(ex);
            }
        }

        private IStriterator getEdges(boolean inEdges, IGASContext<?, ?, ?> ctx, Value u) throws SailException {
            URI linkTypeIV = ctx.getLinkType();
            if (linkTypeIV != null) {
                throw new UnsupportedOperationException();
            }
            Striterator sitr = inEdges ? new Striterator(this.g.get(u, false).inEdges()) : new Striterator(this.g.get(u, false).outEdges());
            sitr.addFilter(new EdgeOnlyFilter(ctx));
            return sitr;
        }

        @Override
        public VertexDistribution getDistribution(Random r) {
            VertexDistribution sample = new VertexDistribution(r);
            for (RAMGraph.Vertex vertex : this.g.vertices.values()) {
                Value v = vertex.v;
                if (!(v instanceof Resource)) continue;
                if (vertex.getInEdgeCount() > 0) {
                    sample.addInEdgeSample((Resource)v);
                }
                if (vertex.getOutEdgeCount() <= 0) continue;
                sample.addOutEdgeSample((Resource)v);
            }
            return sample;
        }
    }

    public static class RAMGraph {
        private final ValueFactory vf;
        private final ConcurrentMap<Value, Vertex> vertices = new ConcurrentHashMap<Value, Vertex>();

        public ValueFactory getValueFactory() {
            return this.vf;
        }

        public RAMGraph() {
            this.vf = new ValueFactoryImpl();
        }

        private Vertex get(Value x, boolean create) {
            Vertex oldVal;
            Vertex v = (Vertex)this.vertices.get(x);
            if (v == null && create && (oldVal = this.vertices.putIfAbsent(x, v = new Vertex(x))) != null) {
                v = oldVal;
            }
            return v;
        }

        public boolean add(Statement st) {
            Resource s = st.getSubject();
            Value o = st.getObject();
            boolean modified = false;
            if (o instanceof URI) {
                modified |= this.get(s, true).addOutEdge(st);
                modified |= this.get(o, true).addInEdge(st);
            } else {
                modified |= this.get(s, true).addAttrib(st);
            }
            return modified;
        }

        public Iterator<Statement> inEdges(Value v) {
            Vertex x = this.get(v, false);
            if (x == null) {
                return EmptyIterator.DEFAULT;
            }
            return x.inEdges();
        }

        public Iterator<Statement> outEdges(Value v) {
            Vertex x = this.get(v, false);
            if (x == null) {
                return EmptyIterator.DEFAULT;
            }
            return x.outEdges();
        }

        public Iterator<Statement> attribs(Value v) {
            Vertex x = this.get(v, false);
            if (x == null) {
                return EmptyIterator.DEFAULT;
            }
            return x.attribs();
        }

        private static class Vertex {
            private final Value v;
            private Set<Statement> inEdges = null;
            private Set<Statement> outEdges = null;
            private Set<Statement> attribs = null;

            public Vertex(Value v) {
                if (v == null) {
                    throw new NullPointerException();
                }
                this.v = v;
            }

            public String toString() {
                return "Vertex{" + this.v + ",inEdges=" + this.getInEdgeCount() + ",outEdges=" + this.getOutEdgeCount() + ",attribs=" + this.getAttribCount() + "}";
            }

            private boolean addAttrib(Statement s) {
                if (this.attribs == null) {
                    this.attribs = new LinkedHashSet<Statement>();
                }
                return this.attribs.add(s);
            }

            private boolean addOutEdge(Statement s) {
                if (this.outEdges == null) {
                    this.outEdges = new LinkedHashSet<Statement>();
                }
                return this.outEdges.add(s);
            }

            private boolean addInEdge(Statement s) {
                if (this.inEdges == null) {
                    this.inEdges = new LinkedHashSet<Statement>();
                }
                return this.inEdges.add(s);
            }

            public int getAttribCount() {
                return this.attribs == null ? 0 : this.attribs.size();
            }

            public int getInEdgeCount() {
                return this.inEdges == null ? 0 : this.inEdges.size();
            }

            public int getOutEdgeCount() {
                return this.outEdges == null ? 0 : this.outEdges.size();
            }

            public Iterator<Statement> inEdges() {
                if (this.inEdges == null) {
                    return EmptyIterator.DEFAULT;
                }
                return this.inEdges.iterator();
            }

            public Iterator<Statement> outEdges() {
                if (this.outEdges == null) {
                    return EmptyIterator.DEFAULT;
                }
                return this.outEdges.iterator();
            }

            public Iterator<Statement> attribs() {
                if (this.attribs == null) {
                    return EmptyIterator.DEFAULT;
                }
                return this.attribs.iterator();
            }
        }
    }
}

