/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.rdf.graph.impl.util;

import com.bigdata.rdf.graph.FrontierEnum;
import com.bigdata.rdf.graph.IGASContext;
import com.bigdata.rdf.graph.IGASEngine;
import com.bigdata.rdf.graph.IGASProgram;
import com.bigdata.rdf.graph.IGASSchedulerImpl;
import com.bigdata.rdf.graph.IGASState;
import com.bigdata.rdf.graph.IGASStats;
import com.bigdata.rdf.graph.IGraphAccessor;
import com.bigdata.rdf.graph.impl.GASEngine;
import com.bigdata.rdf.graph.impl.GASState;
import com.bigdata.rdf.graph.impl.GASStats;
import com.bigdata.rdf.graph.impl.util.VertexDistribution;
import java.lang.reflect.Constructor;
import java.util.LinkedHashSet;
import java.util.Random;
import java.util.concurrent.Callable;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.log4j.Logger;
import org.openrdf.model.Resource;

public abstract class GASRunnerBase<VS, ES, ST>
implements Callable<IGASStats> {
    private static final Logger log = Logger.getLogger(GASRunnerBase.class);
    private final OptionData opt;

    protected abstract OptionData newOptionData();

    protected OptionData getOptionData() {
        return this.opt;
    }

    protected abstract IGASEngine newGASEngine();

    protected abstract void loadFiles() throws Exception;

    public GASRunnerBase(String[] args) throws ClassNotFoundException {
        String s;
        String arg;
        OptionData opt = this.newOptionData();
        AtomicInteger i = new AtomicInteger(0);
        while (i.get() < args.length && (arg = args[i.get()]).startsWith("-")) {
            if (arg.equals("-seed")) {
                opt.seed = Long.valueOf(args[i.incrementAndGet()]);
            } else if (arg.equals("-nruns")) {
                s = args[i.incrementAndGet()];
                opt.nruns = Integer.valueOf(s);
                if (opt.nruns <= 0) {
                    opt.usage(1, "-nruns must be positive, not: " + s);
                }
            } else if (arg.equals("-nsamples")) {
                s = args[i.incrementAndGet()];
                opt.nsamples = Integer.valueOf(s);
                if (opt.nsamples <= 0) {
                    opt.usage(1, "-nsamples must be positive, not: " + s);
                }
            } else if (arg.equals("-nthreads")) {
                s = args[i.incrementAndGet()];
                opt.nthreads = Integer.valueOf(s);
                if (opt.nthreads < 0) {
                    opt.usage(1, "-nthreads must be non-negative, not: " + s);
                }
            } else if (arg.equals("-schedulerClass")) {
                s = args[i.incrementAndGet()];
                opt.schedulerClassOverride = Class.forName(s);
            } else if (arg.equals("-load")) {
                s = args[i.incrementAndGet()];
                opt.loadSet.add(s);
            } else if (!opt.handleArg(i, args)) {
                opt.usage(1, "Unknown argument: " + arg);
            }
            i.incrementAndGet();
        }
        int nremaining = args.length - i.get();
        if (nremaining != 2) {
            opt.usage(1, nremaining < 1 ? "Too few arguments." : "Too many arguments");
        }
        s = args[i.getAndIncrement()];
        opt.analyticClass = Class.forName(s);
        opt.propertyFile = args[i.getAndIncrement()];
        this.opt = opt;
    }

    protected abstract IGraphAccessor newGraphAccessor();

    protected IGASProgram<VS, ES, ST> newGASProgram() {
        Class cls = this.opt.analyticClass;
        try {
            Constructor ctor = cls.getConstructor(new Class[0]);
            IGASProgram gasProgram = ctor.newInstance(new Object[0]);
            return gasProgram;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final IGASStats call() throws Exception {
        try {
            this.opt.init();
            this.loadFiles();
            IGASStats iGASStats = this.runAnalytic();
            return iGASStats;
        }
        finally {
            this.opt.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final IGASStats runAnalytic() throws Exception {
        IGASEngine gasEngine = this.newGASEngine();
        try {
            Resource[] sampled;
            if (this.opt.schedulerClassOverride != null) {
                ((GASEngine)gasEngine).setSchedulerClass(this.opt.schedulerClassOverride);
            }
            IGASProgram<VS, ES, ST> gasProgram = this.newGASProgram();
            IGraphAccessor graphAccessor = this.newGraphAccessor();
            IGASContext<VS, ES, ST> gasContext = gasEngine.newGASContext(graphAccessor, gasProgram);
            IGASState<VS, ES, ST> gasState = gasContext.getGASState();
            FrontierEnum frontierEnum = gasProgram.getInitialFrontierEnum();
            VertexDistribution dist = frontierEnum.equals((Object)FrontierEnum.SingleVertex) ? graphAccessor.getDistribution(this.opt.r) : null;
            switch (frontierEnum) {
                case SingleVertex: {
                    sampled = dist.getWeightedSample(this.opt.nsamples, gasProgram.getSampleEdgesFilter());
                    break;
                }
                case AllVertices: {
                    sampled = null;
                    break;
                }
                default: {
                    throw new AssertionError();
                }
            }
            GASStats total = new GASStats();
            long nunconnected = 0L;
            for (int run = 0; run < this.opt.nruns; ++run) {
                if (frontierEnum == FrontierEnum.AllVertices) {
                    IGASStats stats = gasContext.call();
                    total.add(stats);
                    if (!log.isInfoEnabled()) continue;
                    log.info("Run complete: stats(sample)=" + stats);
                    continue;
                }
                for (int i = 0; i < sampled.length; ++i) {
                    Resource startingVertex = sampled[i];
                    gasState.setFrontier(gasContext, startingVertex);
                    IGASStats stats = gasContext.call();
                    if (stats.getFrontierSize() == 1L) {
                        if (log.isInfoEnabled()) {
                            log.info("Ignoring unconnected startingVertex: " + startingVertex + ", stats=" + stats);
                        }
                        ++nunconnected;
                        continue;
                    }
                    total.add(stats);
                    if (!log.isInfoEnabled()) continue;
                    log.info("Run complete: vertex[" + i + "] of " + sampled.length + " : startingVertex=" + startingVertex + ", stats(sample)=" + stats);
                }
            }
            StringBuilder sb = new StringBuilder();
            sb.append("TOTAL");
            sb.append(": analytic=" + gasProgram.getClass().getSimpleName());
            sb.append(", nseed=" + this.opt.seed);
            sb.append(", nruns=" + this.opt.nruns);
            sb.append(", nsamples=" + this.opt.nsamples);
            sb.append(", nsampled=" + (sampled == null ? "N/A" : Integer.valueOf(sampled.length)));
            sb.append(", distSize=" + (dist == null ? "N/A" : Integer.valueOf(dist.size())));
            sb.append(", nunconnected=" + nunconnected);
            sb.append(", nthreads=" + this.opt.nthreads);
            sb.append(", scheduler=" + ((GASState)gasState).getScheduler().getClass().getSimpleName());
            sb.append(", gasEngine=" + gasEngine.getClass().getSimpleName());
            this.opt.report(sb);
            sb.append(", stats(total)=" + total);
            System.out.println(sb);
            GASStats gASStats = total;
            return gASStats;
        }
        finally {
            gasEngine.shutdownNow();
        }
    }

    protected class OptionData {
        public static final long DEFAULT_SEED = 217L;
        public static final int DEFAULT_NRUNS = 1;
        public static final int DEFAULT_NSAMPLES = 100;
        public static final int DEFAULT_NTHREADS = 4;
        public long seed = 217L;
        public Random r = null;
        public int nruns = 1;
        public int nsamples = 100;
        public int nthreads = 4;
        public Class<IGASProgram<VS, ES, ST>> analyticClass;
        public Class<IGASSchedulerImpl> schedulerClassOverride;
        public final LinkedHashSet<String> loadSet = new LinkedHashSet();
        public String propertyFile;

        protected OptionData() {
        }

        public void init() throws Exception {
            this.r = new Random(this.seed);
            this.r = new Random(this.seed);
        }

        public void shutdown() {
        }

        public boolean handleArg(AtomicInteger i, String[] args) {
            return false;
        }

        public void usage(int status, String msg) {
            if (msg != null) {
                System.err.println(msg);
            }
            System.err.println("[options] analyticClass propertyFile");
            System.exit(status);
        }

        public void report(StringBuilder sb) {
        }
    }
}

