/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.rdf.graph.impl.util;

import com.bigdata.rdf.graph.impl.util.IIntArraySlice;
import com.bigdata.rdf.graph.impl.util.IManagedIntArray;
import org.apache.log4j.Logger;

public class ManagedIntArray
implements IManagedIntArray {
    private static final transient Logger log = Logger.getLogger(ManagedIntArray.class);
    public static final int DEFAULT_INITIAL_CAPACITY = 128;
    private int[] buf;

    @Override
    public final int[] array() {
        return this.buf;
    }

    @Override
    public final int off() {
        return 0;
    }

    @Override
    public final int len() {
        return this.buf.length;
    }

    protected static int assertNonNegative(String msg, int v) {
        if (v < 0) {
            throw new IllegalArgumentException(msg);
        }
        return v;
    }

    public ManagedIntArray() {
        this(128);
    }

    public ManagedIntArray(int initialCapacity) {
        this.buf = new int[ManagedIntArray.assertNonNegative("initialCapacity", initialCapacity)];
    }

    public ManagedIntArray(int[] array) {
        if (array == null) {
            throw new IllegalArgumentException();
        }
        this.buf = array;
    }

    @Override
    public final void ensureCapacity(int capacity) {
        if (capacity < 0) {
            throw new IllegalArgumentException();
        }
        if (this.buf == null) {
            this.buf = new int[capacity];
            return;
        }
        int overflow = capacity - this.buf.length;
        if (overflow > 0) {
            int[] tmp = new int[this.extend(capacity)];
            System.arraycopy(this.buf, 0, tmp, 0, this.buf.length);
            this.buf = tmp;
        }
    }

    @Override
    public final int capacity() {
        return this.buf == null ? 0 : this.buf.length;
    }

    private int extend(int required) {
        int capacity = Math.max(required, this.capacity() * 2);
        if (log.isInfoEnabled()) {
            log.info("Extending buffer to capacity=" + capacity + " bytes.");
        }
        return capacity;
    }

    @Override
    public final void put(int pos, int[] b) {
        this.put(pos, b, 0, b.length);
    }

    @Override
    public final void put(int pos, int[] b, int off, int len) {
        this.ensureCapacity(pos + len);
        System.arraycopy(b, off, this.buf, pos, len);
    }

    @Override
    public final void get(int srcoff, int[] dst) {
        this.get(srcoff, dst, 0, dst.length);
    }

    @Override
    public final void get(int srcoff, int[] dst, int dstoff, int dstlen) {
        System.arraycopy(this.buf, srcoff, dst, dstoff, dstlen);
    }

    @Override
    public final void putInt(int pos, int v) {
        if (pos + 1 > this.buf.length) {
            this.ensureCapacity(pos + 1);
        }
        this.buf[pos] = v;
    }

    @Override
    public final int getInt(int pos) {
        return this.buf[pos];
    }

    @Override
    public final int[] toArray() {
        int[] tmp = new int[this.buf.length];
        System.arraycopy(this.buf, 0, tmp, 0, this.buf.length);
        return tmp;
    }

    @Override
    public IIntArraySlice slice(int off, int len) {
        return new SliceImpl(off, len);
    }

    private class SliceImpl
    implements IIntArraySlice {
        private final int off;
        private final int len;

        @Override
        public final int off() {
            return this.off;
        }

        @Override
        public final int len() {
            return this.len;
        }

        protected SliceImpl(int off, int len) {
            if (off < 0) {
                throw new IllegalArgumentException("off<0");
            }
            if (len < 0) {
                throw new IllegalArgumentException("len<0");
            }
            this.off = off;
            this.len = len;
        }

        public String toString() {
            return super.toString() + "{off=" + this.off() + ",len=" + this.len() + "}";
        }

        @Override
        public int[] array() {
            return ManagedIntArray.this.array();
        }

        private boolean rangeCheck(int aoff, int alen) {
            if (aoff < 0) {
                throw new IndexOutOfBoundsException();
            }
            if (alen < 0) {
                throw new IndexOutOfBoundsException();
            }
            if (aoff + alen > this.len) {
                throw new IndexOutOfBoundsException();
            }
            return true;
        }

        @Override
        public final void put(int pos, int[] b) {
            this.put(pos, b, 0, b.length);
        }

        @Override
        public final void put(int dstoff, int[] src, int srcoff, int srclen) {
            assert (this.rangeCheck(dstoff, srclen));
            System.arraycopy(src, srcoff, this.array(), this.off + dstoff, srclen);
        }

        @Override
        public final void get(int srcoff, int[] dst) {
            this.get(srcoff, dst, 0, dst.length);
        }

        @Override
        public final void get(int srcoff, int[] dst, int dstoff, int dstlen) {
            assert (this.rangeCheck(srcoff, dstlen));
            System.arraycopy(this.array(), this.off + srcoff, dst, dstoff, dstlen);
        }

        @Override
        public final void putInt(int pos, int v) {
            assert (this.rangeCheck(pos, 1));
            this.array()[pos] = v;
        }

        @Override
        public final int getInt(int pos) {
            assert (this.rangeCheck(pos, 1));
            int v = this.array()[pos];
            return v;
        }

        @Override
        public final int[] toArray() {
            int[] tmp = new int[this.len];
            System.arraycopy(this.array(), this.off, tmp, 0, this.len);
            return tmp;
        }

        @Override
        public IIntArraySlice slice(int aoff, int alen) {
            final SliceImpl outer = this;
            assert (this.rangeCheck(aoff, alen));
            return new SliceImpl(this.off() + aoff, alen){

                @Override
                public int[] array() {
                    return outer.array();
                }
            };
        }
    }
}

