/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.rdf.graph.util;

import com.bigdata.rdf.graph.util.GASUtil;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URISyntaxException;
import java.util.zip.GZIPInputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.apache.log4j.Logger;
import org.openrdf.model.Resource;
import org.openrdf.model.Statement;
import org.openrdf.model.ValueFactory;
import org.openrdf.rio.RDFFormat;
import org.openrdf.rio.RDFHandlerException;
import org.openrdf.rio.RDFParseException;
import org.openrdf.rio.RDFParser;
import org.openrdf.rio.RDFParserFactory;
import org.openrdf.rio.RDFParserRegistry;
import org.openrdf.rio.helpers.RDFHandlerBase;

public abstract class GraphLoader {
    private static final Logger log = Logger.getLogger(GASUtil.class);

    private RDFFormat guessRDFFormat(String n, RDFFormat rdfFormat) {
        RDFFormat fmt = RDFFormat.forFileName(n);
        if (fmt == null && n.endsWith(".zip")) {
            fmt = RDFFormat.forFileName(n.substring(0, n.length() - 4));
        }
        if (fmt == null && n.endsWith(".gz")) {
            fmt = RDFFormat.forFileName(n.substring(0, n.length() - 3));
        }
        if (fmt == null) {
            fmt = rdfFormat;
        }
        return fmt;
    }

    public void loadGraph(RDFFormat fallback, String ... resources) throws Exception {
        if (resources != null) {
            for (String resource : resources) {
                this.loadGraph(fallback, resource);
            }
        }
    }

    protected abstract ValueFactory getValueFactory();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadGraph(RDFFormat fallback, String resource) throws IOException, URISyntaxException, RDFParseException, RDFHandlerException {
        if (log.isInfoEnabled()) {
            log.info("Loading: " + resource);
        }
        String baseURI = null;
        InputStream is = null;
        try {
            is = this.getClass().getResourceAsStream(resource);
            if (is != null) {
                baseURI = this.getClass().getResource(resource).toURI().toString();
            } else {
                File file = new File(resource);
                if (file.exists()) {
                    if (file.isDirectory()) {
                        File[] a;
                        for (File f : a = file.listFiles()) {
                            if (file.isHidden()) {
                                if (!log.isDebugEnabled()) continue;
                                log.debug("Skipping hidden file: " + file);
                                continue;
                            }
                            this.loadGraph(fallback, f.toString());
                        }
                        return;
                    }
                    is = new FileInputStream(file);
                    baseURI = file.toURI().toString();
                } else {
                    throw new FileNotFoundException("Could not locate resource: " + resource);
                }
            }
            if (resource.endsWith(".gz")) {
                is = new GZIPInputStream(is);
            } else if (resource.endsWith(".zip")) {
                try (ZipInputStream zis = new ZipInputStream(is);){
                    ZipEntry e;
                    while ((e = zis.getNextEntry()) != null) {
                        if (e.isDirectory()) continue;
                        baseURI = resource + "/" + e.getName();
                        this.loadFromStream(zis, resource, baseURI, fallback);
                        RDFFormat format = this.guessRDFFormat(e.getName(), fallback);
                        if (format != null || !log.isInfoEnabled()) continue;
                        log.info("Skipping non-RDF entry: resource=" + resource + ", entry=" + e.getName());
                    }
                    return;
                }
            }
            this.loadFromStream(is, resource, baseURI, fallback);
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (Throwable t) {
                    log.error(t);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadFromStream(InputStream is, String resource, String baseURI, RDFFormat fallback) throws RDFParseException, RDFHandlerException, IOException {
        RDFFormat rdfFormat = this.guessRDFFormat(resource, fallback);
        if (rdfFormat == null) {
            if (log.isInfoEnabled()) {
                log.info("Skipping non-RDF resource: " + resource);
            }
            return;
        }
        BufferedReader reader = new BufferedReader(new InputStreamReader(is));
        try {
            RDFParserFactory rdfParserFactory = (RDFParserFactory)RDFParserRegistry.getInstance().get(rdfFormat);
            RDFParser rdfParser = rdfParserFactory.getParser();
            rdfParser.setStopAtFirstError(false);
            ValueFactory vf = this.getValueFactory();
            if (vf != null) {
                rdfParser.setValueFactory(vf);
            }
            AddStatementHandler h = this.newStatementHandler();
            rdfParser.setRDFHandler(h);
            rdfParser.parse(reader, baseURI);
            if (log.isInfoEnabled()) {
                log.info("Done: " + resource + ", nread=" + h.ntriples);
            }
        }
        finally {
            try {
                ((Reader)reader).close();
            }
            catch (Throwable t) {
                log.error(t);
            }
        }
    }

    protected abstract AddStatementHandler newStatementHandler();

    protected abstract class AddStatementHandler
    extends RDFHandlerBase {
        private final Resource[] defaultContext = new Resource[0];
        protected long ntriples = 0L;

        @Override
        public void handleStatement(Statement stmt) throws RDFHandlerException {
            Resource[] resourceArray;
            if (stmt.getContext() == null) {
                resourceArray = this.defaultContext;
            } else {
                Resource[] resourceArray2 = new Resource[1];
                resourceArray = resourceArray2;
                resourceArray2[0] = stmt.getContext();
            }
            Resource[] c = resourceArray;
            this.addStatement(stmt, c);
        }

        protected abstract void addStatement(Statement var1, Resource[] var2) throws RDFHandlerException;
    }
}

