/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.rdf.graph.util;

import com.bigdata.rdf.graph.util.GraphLoader;
import org.openrdf.model.Resource;
import org.openrdf.model.Statement;
import org.openrdf.model.ValueFactory;
import org.openrdf.rio.RDFHandlerException;
import org.openrdf.sail.SailConnection;
import org.openrdf.sail.SailException;

public class SailGraphLoader
extends GraphLoader {
    private final SailConnection cxn;

    public SailGraphLoader(SailConnection cxn) {
        this.cxn = cxn;
    }

    @Override
    protected GraphLoader.AddStatementHandler newStatementHandler() {
        return new SailStatementHandler();
    }

    @Override
    protected ValueFactory getValueFactory() {
        return null;
    }

    private class SailStatementHandler
    extends GraphLoader.AddStatementHandler {
        private SailStatementHandler() {
            super(SailGraphLoader.this);
        }

        @Override
        protected void addStatement(Statement stmt, Resource[] c) throws RDFHandlerException {
            try {
                SailGraphLoader.this.cxn.addStatement(stmt.getSubject(), stmt.getPredicate(), stmt.getObject(), c);
                this.ntriples = c == null || c.length == 0 ? ++this.ntriples : (this.ntriples += (long)c.length);
            }
            catch (SailException e) {
                throw new RDFHandlerException(e);
            }
        }
    }
}

