/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.rdf.inf;

import com.bigdata.rdf.spo.ISPO;
import com.bigdata.rdf.spo.ISPOBuffer;
import com.bigdata.rdf.store.AbstractTripleStore;
import com.bigdata.relation.accesspath.IElementFilter;

public abstract class AbstractSPOBuffer
implements ISPOBuffer {
    protected final ISPO[] stmts;
    protected int numStmts;
    private final AbstractTripleStore _db;
    protected final IElementFilter<ISPO> filter;
    protected final int capacity;
    private int nwritten = 0;

    @Override
    public int size() {
        return this.numStmts;
    }

    @Override
    public boolean isEmpty() {
        return this.numStmts == 0;
    }

    public ISPO get(int i) {
        if (i > this.numStmts) {
            throw new IndexOutOfBoundsException();
        }
        return this.stmts[i];
    }

    protected AbstractTripleStore getTermDatabase() {
        return this._db;
    }

    protected AbstractSPOBuffer(AbstractTripleStore store, IElementFilter<ISPO> filter, int capacity) {
        if (capacity <= 0) {
            throw new IllegalArgumentException();
        }
        this._db = store;
        this.filter = filter;
        this.capacity = capacity;
        this.stmts = new ISPO[capacity];
    }

    protected boolean nearCapacity() {
        return this.numStmts >= this.capacity;
    }

    public String toString() {
        return super.toString() + ":#stmts=" + this.numStmts;
    }

    @Override
    public abstract int flush();

    @Override
    public boolean add(ISPO stmt) {
        assert (stmt != null);
        if (this.filter != null && this.filter.isValid(stmt)) {
            if (DEBUG) {
                log.debug("filter rejects: " + stmt);
            }
            return false;
        }
        if (this.nearCapacity()) {
            this.flush();
        }
        this.stmts[this.numStmts++] = stmt;
        if (DEBUG) {
            log.debug(stmt.toString(this._db));
        }
        return true;
    }

    public void dump(AbstractTripleStore store) {
        System.err.println("capacity=" + this.capacity + ", numStmts=" + this.numStmts);
        for (int i = 0; i < this.numStmts; ++i) {
            ISPO stmt = this.stmts[i];
            System.err.println("#" + (i + 1) + "\t" + stmt.toString(store));
        }
    }
}

