/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.rdf.inf;

import com.bigdata.bop.IBindingSet;
import com.bigdata.bop.IConstant;
import com.bigdata.bop.IPredicate;
import com.bigdata.bop.IVariable;
import com.bigdata.bop.IVariableOrConstant;
import com.bigdata.btree.BTree;
import com.bigdata.btree.DefaultTupleSerializer;
import com.bigdata.btree.IndexMetadata;
import com.bigdata.btree.keys.IKeyBuilder;
import com.bigdata.btree.raba.codec.EmptyRabaValueCoder;
import com.bigdata.journal.TemporaryRawStore;
import com.bigdata.rdf.inf.FullyBufferedJustificationIterator;
import com.bigdata.rdf.internal.IV;
import com.bigdata.rdf.internal.IVUtility;
import com.bigdata.rdf.model.StatementEnum;
import com.bigdata.rdf.rules.InferenceEngine;
import com.bigdata.rdf.spo.ISPO;
import com.bigdata.rdf.spo.SPO;
import com.bigdata.rdf.spo.SPOKeyOrder;
import com.bigdata.rdf.spo.SPOTupleSerializer;
import com.bigdata.rdf.store.AbstractTripleStore;
import com.bigdata.rdf.store.TempTripleStore;
import com.bigdata.relation.rule.IRule;
import com.bigdata.relation.rule.eval.ISolution;
import com.bigdata.striterator.IChunkedIterator;
import java.util.Arrays;
import java.util.UUID;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;

public class Justification
implements Comparable<Justification> {
    protected static final transient Logger log = Logger.getLogger(Justification.class);
    public static final boolean INFO = log.getEffectiveLevel().toInt() <= Level.INFO.toInt();
    public static final boolean DEBUG = log.getEffectiveLevel().toInt() <= Level.DEBUG.toInt();
    private final transient int N;
    public final transient IRule rule;
    final IV[] ivs;

    public SPO getHead() {
        return new SPO(this.ivs[0], this.ivs[1], this.ivs[2], StatementEnum.Inferred);
    }

    public SPO[] getTail() {
        int m = this.ivs.length / this.N - 1;
        SPO[] tail = new SPO[m];
        int j = this.N;
        int i = 0;
        while (i < m) {
            tail[i] = new SPO(this.ivs[j], this.ivs[j + 1], this.ivs[j + 2], StatementEnum.Inferred);
            ++i;
            j += this.N;
        }
        return tail;
    }

    public Justification(ISolution solution) {
        IRule rule = solution.getRule();
        this.N = rule.getHead().arity();
        SPO head = (SPO)solution.get();
        IBindingSet bindingSet = solution.getBindingSet();
        assert (rule != null);
        assert (head != null);
        assert (head.isFullyBound());
        assert (bindingSet != null);
        this.rule = rule;
        int tailCount = rule.getTailCount();
        this.ivs = new IV[(1 + tailCount) * this.N];
        int j = 0;
        this.ivs[j++] = head.s;
        this.ivs[j++] = head.p;
        this.ivs[j++] = head.o;
        for (int tailIndex = 0; tailIndex < tailCount; ++tailIndex) {
            IPredicate predicate = rule.getTail(tailIndex);
            for (int i = 0; i < this.N; ++i) {
                IConstant c;
                IVariableOrConstant t = predicate.get(i);
                Object id = t.isVar() ? ((c = bindingSet.get((IVariable)t)) == null ? null : (IV)c.get()) : (IV)t.get();
                this.ivs[j++] = id;
            }
        }
    }

    public Justification(int N, IV[] ids) {
        this.rule = null;
        this.N = N;
        this.ivs = ids;
    }

    public static byte[] getKey(IKeyBuilder keyBuilder, Justification jst) {
        if (keyBuilder == null) {
            throw new IllegalArgumentException();
        }
        if (jst == null) {
            throw new IllegalArgumentException();
        }
        keyBuilder.reset();
        IV[] ivs = jst.ivs;
        for (int i = 0; i < ivs.length; ++i) {
            IVUtility.encode(keyBuilder, ivs[i]);
        }
        return keyBuilder.getKey();
    }

    public boolean equals(Justification o) {
        if (this == o) {
            return true;
        }
        return Arrays.equals(this.ivs, o.ivs);
    }

    @Override
    public int compareTo(Justification o) {
        int len = this.ivs.length > o.ivs.length ? this.ivs.length : o.ivs.length;
        for (int i = 0; i < len; ++i) {
            if (i >= this.ivs.length) {
                return -1;
            }
            if (i >= o.ivs.length) {
                return 1;
            }
            int ret = IVUtility.compare(this.ivs[i], o.ivs[i]);
            if (ret == 0) continue;
            return ret;
        }
        assert (this.ivs.length == o.ivs.length);
        return 0;
    }

    public String toString() {
        return this.toString(null);
    }

    public String toString(AbstractTripleStore db) {
        StringBuilder sb = new StringBuilder();
        if (this.rule != null) {
            sb.append(this.rule.getName());
            sb.append("\n");
        }
        int m = this.ivs.length / this.N - 1;
        for (int i = 0; i < m; ++i) {
            sb.append("\t(");
            for (int j = 0; j < this.N; ++j) {
                IV id = this.ivs[i * this.N + this.N + j];
                sb.append(db == null ? "" + id : db.toString(id));
                if (j + 1 >= this.N) continue;
                sb.append(", ");
            }
            sb.append(")");
            if (i + 1 >= m) continue;
            sb.append(", \n");
        }
        sb.append("\n\t-> ");
        sb.append("(");
        for (int i = 0; i < this.N && i < this.ivs.length; ++i) {
            IV id = this.ivs[i];
            sb.append(db == null ? "" + id : db.toString(id));
            if (i + 1 >= this.N) continue;
            sb.append(", ");
        }
        sb.append(")");
        return sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isGrounded(InferenceEngine inf, TempTripleStore focusStore, AbstractTripleStore db, SPO head, boolean testHead, boolean testFocusStore) {
        try (VisitedSPOSet visited = new VisitedSPOSet(focusStore.getIndexManager());){
            boolean ret = Justification.isGrounded(inf, focusStore, db, head, testHead, testFocusStore, visited);
            if (log.isInfoEnabled()) {
                log.info("head=" + head + " is " + (ret ? "" : "NOT ") + "grounded : testHead=" + testHead + ", testFocusStore=" + testFocusStore + ", #visited=" + visited.size());
            }
            boolean bl = ret;
            return bl;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isGrounded(InferenceEngine inf, TempTripleStore focusStore, AbstractTripleStore db, ISPO head, boolean testHead, boolean testFocusStore, VisitedSPOSet visited) {
        IChunkedIterator<Justification> itr;
        assert (focusStore != null);
        if (DEBUG) {
            log.debug("head=" + head.toString(db) + ", testHead=" + testHead + ", testFocusStore=" + testFocusStore + ", #visited=" + visited.size());
        }
        if (testHead) {
            if (head.getStatementType() != StatementEnum.Inferred) {
                return true;
            }
            if (db.isAxiom(head.s(), head.p(), head.o())) {
                return true;
            }
            if (!visited.add(head)) {
                if (DEBUG) {
                    log.debug("Already visited: " + head.toString(db));
                }
                return false;
            }
            itr = db.getAccessPath(head.s(), head.p(), head.o()).iterator();
            try {
                while (itr.hasNext()) {
                    ISPO spo = (ISPO)((Object)itr.next());
                    if (DEBUG) {
                        log.debug("considering: " + spo.toString(db));
                    }
                    if (db.isAxiom(spo.s(), spo.p(), spo.o())) {
                        boolean bl = true;
                        return bl;
                    }
                    if (spo.getStatementType() == StatementEnum.Explicit) {
                        if (!testFocusStore) {
                            boolean bl = true;
                            return bl;
                        }
                        if (!focusStore.hasStatement(spo.s(), spo.p(), spo.o())) {
                            boolean bl = true;
                            return bl;
                        }
                    }
                    if (!Justification.isGrounded(inf, focusStore, db, spo, false, testFocusStore, visited)) continue;
                    boolean bl = true;
                    return bl;
                }
            }
            finally {
                itr.close();
            }
        }
        if (head.isFullyBound()) {
            itr = new FullyBufferedJustificationIterator(db, head);
            while (itr.hasNext()) {
                Justification jst = (Justification)itr.next();
                if (DEBUG) {
                    log.debug("Considering:\n" + jst.toString(db));
                }
                SPO[] tail = jst.getTail();
                boolean ok = true;
                for (SPO t : tail) {
                    if (Justification.isGrounded(inf, focusStore, db, t, true, testFocusStore, visited)) continue;
                    ok = false;
                    if (!DEBUG) break;
                    log.debug("Not grounded: tail=" + t.toString(db));
                    break;
                }
                if (!ok) continue;
                if (DEBUG) {
                    log.debug("Grounded:\n" + jst.toString(db));
                }
                return true;
            }
        }
        if (DEBUG) {
            log.debug("Not grounded: " + head.toString(db));
        }
        return false;
    }

    public static class VisitedSPOSet {
        private BTree btree;
        private final SPOTupleSerializer tupleSer;

        public VisitedSPOSet(TemporaryRawStore tempStore) {
            IndexMetadata metadata = new IndexMetadata(UUID.randomUUID());
            this.tupleSer = new SPOTupleSerializer(SPOKeyOrder.SPO, false, DefaultTupleSerializer.getDefaultLeafKeysCoder(), EmptyRabaValueCoder.INSTANCE);
            metadata.setTupleSerializer(this.tupleSer);
            this.btree = BTree.create(tempStore, metadata);
        }

        public boolean add(ISPO spo) {
            byte[] key;
            if (DEBUG) {
                log.debug(spo.toString());
            }
            if (!this.btree.contains(key = this.tupleSer.serializeKey(spo))) {
                this.btree.insert(key, null);
                return true;
            }
            return false;
        }

        public long size() {
            return this.btree.getEntryCount();
        }

        public void close() {
            if (this.btree != null) {
                this.btree.removeAll();
                this.btree = null;
            }
        }

        protected void finalized() throws Exception {
            this.close();
        }
    }
}

