/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.rdf.inf;

import com.bigdata.rdf.changesets.IChangeLog;
import com.bigdata.rdf.inf.AbstractSPOBuffer;
import com.bigdata.rdf.inf.Justification;
import com.bigdata.rdf.spo.ISPO;
import com.bigdata.rdf.spo.ISPOAssertionBuffer;
import com.bigdata.rdf.spo.JustificationWriter;
import com.bigdata.rdf.spo.SPO;
import com.bigdata.rdf.spo.StatementWriter;
import com.bigdata.rdf.store.AbstractTripleStore;
import com.bigdata.relation.accesspath.IElementFilter;
import com.bigdata.striterator.ChunkedArrayIterator;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.atomic.AtomicLong;

public class SPOAssertionBuffer
extends AbstractSPOBuffer
implements ISPOAssertionBuffer {
    private final AbstractTripleStore db;
    private final AbstractTripleStore focusStore;
    private final Justification[] justifications;
    private int numJustifications;
    protected final boolean justify;
    protected final IChangeLog changeLog;

    public AbstractTripleStore getFocusStore() {
        return this.focusStore;
    }

    @Override
    public int getJustificationCount() {
        return this.numJustifications;
    }

    public SPOAssertionBuffer(AbstractTripleStore focusStore, AbstractTripleStore db, IElementFilter<ISPO> filter, int capacity, boolean justified) {
        this(focusStore, db, filter, capacity, justified, null);
    }

    public SPOAssertionBuffer(AbstractTripleStore focusStore, AbstractTripleStore db, IElementFilter<ISPO> filter, int capacity, boolean justified, IChangeLog changeLog) {
        super(db, filter, capacity);
        if (focusStore == null) {
            throw new IllegalArgumentException();
        }
        if (db == null) {
            throw new IllegalArgumentException();
        }
        this.db = db;
        this.focusStore = focusStore;
        this.justify = justified;
        this.justifications = justified ? new Justification[capacity] : null;
        this.changeLog = changeLog;
    }

    @Override
    protected boolean nearCapacity() {
        if (super.nearCapacity()) {
            return true;
        }
        return this.numJustifications + 1 > this.capacity;
    }

    @Override
    public int flush() {
        long n;
        if (this.isEmpty()) {
            return 0;
        }
        if (log.isInfoEnabled()) {
            log.info("numStmts=" + this.numStmts + ", numJustifications=" + this.numJustifications);
        }
        long begin = System.currentTimeMillis();
        if (this.numJustifications == 0) {
            n = this.changeLog == null ? this.db.addStatements(this.focusStore, true, new ChunkedArrayIterator<ISPO>(this.numStmts, this.stmts, null), null) : com.bigdata.rdf.changesets.StatementWriter.addStatements(this.db, this.focusStore, true, null, new ChunkedArrayIterator<ISPO>(this.numStmts, this.stmts, null), this.changeLog);
        } else {
            long elapsed_JST;
            long elapsed_SPO;
            ArrayList<Callable<Long>> tasks = new ArrayList<Callable<Long>>(2);
            AtomicLong nwritten = new AtomicLong();
            tasks.add(new StatementWriter(this.getTermDatabase(), this.focusStore, false, new ChunkedArrayIterator<ISPO>(this.numStmts, this.stmts, null), nwritten, this.changeLog));
            AtomicLong nwrittenj = new AtomicLong();
            tasks.add(new JustificationWriter(this.focusStore, new ChunkedArrayIterator<Justification>(this.numJustifications, this.justifications, null), nwrittenj));
            try {
                List futures = this.focusStore.getIndexManager().getExecutorService().invokeAll(tasks);
                elapsed_SPO = (Long)futures.get(0).get();
                elapsed_JST = (Long)futures.get(1).get();
            }
            catch (InterruptedException ex) {
                throw new RuntimeException(ex);
            }
            catch (ExecutionException ex) {
                throw new RuntimeException(ex);
            }
            if (log.isInfoEnabled()) {
                log.info("Wrote " + nwritten + " statements in " + elapsed_SPO + "ms and " + nwrittenj + " justifications in " + elapsed_JST + "ms");
            }
            n = nwritten.get();
        }
        long elapsed = System.currentTimeMillis() - begin;
        if (log.isInfoEnabled()) {
            log.info("Wrote " + n + " statements" + (this.justify ? " with " + this.numJustifications + " justifications" : "") + " in " + elapsed + "ms");
        }
        this.numJustifications = 0;
        this.numStmts = 0;
        return (int)Math.min(Integer.MAX_VALUE, n);
    }

    @Override
    public boolean add(SPO stmt, Justification justification) {
        if (!super.add(stmt)) {
            if (DEBUG) {
                log.debug("(filtered out)\n" + (justification == null ? stmt.toString(this.getTermDatabase()) : justification.toString(this.getTermDatabase())));
            }
            return false;
        }
        assert (!this.justify ? justification == null : justification != null);
        if (this.justify) {
            this.justifications[this.numJustifications++] = justification;
            if (DEBUG) {
                log.debug("\n" + (justification == null ? stmt.toString(this.getTermDatabase()) : justification.toString(this.getTermDatabase())));
            }
        }
        return true;
    }

    @Override
    public void dump(AbstractTripleStore store) {
        System.err.println("numJusts=" + this.numJustifications);
        super.dump(store);
    }
}

