/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.rdf.internal;

import com.bigdata.rdf.internal.XSD;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.UUID;
import org.openrdf.model.URI;

public enum DTE {
    XSDBoolean(0, 1, Boolean.class, XSD.BOOLEAN, 0),
    XSDByte(1, 1, Byte.class, XSD.BYTE, 1),
    XSDShort(2, 2, Short.class, XSD.SHORT, 1),
    XSDInt(3, 4, Integer.class, XSD.INT, 1),
    XSDLong(4, 8, Long.class, XSD.LONG, 1),
    XSDUnsignedByte(5, 1, Byte.class, XSD.UNSIGNED_BYTE, 3),
    XSDUnsignedShort(6, 2, Short.class, XSD.UNSIGNED_SHORT, 3),
    XSDUnsignedInt(7, 4, Integer.class, XSD.UNSIGNED_INT, 3),
    XSDUnsignedLong(8, 8, Long.class, XSD.UNSIGNED_LONG, 3),
    XSDFloat(9, 4, Float.class, XSD.FLOAT, 1),
    XSDDouble(10, 8, Double.class, XSD.DOUBLE, 1),
    XSDInteger(11, 0, BigInteger.class, XSD.INTEGER, 1),
    XSDDecimal(12, 0, BigDecimal.class, XSD.DECIMAL, 1),
    UUID(13, 16, UUID.class, XSD.UUID, 0),
    XSDString(14, 0, String.class, XSD.STRING, 0),
    Extension(15, 0, Void.class, null, 0);

    final byte v;
    private final int len;
    private final Class<?> cls;
    private final URI datatypeURI;
    private final int flags;

    private DTE(byte v, int len, Class<?> cls, URI datatypeURI, int flags) {
        this.v = v;
        this.len = len;
        this.cls = cls;
        this.datatypeURI = datatypeURI;
        this.flags = flags;
    }

    public static final DTE valueOf(byte b) {
        switch (b & 0xF) {
            case 0: {
                return XSDBoolean;
            }
            case 1: {
                return XSDByte;
            }
            case 2: {
                return XSDShort;
            }
            case 3: {
                return XSDInt;
            }
            case 4: {
                return XSDLong;
            }
            case 5: {
                return XSDUnsignedByte;
            }
            case 6: {
                return XSDUnsignedShort;
            }
            case 7: {
                return XSDUnsignedInt;
            }
            case 8: {
                return XSDUnsignedLong;
            }
            case 9: {
                return XSDFloat;
            }
            case 10: {
                return XSDDouble;
            }
            case 11: {
                return XSDInteger;
            }
            case 12: {
                return XSDDecimal;
            }
            case 13: {
                return UUID;
            }
            case 14: {
                return XSDString;
            }
            case 15: {
                return Extension;
            }
        }
        throw new IllegalArgumentException(Byte.toString(b));
    }

    public static final DTE valueOf(URI datatype) {
        if (datatype == null) {
            return null;
        }
        if (datatype.equals(XSD.BOOLEAN)) {
            return XSDBoolean;
        }
        if (datatype.equals(XSD.BYTE)) {
            return XSDByte;
        }
        if (datatype.equals(XSD.SHORT)) {
            return XSDShort;
        }
        if (datatype.equals(XSD.INT)) {
            return XSDInt;
        }
        if (datatype.equals(XSD.LONG)) {
            return XSDLong;
        }
        if (datatype.equals(XSD.UNSIGNED_BYTE)) {
            return XSDUnsignedByte;
        }
        if (datatype.equals(XSD.UNSIGNED_SHORT)) {
            return XSDUnsignedShort;
        }
        if (datatype.equals(XSD.UNSIGNED_INT)) {
            return XSDUnsignedInt;
        }
        if (datatype.equals(XSD.UNSIGNED_LONG)) {
            return XSDUnsignedLong;
        }
        if (datatype.equals(XSD.FLOAT)) {
            return XSDFloat;
        }
        if (datatype.equals(XSD.DOUBLE)) {
            return XSDDouble;
        }
        if (datatype.equals(XSD.INTEGER)) {
            return XSDInteger;
        }
        if (datatype.equals(XSD.DECIMAL)) {
            return XSDDecimal;
        }
        if (datatype.equals(XSD.UUID)) {
            return UUID;
        }
        if (datatype.equals(XSD.STRING)) {
            return XSDString;
        }
        return null;
    }

    public final byte v() {
        return this.v;
    }

    public final int len() {
        return this.len;
    }

    public final Class<?> getCls() {
        return this.cls;
    }

    public final URI getDatatypeURI() {
        return this.datatypeURI;
    }

    public boolean isNumeric() {
        return (this.flags & 1) != 0;
    }

    public boolean isSignedNumeric() {
        return this.isNumeric() && !this.isUnsignedNumeric();
    }

    public boolean isUnsignedNumeric() {
        return this.flags == 3;
    }

    public boolean isFixedNumeric() {
        return (this.flags & 1) != 0 && this.len != 0;
    }

    public boolean isBigNumeric() {
        return (this.flags & 1) != 0 && this.len == 0;
    }

    public boolean isFloatingPointNumeric() {
        return this == XSDFloat || this == XSDDouble || this == XSDDecimal;
    }
}

