/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.rdf.internal;

import com.bigdata.rdf.internal.InlineURIHandler;
import com.bigdata.rdf.internal.impl.literal.AbstractLiteralIV;
import com.bigdata.rdf.internal.impl.literal.UUIDLiteralIV;
import com.bigdata.rdf.model.BigdataLiteral;
import java.nio.ByteBuffer;
import java.util.UUID;
import javax.xml.bind.DatatypeConverter;

public class InlineHexUUIDURIHandler
extends InlineURIHandler {
    public static final String NAMESPACE = "urn:hex:uuid:";

    public InlineHexUUIDURIHandler(String namespace) {
        super(namespace);
    }

    @Override
    protected AbstractLiteralIV createInlineIV(String localName) {
        if (localName == null) {
            return null;
        }
        try {
            byte[] uuid = DatatypeConverter.parseHexBinary(localName);
            return new UUIDLiteralIV(InlineHexUUIDURIHandler.asUuid(uuid));
        }
        catch (IllegalArgumentException ex) {
            return null;
        }
    }

    @Override
    public String getLocalNameFromDelegate(AbstractLiteralIV<BigdataLiteral, ?> delegate) {
        UUID uuid = ((UUIDLiteralIV)delegate).getInlineValue();
        String localName = DatatypeConverter.printHexBinary(InlineHexUUIDURIHandler.asBytes(uuid));
        return localName;
    }

    public static UUID asUuid(byte[] bytes) {
        ByteBuffer bb = ByteBuffer.wrap(bytes);
        long firstLong = bb.getLong();
        long secondLong = bb.getLong();
        return new UUID(firstLong, secondLong);
    }

    public static byte[] asBytes(UUID uuid) {
        ByteBuffer bb = ByteBuffer.wrap(new byte[16]);
        bb.putLong(uuid.getMostSignificantBits());
        bb.putLong(uuid.getLeastSignificantBits());
        return bb.array();
    }
}

