/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.rdf.internal;

import com.bigdata.rdf.internal.IPrefixedURIHandler;
import com.bigdata.rdf.internal.ISuffixedURIHandler;
import com.bigdata.rdf.internal.InlineLocalNameIntegerURIHandler;
import com.bigdata.rdf.internal.InlineURIHandler;
import com.bigdata.rdf.internal.impl.literal.AbstractLiteralIV;
import com.bigdata.rdf.model.BigdataLiteral;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.log4j.Logger;

public class InlineIntegerURIHandlerMap
extends InlineLocalNameIntegerURIHandler {
    private static final Logger log = Logger.getLogger(InlineIntegerURIHandlerMap.class);
    public static final Pattern descriptorPattern = Pattern.compile("(.*[a-zA-Z])\\d+(_.*)");
    private HashMap<Integer, InlineURIHandler> hMap = new HashMap();
    private final TreeMap<String, InlineURIHandler> handlersByLocalName = new TreeMap();

    public InlineIntegerURIHandlerMap(String namespace) {
        super(namespace);
    }

    public void addHandlerForNS(int id, InlineURIHandler handler) {
        assert (handler != null);
        Integer key = new Integer(id);
        InlineURIHandler h = this.hMap.get(key);
        if (h != null) {
            log.warn("Handler " + h.getClass().getName() + " already registered for id: " + id + ".  Overriding with a new value.");
        }
        this.hMap.put(key, handler);
        this.handlersByLocalName.put(this.getKeyForHandler(handler), handler);
    }

    @Override
    public String getLocalNameFromDelegate(AbstractLiteralIV<BigdataLiteral, ?> delegate) {
        String str = delegate.getInlineValue().toString();
        Integer key = new Integer(this.unpackId(str));
        if (!this.hMap.containsKey(key)) {
            throw new RuntimeException(key + " decoded from " + str + " for " + this.getNamespace() + " is not registered.");
        }
        InlineURIHandler h = this.hMap.get(key);
        return h.getLocalNameFromDelegate(delegate);
    }

    @Override
    protected AbstractLiteralIV createInlineIV(String localName) {
        InlineURIHandler handler;
        AbstractLiteralIV iv;
        Map.Entry<String, InlineURIHandler> floorEntry;
        Matcher m = descriptorPattern.matcher(localName);
        String str = "";
        if (m.matches()) {
            if (m.end() > 1) {
                str = str + m.group(1) + m.group(2);
            } else if (m.end(1) > 0) {
                str = str + m.group(1);
            } else {
                log.warn("No localname match found for " + localName);
            }
        }
        if ((floorEntry = this.handlersByLocalName.floorEntry(str)) == null) {
            return null;
        }
        String prefix = floorEntry.getKey();
        if (str.startsWith(prefix) && (iv = (handler = floorEntry.getValue()).createInlineIV(localName)) != null) {
            return iv;
        }
        return null;
    }

    private String getKeyForHandler(InlineURIHandler handler) {
        String key = "";
        if (handler instanceof IPrefixedURIHandler) {
            key = key + ((IPrefixedURIHandler)((Object)handler)).getPrefix();
        }
        if (handler instanceof ISuffixedURIHandler) {
            key = key + ((ISuffixedURIHandler)((Object)handler)).getSuffix();
        }
        return key;
    }
}

