/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.rdf.internal;

import com.bigdata.rdf.internal.IV;
import com.bigdata.rdf.internal.impl.literal.AbstractLiteralIV;
import com.bigdata.rdf.internal.impl.uri.URIExtensionIV;
import com.bigdata.rdf.model.BigdataLiteral;
import com.bigdata.rdf.vocab.Vocabulary;
import org.apache.log4j.Logger;
import org.openrdf.model.URI;
import org.openrdf.model.impl.URIImpl;

public abstract class InlineURIHandler {
    private static final Logger log = Logger.getLogger(InlineURIHandler.class);
    private final String namespace;
    private final int len;
    protected transient IV namespaceIV;

    public InlineURIHandler(String namespace) {
        this.namespace = namespace;
        this.len = namespace.length();
    }

    public void init(Vocabulary vocab) {
        this.namespaceIV = vocab.get(new URIImpl(this.namespace));
        if (this.namespaceIV == null) {
            log.warn("No vocabulary entry for namespace - URIs with this namespace will not be inlined: namespace=" + this.namespace);
        }
    }

    public String getNamespace() {
        return this.namespace;
    }

    public URIExtensionIV createInlineIV(URI uri) {
        if (this.namespaceIV == null) {
            return null;
        }
        String localName = uri.stringValue().substring(this.len);
        AbstractLiteralIV localNameIV = this.createInlineIV(localName);
        if (localNameIV != null) {
            return new URIExtensionIV(localNameIV, this.namespaceIV);
        }
        return null;
    }

    public String getLocalNameFromDelegate(AbstractLiteralIV<BigdataLiteral, ?> delegate) {
        return delegate.getInlineValue().toString();
    }

    protected abstract AbstractLiteralIV createInlineIV(String var1);
}

