/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.rdf.internal;

import com.bigdata.rdf.internal.InlineURIHandler;
import com.bigdata.rdf.internal.impl.literal.AbstractLiteralIV;
import com.bigdata.rdf.internal.impl.literal.XSDIntegerIV;
import com.bigdata.rdf.internal.impl.literal.XSDUnsignedByteIV;
import com.bigdata.rdf.internal.impl.literal.XSDUnsignedIntIV;
import com.bigdata.rdf.internal.impl.literal.XSDUnsignedLongIV;
import com.bigdata.rdf.internal.impl.literal.XSDUnsignedShortIV;
import java.math.BigInteger;
import org.apache.log4j.Logger;

public class InlineUnsignedIntegerURIHandler
extends InlineURIHandler {
    private static final Logger log = Logger.getLogger(InlineUnsignedIntegerURIHandler.class);
    private static final BigInteger MAX_UNSIGNED_LONG_AS_BIGINT = new BigInteger("18446744073709551616");

    public InlineUnsignedIntegerURIHandler(String namespace) {
        super(namespace);
    }

    @Override
    protected AbstractLiteralIV createInlineIV(String localName) {
        BigInteger value;
        try {
            value = new BigInteger(localName, 10);
        }
        catch (NumberFormatException e) {
            if (log.isDebugEnabled()) {
                log.debug("Invalid integer", e);
            }
            return null;
        }
        if (value.compareTo(BigInteger.ZERO) <= 0) {
            return null;
        }
        return InlineUnsignedIntegerURIHandler.createInlineIV(value);
    }

    public static AbstractLiteralIV createInlineIV(BigInteger value) {
        if (value.compareTo(MAX_UNSIGNED_LONG_AS_BIGINT) >= 0) {
            return new XSDIntegerIV(value);
        }
        return InlineUnsignedIntegerURIHandler.createInlineIV(value.longValue());
    }

    public static AbstractLiteralIV createInlineIV(long value) {
        if (value < 256L) {
            return new XSDUnsignedByteIV((byte)(value + -128L));
        }
        if (value < 65536L) {
            return new XSDUnsignedShortIV((short)(value + -32768L));
        }
        if (value < 0x100000000L) {
            return new XSDUnsignedIntIV((int)(value + Integer.MIN_VALUE));
        }
        return new XSDUnsignedLongIV(value + Long.MIN_VALUE);
    }
}

