/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.rdf.internal.constraints;

import com.bigdata.bop.BOp;
import com.bigdata.bop.IBindingSet;
import com.bigdata.bop.IValueExpression;
import com.bigdata.bop.NV;
import com.bigdata.rdf.error.SparqlTypeErrorException;
import com.bigdata.rdf.internal.IV;
import com.bigdata.rdf.internal.constraints.INeedsMaterialization;
import com.bigdata.rdf.internal.constraints.IVValueExpression;
import com.bigdata.rdf.sparql.ast.GlobalAnnotations;
import java.util.Map;
import org.openrdf.model.Literal;
import org.openrdf.model.URI;

public class ConcatBOp
extends IVValueExpression<IV>
implements INeedsMaterialization {
    private static final long serialVersionUID = 5894411703430694650L;

    public ConcatBOp(GlobalAnnotations globals, IValueExpression<? extends IV> ... args) {
        super(args, ConcatBOp.anns(globals, new NV[0]));
    }

    public ConcatBOp(BOp[] args, Map<String, Object> anns) {
        super(args, anns);
        if (args.length < 1 || args[0] == null) {
            throw new IllegalArgumentException();
        }
    }

    public ConcatBOp(ConcatBOp op) {
        super(op);
    }

    @Override
    public INeedsMaterialization.Requirement getRequirement() {
        return INeedsMaterialization.Requirement.SOMETIMES;
    }

    @Override
    public IV get(IBindingSet bs) {
        URI datatype = null;
        String lang = null;
        boolean allSame = true;
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < this.arity(); ++i) {
            IV v = this.getAndCheckLiteral(i, bs);
            if (v.isNumeric()) {
                throw new SparqlTypeErrorException();
            }
            String label = null;
            if (allSame) {
                Literal lit = ConcatBOp.asLiteral(v);
                label = lit.getLabel();
                if (lit.getDatatype() != null) {
                    if (lang != null) {
                        allSame = false;
                    } else if (datatype == null) {
                        if (i == 0) {
                            datatype = lit.getDatatype();
                        } else {
                            allSame = false;
                        }
                    } else if (!datatype.equals(lit.getDatatype())) {
                        allSame = false;
                    }
                } else if (lit.getLanguage() != null) {
                    if (datatype != null) {
                        allSame = false;
                    } else if (lang == null) {
                        if (i == 0) {
                            lang = lit.getLanguage();
                        } else {
                            allSame = false;
                        }
                    } else if (!lang.equals(lit.getLanguage())) {
                        allSame = false;
                    }
                } else {
                    allSame = false;
                }
            } else {
                label = this.literalLabel(v);
            }
            sb.append(label);
        }
        if (allSame) {
            if (datatype != null) {
                return super.asIV(this.getValueFactory().createLiteral(sb.toString(), datatype), bs);
            }
            if (lang != null) {
                return super.asIV(this.getValueFactory().createLiteral(sb.toString(), lang), bs);
            }
        }
        return super.asIV(this.getValueFactory().createLiteral(sb.toString()), bs);
    }
}

