/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.rdf.internal.constraints;

import com.bigdata.bop.BOp;
import com.bigdata.bop.IBindingSet;
import com.bigdata.bop.IValueExpression;
import com.bigdata.bop.NV;
import com.bigdata.rdf.error.SparqlTypeErrorException;
import com.bigdata.rdf.internal.IV;
import com.bigdata.rdf.internal.XSD;
import com.bigdata.rdf.internal.constraints.INeedsMaterialization;
import com.bigdata.rdf.internal.constraints.IVValueExpression;
import com.bigdata.rdf.model.BigdataValueFactory;
import com.bigdata.rdf.sparql.ast.GlobalAnnotations;
import java.util.Map;
import org.apache.log4j.Logger;
import org.openrdf.model.Literal;
import org.openrdf.model.URI;
import org.openrdf.model.Value;
import org.openrdf.model.vocabulary.RDF;

public class DatatypeBOp
extends IVValueExpression<IV>
implements INeedsMaterialization {
    private static final long serialVersionUID = 7391999162162545704L;
    private static final transient Logger log = Logger.getLogger(DatatypeBOp.class);

    public DatatypeBOp(IValueExpression<? extends IV> x, GlobalAnnotations globals) {
        this(new BOp[]{x}, DatatypeBOp.anns(globals, new NV[0]));
    }

    public DatatypeBOp(BOp[] args, Map<String, Object> anns) {
        super(args, anns);
        if (args.length != 1 || args[0] == null) {
            throw new IllegalArgumentException();
        }
        if (this.getProperty(IVValueExpression.Annotations.NAMESPACE) == null) {
            throw new IllegalArgumentException();
        }
    }

    public DatatypeBOp(DatatypeBOp op) {
        super(op);
    }

    @Override
    public IV get(IBindingSet bs) {
        Value val;
        BigdataValueFactory vf = super.getValueFactory();
        IV iv = this.getAndCheckLiteral(0, bs);
        if (iv == null) {
            throw new SparqlTypeErrorException();
        }
        if (log.isDebugEnabled()) {
            log.debug(iv);
        }
        if ((val = DatatypeBOp.asValue(iv)) instanceof Literal) {
            URI datatype;
            Literal literal = (Literal)val;
            if (literal.getDatatype() != null) {
                datatype = literal.getDatatype();
            } else if (literal.getLanguage() != null) {
                datatype = RDF.LANGSTRING;
            } else if (literal.getLanguage() == null) {
                datatype = XSD.STRING;
            } else {
                throw new SparqlTypeErrorException();
            }
            return this.asIV(datatype, bs);
        }
        throw new SparqlTypeErrorException();
    }

    @Override
    public INeedsMaterialization.Requirement getRequirement() {
        return INeedsMaterialization.Requirement.SOMETIMES;
    }
}

