/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.rdf.internal.constraints;

import com.bigdata.bop.BOp;
import com.bigdata.bop.IBindingSet;
import com.bigdata.bop.IConstant;
import com.bigdata.bop.IValueExpression;
import com.bigdata.rdf.error.SparqlTypeErrorException;
import com.bigdata.rdf.internal.IV;
import com.bigdata.rdf.internal.constraints.InBOp;
import java.util.Arrays;
import java.util.Map;

public class InBinaryBOp
extends InBOp {
    private static final long serialVersionUID = 2251370041131847351L;
    private volatile transient IValueExpression<IV> valueExpr;
    private volatile transient IV[] set;
    private transient boolean not;

    public InBinaryBOp(InBinaryBOp op) {
        super(op);
    }

    public InBinaryBOp(BOp[] args, Map<String, Object> annotations) {
        super(args, annotations);
    }

    public InBinaryBOp(boolean not, IValueExpression<? extends IV> var, IConstant<? extends IV> ... set) {
        super(not, var, set);
    }

    private static IV[] sort(IConstant<IV>[] set) {
        int n = set.length;
        if (n == 0) {
            throw new IllegalArgumentException();
        }
        Object[] tmp = new IV[n];
        for (int i = 0; i < n; ++i) {
            tmp[i] = (IV)set[i].get();
        }
        Arrays.sort(tmp);
        return tmp;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void mutation() {
        super.mutation();
        if (this.set != null) {
            InBinaryBOp inBinaryBOp = this;
            synchronized (inBinaryBOp) {
                if (this.set != null) {
                    this.set = null;
                }
            }
        }
    }

    private void init() {
        this.valueExpr = this.getValueExpression();
        this.set = InBinaryBOp.sort(this.getSet());
        this.not = (Boolean)this.getProperty(InBOp.Annotations.NOT);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean accept(IBindingSet bindingSet) {
        boolean found;
        IV v;
        Object[] _set;
        if (this.valueExpr == null || this.set == null) {
            InBinaryBOp inBinaryBOp = this;
            synchronized (inBinaryBOp) {
                if (this.valueExpr == null || this.set == null) {
                    this.init();
                }
                _set = this.set;
            }
        } else {
            _set = this.set;
        }
        if ((v = this.valueExpr.get(bindingSet)) == null) {
            throw new SparqlTypeErrorException.UnboundVarException();
        }
        int pos = Arrays.binarySearch(_set, v);
        boolean bl = found = pos >= 0;
        return this.not ? !found : found;
    }
}

