/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.rdf.internal.constraints;

import com.bigdata.bop.BOp;
import com.bigdata.bop.IBindingSet;
import com.bigdata.bop.IValueExpression;
import com.bigdata.bop.NV;
import com.bigdata.rdf.error.SparqlTypeErrorException;
import com.bigdata.rdf.internal.ILexiconConfiguration;
import com.bigdata.rdf.internal.IV;
import com.bigdata.rdf.internal.constraints.IMathOpHandler;
import com.bigdata.rdf.internal.constraints.INeedsMaterialization;
import com.bigdata.rdf.internal.constraints.IVValueExpression;
import com.bigdata.rdf.model.BigdataValue;
import com.bigdata.rdf.model.BigdataValueFactory;
import com.bigdata.rdf.sparql.ast.GlobalAnnotations;
import java.util.Map;
import org.apache.log4j.Logger;
import org.openrdf.model.Literal;
import org.openrdf.query.algebra.MathExpr;

public final class MathBOp
extends IVValueExpression
implements INeedsMaterialization {
    private static final long serialVersionUID = 9136864442064392445L;
    private static final transient Logger log = Logger.getLogger(MathBOp.class);
    private int hash = 0;

    public MathBOp(IValueExpression<? extends IV> left, IValueExpression<? extends IV> right, MathOp op, GlobalAnnotations globals) {
        this(new BOp[]{left, right}, MathBOp.anns(globals, new NV(Annotations.OP, (Object)op)));
    }

    public MathBOp(BOp[] args, Map<String, Object> anns) {
        super(args, anns);
        if (args.length != 2 || args[0] == null || args[1] == null || this.getProperty(Annotations.OP) == null || this.getProperty(Annotations.NAMESPACE) == null) {
            throw new IllegalArgumentException();
        }
    }

    public MathBOp(MathBOp op) {
        super(op);
    }

    @Override
    public final IV get(IBindingSet bs) {
        IV iv1 = this.getAndCheckLiteral(0, bs);
        IV iv2 = this.getAndCheckLiteral(1, bs);
        if (log.isDebugEnabled()) {
            log.debug(this.toString(iv1.toString(), iv2.toString()));
        }
        Literal lit1 = MathBOp.asLiteral(iv1);
        Literal lit2 = MathBOp.asLiteral(iv2);
        ILexiconConfiguration<BigdataValue> lexicon = this.getLexiconConfiguration(bs);
        for (IMathOpHandler handler : lexicon.getTypeHandlers()) {
            if (!handler.canInvokeMathOp(lit1, lit2)) continue;
            IV iv = handler.doMathOp(lit1, iv1, lit2, iv2, this.op(), this.vf());
            if (iv.isNullIV()) {
                Object val = iv.getValue();
                return this.asIV((BigdataValue)val, bs);
            }
            return iv;
        }
        if (log.isDebugEnabled()) {
            log.debug("illegal argument(s), filtering solution: " + iv1 + ", " + iv2);
        }
        throw new SparqlTypeErrorException();
    }

    public IValueExpression<? extends IV> left() {
        return this.get(0);
    }

    public IValueExpression<? extends IV> right() {
        return this.get(1);
    }

    public MathOp op() {
        return (MathOp)((Object)this.getRequiredProperty(Annotations.OP));
    }

    public BigdataValueFactory vf() {
        return super.getValueFactory();
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append((Object)this.op());
        sb.append("(").append(this.left()).append(", ").append(this.right()).append(")");
        return sb.toString();
    }

    private String toString(String left, String right) {
        StringBuilder sb = new StringBuilder();
        sb.append((Object)this.op());
        sb.append("(").append(left).append(", ").append(right).append(")");
        return sb.toString();
    }

    public final boolean equals(MathBOp m) {
        if (m == null) {
            return false;
        }
        if (this == m) {
            return true;
        }
        return this.op().equals((Object)m.op()) && this.left().equals(m.left()) && this.right().equals(m.right());
    }

    public final boolean equals(IVValueExpression o) {
        if (!(o instanceof MathBOp)) {
            return false;
        }
        return this.equals((MathBOp)o);
    }

    @Override
    public int hashCode() {
        int h = this.hash;
        if (h == 0) {
            int n = this.arity();
            for (int i = 0; i < n; ++i) {
                h = 31 * h + this.get(i).hashCode();
            }
            this.hash = h = 31 * h + this.op().hashCode();
        }
        return h;
    }

    @Override
    public INeedsMaterialization.Requirement getRequirement() {
        return INeedsMaterialization.Requirement.SOMETIMES;
    }

    public static enum MathOp {
        PLUS,
        MINUS,
        MULTIPLY,
        DIVIDE,
        MIN,
        MAX,
        ROUND,
        CEIL,
        FLOOR;


        public static MathOp valueOf(MathExpr.MathOp op) {
            switch (op) {
                case PLUS: {
                    return PLUS;
                }
                case MINUS: {
                    return MINUS;
                }
                case MULTIPLY: {
                    return MULTIPLY;
                }
                case DIVIDE: {
                    return DIVIDE;
                }
            }
            throw new IllegalArgumentException();
        }
    }

    public static interface Annotations
    extends IVValueExpression.Annotations {
        public static final String OP = (MathBOp.class.getName() + ".op").intern();
    }
}

