/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.rdf.internal.constraints;

import com.bigdata.bop.BOp;
import com.bigdata.bop.IBindingSet;
import com.bigdata.bop.IConstant;
import com.bigdata.bop.IValueExpression;
import com.bigdata.bop.NV;
import com.bigdata.rdf.error.SparqlTypeErrorException;
import com.bigdata.rdf.internal.IV;
import com.bigdata.rdf.internal.constraints.INeedsMaterialization;
import com.bigdata.rdf.internal.constraints.IVValueExpression;
import com.bigdata.rdf.model.BigdataLiteral;
import com.bigdata.rdf.model.BigdataValueFactory;
import com.bigdata.rdf.sparql.ast.GlobalAnnotations;
import java.util.Map;
import java.util.regex.Pattern;
import org.apache.log4j.Logger;
import org.openrdf.model.Literal;
import org.openrdf.model.URI;
import org.openrdf.model.Value;
import org.openrdf.query.algebra.evaluation.ValueExprEvaluationException;
import org.openrdf.query.algebra.evaluation.util.QueryEvaluationUtil;

public class ReplaceBOp
extends IVValueExpression<IV>
implements INeedsMaterialization {
    private static final transient Logger log = Logger.getLogger(ReplaceBOp.class);

    private static Map<String, Object> anns(IValueExpression<? extends IV> pattern, IValueExpression<? extends IV> flags, GlobalAnnotations globals) {
        if (pattern instanceof IConstant && (flags == null || flags instanceof IConstant)) {
            IV farg;
            IV parg = (IV)((IConstant)pattern).get();
            IV iV = farg = flags != null ? (IV)((IConstant)flags).get() : null;
            if (parg.hasValue() && (farg == null || farg.hasValue())) {
                Object pargVal = parg.getValue();
                Value fargVal = farg != null ? (Value)farg.getValue() : null;
                return ReplaceBOp.anns(globals, new NV(Annotations.PATTERN, ReplaceBOp.getPattern(pargVal, fargVal)));
            }
        }
        return ReplaceBOp.anns(globals, new NV[0]);
    }

    public ReplaceBOp(IValueExpression<? extends IV> var, IValueExpression<? extends IV> pattern, IValueExpression<? extends IV> replacement, GlobalAnnotations globals) {
        this(new BOp[]{var, pattern, replacement}, ReplaceBOp.anns(pattern, null, globals));
    }

    public ReplaceBOp(IValueExpression<? extends IV> var, IValueExpression<? extends IV> pattern, IValueExpression<? extends IV> replacement, IValueExpression<? extends IV> flags, GlobalAnnotations globals) {
        this(new BOp[]{var, pattern, replacement, flags}, ReplaceBOp.anns(pattern, flags, globals));
    }

    public ReplaceBOp(BOp[] args, Map<String, Object> anns) {
        super(args, anns);
        if (args.length < 2 || args[0] == null || args[1] == null) {
            throw new IllegalArgumentException();
        }
    }

    public ReplaceBOp(ReplaceBOp op) {
        super(op);
    }

    @Override
    public INeedsMaterialization.Requirement getRequirement() {
        return INeedsMaterialization.Requirement.SOMETIMES;
    }

    @Override
    public IV get(IBindingSet bs) {
        Literal flags;
        Literal var = this.getAndCheckLiteralValue(0, bs);
        Literal pattern = this.getAndCheckLiteralValue(1, bs);
        Literal replacement = this.getAndCheckLiteralValue(2, bs);
        Literal literal = flags = this.arity() > 3 ? this.getAndCheckLiteralValue(3, bs) : null;
        if (log.isDebugEnabled()) {
            log.debug("var: " + var);
            log.debug("pattern: " + pattern);
            log.debug("replacement: " + replacement);
            log.debug("flags: " + flags);
        }
        try {
            BigdataLiteral l = this.evaluate(this.getValueFactory(), var, pattern, replacement, flags);
            return super.asIV(l, bs);
        }
        catch (ValueExprEvaluationException ex) {
            throw new SparqlTypeErrorException();
        }
    }

    public BigdataLiteral evaluate(BigdataValueFactory valueFactory, Value ... args) throws ValueExprEvaluationException {
        if (args.length < 3 || args.length > 4) {
            throw new ValueExprEvaluationException("Incorrect number of arguments for REPLACE: " + args.length);
        }
        try {
            Literal arg = (Literal)args[0];
            Literal pattern = (Literal)args[1];
            Literal replacement = (Literal)args[2];
            Literal flags = null;
            if (args.length == 4) {
                flags = (Literal)args[3];
            }
            if (!QueryEvaluationUtil.isStringLiteral(arg)) {
                throw new ValueExprEvaluationException("incompatible operand for REPLACE: " + arg);
            }
            if (!QueryEvaluationUtil.isSimpleLiteral(replacement)) {
                throw new ValueExprEvaluationException("incompatible operand for REPLACE: " + replacement);
            }
            String argString = arg.getLabel();
            String replacementString = replacement.getLabel();
            Pattern p = (Pattern)this.getProperty(Annotations.PATTERN);
            if (p == null) {
                p = ReplaceBOp.getPattern(pattern, flags);
            }
            String result = p.matcher(argString).replaceAll(replacementString);
            String lang = arg.getLanguage();
            URI dt = arg.getDatatype();
            if (lang != null) {
                return valueFactory.createLiteral(result, lang);
            }
            if (dt != null) {
                return valueFactory.createLiteral(result, dt);
            }
            return valueFactory.createLiteral(result);
        }
        catch (ClassCastException e) {
            throw new ValueExprEvaluationException("literal operands expected", e);
        }
    }

    private static Pattern getPattern(Value pattern, Value flags) throws IllegalArgumentException {
        if (!QueryEvaluationUtil.isSimpleLiteral(pattern)) {
            throw new IllegalArgumentException("incompatible operand for REPLACE: " + pattern);
        }
        String flagString = null;
        if (flags != null) {
            if (!QueryEvaluationUtil.isSimpleLiteral(flags)) {
                throw new IllegalArgumentException("incompatible operand for REPLACE: " + flags);
            }
            flagString = ((Literal)flags).getLabel();
        }
        String patternString = ((Literal)pattern).getLabel();
        int f = 0;
        if (flagString != null) {
            block9: for (char c : flagString.toCharArray()) {
                switch (c) {
                    case 's': {
                        f |= 0x20;
                        continue block9;
                    }
                    case 'm': {
                        f |= 8;
                        continue block9;
                    }
                    case 'i': {
                        f |= 2;
                        continue block9;
                    }
                    case 'x': {
                        f |= 4;
                        continue block9;
                    }
                    case 'd': {
                        f |= 1;
                        continue block9;
                    }
                    case 'u': {
                        f |= 0x40;
                        continue block9;
                    }
                    case 'q': {
                        f |= 0x10;
                        continue block9;
                    }
                    default: {
                        throw new IllegalArgumentException(flagString);
                    }
                }
            }
        }
        Pattern p = Pattern.compile(patternString, f);
        return p;
    }

    public static interface Annotations
    extends IVValueExpression.Annotations {
        public static final String PATTERN = ReplaceBOp.class.getName() + ".pattern";
    }
}

