/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.rdf.internal.constraints;

import com.bigdata.bop.BOp;
import com.bigdata.bop.IBindingSet;
import com.bigdata.bop.IValueExpression;
import com.bigdata.bop.NV;
import com.bigdata.rdf.error.SparqlTypeErrorException;
import com.bigdata.rdf.internal.IV;
import com.bigdata.rdf.internal.constraints.CompareBOp;
import com.bigdata.rdf.internal.constraints.INeedsMaterialization;
import com.bigdata.rdf.internal.constraints.IVValueExpression;
import com.bigdata.rdf.internal.constraints.XSDBooleanIVValueExpression;
import java.util.Map;
import org.openrdf.model.Literal;
import org.openrdf.model.URI;
import org.openrdf.model.Value;
import org.openrdf.query.algebra.Compare;

public class SameTermBOp
extends XSDBooleanIVValueExpression
implements INeedsMaterialization {
    private static final long serialVersionUID = 1L;

    public SameTermBOp(IValueExpression<? extends IV> left, IValueExpression<? extends IV> right) {
        this(left, right, Compare.CompareOp.EQ);
    }

    public SameTermBOp(IValueExpression<? extends IV> left, IValueExpression<? extends IV> right, Compare.CompareOp op) {
        this(new BOp[]{left, right}, NV.asMap(Annotations.OP, (Object)op));
    }

    public SameTermBOp(BOp[] args, Map<String, Object> anns) {
        super(args, anns);
        if (args.length != 2 || args[0] == null || args[1] == null) {
            throw new IllegalArgumentException();
        }
        Compare.CompareOp op = (Compare.CompareOp)((Object)this.getRequiredProperty(Annotations.OP));
        if (op != Compare.CompareOp.EQ && op != Compare.CompareOp.NE) {
            throw new IllegalArgumentException();
        }
    }

    public SameTermBOp(SameTermBOp op) {
        super(op);
    }

    @Override
    public INeedsMaterialization.Requirement getRequirement() {
        return INeedsMaterialization.Requirement.SOMETIMES;
    }

    @Override
    public boolean accept(IBindingSet bs) {
        IV left = (IV)this.get(0).get(bs);
        if (left == null) {
            throw new SparqlTypeErrorException();
        }
        IV right = (IV)this.get(1).get(bs);
        if (right == null) {
            throw new SparqlTypeErrorException();
        }
        Compare.CompareOp op = (Compare.CompareOp)((Object)this.getRequiredProperty(Annotations.OP));
        switch (op) {
            case EQ: {
                return SameTermBOp.compare(left, right);
            }
        }
        return !SameTermBOp.compare(left, right);
    }

    private static boolean compare(IV iv1, IV iv2) {
        if (iv1.isNullIV() || iv2.isNullIV()) {
            Value val1 = SameTermBOp.asValue(iv1);
            Value val2 = SameTermBOp.asValue(iv2);
            if (val1 instanceof URI && val2 instanceof URI) {
                return val1.stringValue().equals(val2.stringValue());
            }
            if (val1 instanceof Literal && val2 instanceof Literal) {
                Literal lit1 = (Literal)val1;
                Literal lit2 = (Literal)val2;
                return SameTermBOp.equals(lit1.getLabel(), lit2.getLabel()) && SameTermBOp.equals(lit1.getDatatype(), lit2.getDatatype()) && SameTermBOp.equals(lit1.getLanguage(), lit2.getLanguage());
            }
            return false;
        }
        return iv1.equals(iv2);
    }

    private static boolean equals(Object o1, Object o2) {
        if (o1 == null && o2 == null) {
            return true;
        }
        if (o1 == null || o2 == null) {
            return false;
        }
        return o1.equals(o2);
    }

    public static interface Annotations
    extends IVValueExpression.Annotations {
        public static final String OP = CompareBOp.Annotations.OP;
    }
}

