/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.rdf.internal.constraints;

import com.bigdata.bop.BOp;
import com.bigdata.bop.IBindingSet;
import com.bigdata.bop.IValueExpression;
import com.bigdata.bop.NV;
import com.bigdata.rdf.error.SparqlTypeErrorException;
import com.bigdata.rdf.internal.IV;
import com.bigdata.rdf.internal.XSD;
import com.bigdata.rdf.internal.constraints.INeedsMaterialization;
import com.bigdata.rdf.internal.constraints.IVValueExpression;
import com.bigdata.rdf.model.BigdataLiteral;
import com.bigdata.rdf.sparql.ast.GlobalAnnotations;
import java.util.Map;
import org.openrdf.model.Literal;
import org.openrdf.model.URI;

public class StrAfterBOp
extends IVValueExpression<IV>
implements INeedsMaterialization {
    private static final long serialVersionUID = -2786852247821202390L;

    public StrAfterBOp(IValueExpression<? extends IV> arg1, IValueExpression<? extends IV> arg2, GlobalAnnotations globals) {
        this(new BOp[]{arg1, arg2}, StrAfterBOp.anns(globals, new NV[0]));
    }

    public StrAfterBOp(BOp[] args, Map<String, Object> anns) {
        super(args, anns);
        if (args.length < 2 || args[0] == null || args[1] == null) {
            throw new IllegalArgumentException();
        }
    }

    public StrAfterBOp(StrAfterBOp op) {
        super(op);
    }

    @Override
    public INeedsMaterialization.Requirement getRequirement() {
        return INeedsMaterialization.Requirement.SOMETIMES;
    }

    @Override
    public IV get(IBindingSet bs) throws SparqlTypeErrorException {
        Literal arg1 = this.getAndCheckLiteralValue(0, bs);
        Literal arg2 = this.getAndCheckLiteralValue(1, bs);
        this.checkCompatibility(arg1, arg2);
        String s2 = arg2.getLabel();
        if (s2.isEmpty()) {
            return this.ret(arg1, arg1.getLabel(), bs);
        }
        String s1 = arg1.getLabel();
        int i = s1.indexOf(s2);
        if (i < 0) {
            return this.ret(arg1, null, bs);
        }
        if (i + s2.length() == s1.length()) {
            return this.ret(arg1, "", bs);
        }
        String val = s1.substring(i + s2.length());
        return this.ret(arg1, val, bs);
    }

    private IV ret(Literal arg1, String label, IBindingSet bs) {
        if (label == null) {
            BigdataLiteral str = this.getValueFactory().createLiteral("");
            return super.asIV(str, bs);
        }
        String lang = arg1.getLanguage();
        if (lang != null) {
            BigdataLiteral str = this.getValueFactory().createLiteral(label, lang);
            return super.asIV(str, bs);
        }
        URI dt = arg1.getDatatype();
        if (dt != null) {
            BigdataLiteral str = this.getValueFactory().createLiteral(label, dt);
            return super.asIV(str, bs);
        }
        BigdataLiteral str = this.getValueFactory().createLiteral(label);
        return super.asIV(str, bs);
    }

    private void checkCompatibility(Literal arg1, Literal arg2) throws SparqlTypeErrorException {
        this.checkLanguage(arg1, arg2);
        this.checkDatatype(arg1, arg2);
    }

    private void checkLanguage(Literal arg1, Literal arg2) throws SparqlTypeErrorException {
        String lang1 = arg1.getLanguage();
        String lang2 = arg2.getLanguage();
        if (lang1 == null && lang2 == null) {
            return;
        }
        if (lang1 != null && lang2 == null) {
            return;
        }
        if (lang1 == null && lang2 != null) {
            throw new SparqlTypeErrorException();
        }
        if (!lang1.equals(lang2)) {
            throw new SparqlTypeErrorException();
        }
    }

    private void checkDatatype(Literal arg1, Literal arg2) throws SparqlTypeErrorException {
        URI dt1 = arg1.getDatatype();
        URI dt2 = arg2.getDatatype();
        if (dt1 != null && !dt1.stringValue().equals(XSD.STRING.stringValue())) {
            throw new SparqlTypeErrorException();
        }
        if (dt2 != null && !dt2.stringValue().equals(XSD.STRING.stringValue())) {
            throw new SparqlTypeErrorException();
        }
    }
}

