/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.rdf.internal.constraints;

import com.bigdata.bop.BOp;
import com.bigdata.bop.IBindingSet;
import com.bigdata.bop.IValueExpression;
import com.bigdata.bop.NV;
import com.bigdata.rdf.error.SparqlTypeErrorException;
import com.bigdata.rdf.internal.IV;
import com.bigdata.rdf.internal.constraints.INeedsMaterialization;
import com.bigdata.rdf.internal.constraints.IVValueExpression;
import com.bigdata.rdf.model.BigdataLiteral;
import com.bigdata.rdf.sparql.ast.GlobalAnnotations;
import java.util.Map;
import org.openrdf.model.Literal;
import org.openrdf.model.URI;

public class SubstrBOp
extends IVValueExpression<IV>
implements INeedsMaterialization {
    private static final long serialVersionUID = -7022953617164154412L;

    public SubstrBOp(IValueExpression<? extends IV> x, IValueExpression<? extends IV> start, IValueExpression<? extends IV> length, GlobalAnnotations globals) {
        this(new BOp[]{x, start, length}, SubstrBOp.anns(globals, new NV[0]));
    }

    public SubstrBOp(BOp[] args, Map<String, Object> anns) {
        super(args, anns);
        if (args.length < 2 || args[0] == null || args[1] == null) {
            throw new IllegalArgumentException();
        }
    }

    public SubstrBOp(SubstrBOp op) {
        super(op);
    }

    @Override
    public INeedsMaterialization.Requirement getRequirement() {
        return INeedsMaterialization.Requirement.SOMETIMES;
    }

    @Override
    public IV get(IBindingSet bs) throws SparqlTypeErrorException {
        double start;
        double offset;
        Literal lit = this.getAndCheckLiteralValue(0, bs);
        String label = lit.getLabel();
        IV startArg = (IV)this.get(1).get(bs);
        double startDoubleValue = SubstrBOp.asLiteral(startArg).doubleValue();
        if (Double.isNaN(startDoubleValue)) {
            label = "";
        }
        double d = offset = (start = (double)Math.round(startDoubleValue)) <= 0.0 ? -start : -1.0;
        if (this.arity() > 2 && this.get(2) != null) {
            IV lengthArg = (IV)this.get(2).get(bs);
            double length = Math.round(SubstrBOp.asLiteral(lengthArg).doubleValue());
            label = label.substring(Math.min(label.length(), (int)(start + offset)), Math.min(label.length(), Math.max(0, (int)(start + length) - 1)));
        } else {
            label = label.substring(Math.max(0, (int)(start - 1.0)));
        }
        String lang = lit.getLanguage();
        URI dt = lit.getDatatype();
        if (lang != null) {
            BigdataLiteral str = this.getValueFactory().createLiteral(label, lang);
            return super.asIV(str, bs);
        }
        if (dt != null) {
            BigdataLiteral str = this.getValueFactory().createLiteral(label, dt);
            return super.asIV(str, bs);
        }
        BigdataLiteral str = this.getValueFactory().createLiteral(label);
        return super.asIV(str, bs);
    }
}

