/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.rdf.internal.constraints;

import com.bigdata.bop.BOp;
import com.bigdata.bop.BOpBase;
import com.bigdata.bop.IBindingSet;
import com.bigdata.bop.IConstraint;
import com.bigdata.rdf.internal.NotMaterializedException;
import com.bigdata.util.InnerCause;
import java.util.Map;
import org.apache.log4j.Logger;

public class TryBeforeMaterializationConstraint
extends BOpBase
implements IConstraint {
    private static final long serialVersionUID = -761919593813838105L;
    private static final transient Logger log = Logger.getLogger(TryBeforeMaterializationConstraint.class);

    public TryBeforeMaterializationConstraint(IConstraint x) {
        this(new BOp[]{x}, null);
    }

    public TryBeforeMaterializationConstraint(BOp[] args, Map<String, Object> anns) {
        super(args, anns);
        if (args.length != 1 || args[0] == null) {
            throw new IllegalArgumentException();
        }
    }

    public TryBeforeMaterializationConstraint(TryBeforeMaterializationConstraint op) {
        super(op);
    }

    @Override
    public boolean accept(IBindingSet bs) {
        IConstraint c = (IConstraint)this.get(0);
        try {
            if (log.isDebugEnabled()) {
                log.debug("about to attempt evaluation prior to materialization");
            }
            boolean accept = c.accept(bs);
            if (log.isDebugEnabled()) {
                log.debug("successfully evaluated constraint without materialization");
            }
            return accept;
        }
        catch (Throwable t) {
            if (InnerCause.isInnerCause(t, NotMaterializedException.class)) {
                if (log.isDebugEnabled()) {
                    log.debug("could not evaluate constraint without materialization");
                }
                return true;
            }
            throw new RuntimeException(t);
        }
    }
}

