/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.rdf.internal.constraints;

import com.bigdata.bop.BOp;
import com.bigdata.bop.IBindingSet;
import com.bigdata.bop.IValueExpression;
import com.bigdata.bop.NV;
import com.bigdata.rdf.error.SparqlTypeErrorException;
import com.bigdata.rdf.internal.IV;
import com.bigdata.rdf.internal.XSD;
import com.bigdata.rdf.internal.constraints.INeedsMaterialization;
import com.bigdata.rdf.internal.constraints.IVValueExpression;
import com.bigdata.rdf.model.BigdataLiteral;
import com.bigdata.rdf.model.BigdataValueFactory;
import com.bigdata.rdf.sparql.ast.GlobalAnnotations;
import java.util.Map;
import org.apache.log4j.Logger;
import org.openrdf.model.Literal;
import org.openrdf.model.Value;

public class XsdLongBOp
extends IVValueExpression<IV>
implements INeedsMaterialization {
    private static final long serialVersionUID = -8564789336767221003L;
    private static final transient Logger log = Logger.getLogger(XsdLongBOp.class);

    public XsdLongBOp(IValueExpression<? extends IV> x, GlobalAnnotations globals) {
        this(new BOp[]{x}, XsdLongBOp.anns(globals, new NV[0]));
    }

    public XsdLongBOp(BOp[] args, Map<String, Object> anns) {
        super(args, anns);
        if (args.length != 1 || args[0] == null) {
            throw new IllegalArgumentException();
        }
        if (this.getProperty(IVValueExpression.Annotations.NAMESPACE) == null) {
            throw new IllegalArgumentException();
        }
    }

    public XsdLongBOp(XsdLongBOp op) {
        super(op);
    }

    @Override
    public IV get(IBindingSet bs) {
        IV iv = this.getAndCheckBound(0, bs);
        if (log.isDebugEnabled()) {
            log.debug(iv);
        }
        Value val = XsdLongBOp.asValue(iv);
        if (log.isDebugEnabled()) {
            log.debug(val);
        }
        BigdataValueFactory vf = this.getValueFactory();
        try {
            if (val instanceof Literal) {
                Literal lit = (Literal)val;
                if (lit.getDatatype() != null && lit.getDatatype().equals(XSD.LONG)) {
                    return iv;
                }
                BigdataLiteral str = vf.createLiteral(Long.valueOf(lit.getLabel()));
                return super.asIV(str, bs);
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        throw new SparqlTypeErrorException();
    }

    @Override
    public INeedsMaterialization.Requirement getRequirement() {
        return INeedsMaterialization.Requirement.SOMETIMES;
    }
}

