/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.rdf.internal.encoder;

import com.bigdata.bop.Constant;
import com.bigdata.bop.IBindingSet;
import com.bigdata.bop.IConstant;
import com.bigdata.bop.IVariable;
import com.bigdata.bop.bindingSet.ListBindingSet;
import com.bigdata.btree.keys.ASCIIKeyBuilderFactory;
import com.bigdata.btree.keys.IKeyBuilder;
import com.bigdata.rdf.internal.IV;
import com.bigdata.rdf.internal.IVUtility;
import com.bigdata.rdf.internal.VTE;
import com.bigdata.rdf.internal.encoder.IBindingSetDecoder;
import com.bigdata.rdf.internal.encoder.IBindingSetEncoder;
import com.bigdata.rdf.internal.impl.AbstractInlineIV;
import com.bigdata.rdf.internal.impl.TermId;
import com.bigdata.rdf.internal.impl.bnode.FullyInlineUnicodeBNodeIV;
import com.bigdata.rdf.internal.impl.literal.FullyInlineTypedLiteralIV;
import com.bigdata.rdf.internal.impl.literal.MockedValueIV;
import com.bigdata.rdf.internal.impl.uri.FullyInlineURIIV;
import com.bigdata.rdf.model.BigdataBNodeImpl;
import com.bigdata.rdf.model.BigdataLiteralImpl;
import com.bigdata.rdf.model.BigdataURIImpl;
import com.bigdata.rdf.model.BigdataValue;
import com.bigdata.rdf.model.BigdataValueFactory;
import java.util.Iterator;
import java.util.LinkedHashSet;
import org.openrdf.model.URI;

public class IVBindingSetEncoder
implements IBindingSetEncoder,
IBindingSetDecoder {
    protected final BigdataValueFactory vf;
    protected final boolean filter;
    private final LinkedHashSet<IVariable<?>> schema;
    private final IKeyBuilder keyBuilder;

    public IVBindingSetEncoder(BigdataValueFactory vf, boolean filter) {
        this.vf = vf;
        this.filter = filter;
        this.schema = new LinkedHashSet();
        this.keyBuilder = new ASCIIKeyBuilderFactory(128).getKeyBuilder();
    }

    @Override
    public boolean isValueCache() {
        return false;
    }

    private void updateSchema(IBindingSet bset) {
        Iterator<IVariable> vitr = bset.vars();
        while (vitr.hasNext()) {
            this.schema.add(vitr.next());
        }
    }

    @Override
    public byte[] encodeSolution(IBindingSet bset) {
        return this.encodeSolution(bset, true);
    }

    @Override
    public byte[] encodeSolution(IBindingSet bset, boolean updateCache) {
        if (bset == null) {
            throw new IllegalArgumentException();
        }
        this.updateSchema(bset);
        this.keyBuilder.reset();
        int numBoundInBSet = bset.size();
        Iterator vitr = this.schema.iterator();
        while (vitr.hasNext() && numBoundInBSet > 0) {
            IVariable v = (IVariable)vitr.next();
            IConstant c = bset.get(v);
            if (c == null) {
                IVUtility.encode(this.keyBuilder, TermId.NullIV);
                continue;
            }
            IV iv = (IV)c.get();
            if (iv.isNullIV()) {
                AbstractInlineIV ivToEncode;
                Object val = iv.getValue();
                if (val instanceof BigdataURIImpl) {
                    ivToEncode = new FullyInlineURIIV((BigdataURIImpl)val);
                } else if (val instanceof BigdataLiteralImpl) {
                    BigdataLiteralImpl valAsLiteral = (BigdataLiteralImpl)val;
                    ivToEncode = new FullyInlineTypedLiteralIV(valAsLiteral.getLabel(), ((BigdataLiteralImpl)val).getLanguage(), ((BigdataLiteralImpl)val).getDatatype());
                } else if (val instanceof BigdataBNodeImpl) {
                    BigdataBNodeImpl valAsBNode = (BigdataBNodeImpl)val;
                    ivToEncode = new FullyInlineUnicodeBNodeIV(valAsBNode.getID());
                } else {
                    throw new IllegalArgumentException("Uncovered iv.getValue() type in encode.");
                }
                IVUtility.encode(this.keyBuilder, new MockedValueIV(ivToEncode));
            } else {
                IVUtility.encode(this.keyBuilder, iv);
                this.cacheSchemaAndValue(v, iv, updateCache);
            }
            --numBoundInBSet;
        }
        return this.keyBuilder.getKey();
    }

    void cacheSchemaAndValue(IVariable<?> v, IV<?, ?> iv, boolean updateCache) {
    }

    @Override
    public void flush() {
    }

    @Override
    public IBindingSet decodeSolution(byte[] val, int off, int len, boolean resolveCachedValues) {
        ListBindingSet bset = new ListBindingSet();
        IV[] ivs = IVUtility.decodeAll(val, off, len);
        int i = 0;
        for (IVariable iVariable : this.schema) {
            IV iv;
            if (i == ivs.length) break;
            if ((iv = ivs[i++]) == null) continue;
            if (iv instanceof MockedValueIV) {
                TermId<?> mockIv;
                BigdataValue value;
                MockedValueIV mvIv = (MockedValueIV)iv;
                IV<?, ?> innerIv = mvIv.getIV();
                if (innerIv instanceof FullyInlineURIIV) {
                    FullyInlineURIIV innerIvAsUri = (FullyInlineURIIV)innerIv;
                    URI inlineUri = innerIvAsUri.getInlineValue();
                    value = this.vf.createURI(inlineUri.stringValue());
                    mockIv = TermId.mockIV(VTE.URI);
                } else if (innerIv instanceof FullyInlineTypedLiteralIV) {
                    FullyInlineTypedLiteralIV innerIvAsLiteral = (FullyInlineTypedLiteralIV)innerIv;
                    value = this.vf.createLiteral(innerIvAsLiteral.getLabel(), innerIvAsLiteral.getDatatype(), innerIvAsLiteral.getLanguage());
                    mockIv = TermId.mockIV(VTE.LITERAL);
                } else if (innerIv instanceof FullyInlineUnicodeBNodeIV) {
                    FullyInlineUnicodeBNodeIV innerIvAsBNode = (FullyInlineUnicodeBNodeIV)innerIv;
                    value = this.vf.createBNode(innerIvAsBNode.getID());
                    mockIv = TermId.mockIV(VTE.BNODE);
                } else {
                    throw new IllegalArgumentException("Uncovered inner IV type in decode");
                }
                mockIv.setValue(value);
                value.setIV(mockIv);
                bset.set(iVariable, new Constant(mockIv));
                continue;
            }
            bset.set(iVariable, new Constant<IV>(iv));
        }
        if (resolveCachedValues) {
            this.resolveCachedValues(bset);
        }
        return bset;
    }

    @Override
    public void resolveCachedValues(IBindingSet bset) {
    }

    @Override
    public void release() {
        this.schema.clear();
    }
}

