/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.rdf.internal.encoder;

import com.bigdata.bop.Constant;
import com.bigdata.bop.IBindingSet;
import com.bigdata.bop.IConstant;
import com.bigdata.bop.IVariable;
import com.bigdata.bop.Var;
import com.bigdata.bop.bindingSet.ListBindingSet;
import com.bigdata.io.DataInputBuffer;
import com.bigdata.rdf.internal.IV;
import com.bigdata.rdf.internal.IVUtility;
import com.bigdata.rdf.internal.encoder.IBindingSetDecoder;
import com.bigdata.rdf.model.BigdataValue;
import com.bigdata.rdf.model.BigdataValueFactoryImpl;
import com.bigdata.rdf.model.BigdataValueSerializer;
import com.bigdata.util.BytesUtil;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;

public class IVSolutionSetDecoder
implements IBindingSetDecoder {
    private final LinkedHashSet<IVariable<?>> schema = new LinkedHashSet();
    private final ArrayList<IVariable<?>> schemaIndex = new ArrayList();
    private final Map<IV<?, ?>, BigdataValue> cache = new HashMap();
    private final StringBuilder tmp = new StringBuilder();
    private int nsolutions = 0;
    private int version = -1;
    private String namespace;
    private BigdataValueSerializer<BigdataValue> valueSer;

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(super.toString());
        sb.append("{namespace=" + this.namespace);
        sb.append(",schema=" + this.schema);
        sb.append(",cacheSize=" + this.cache.size());
        sb.append(",nsolutions=" + this.nsolutions);
        sb.append("}");
        return sb.toString();
    }

    @Override
    public IBindingSet decodeSolution(byte[] data, int off, int len, boolean resolveCachedValues) {
        DataInputBuffer in = new DataInputBuffer(data, off, len);
        return this.decodeSolution(in, resolveCachedValues);
    }

    public IBindingSet decodeSolution(DataInputBuffer in, boolean resolveCachedValues) {
        if (this.version == -1) {
            try {
                this.version = in.unpackInt();
                switch (this.version) {
                    case 0: {
                        break;
                    }
                    default: {
                        throw new RuntimeException("Unknown version: " + this.version);
                    }
                }
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        IBindingSet bset = this._decodeSolution(in, resolveCachedValues);
        ++this.nsolutions;
        return bset;
    }

    private IBindingSet _decodeSolution(DataInputBuffer in, boolean resolveCachedValuesIsIgnored) {
        byte[] data = in.getBuffer();
        int off = in.getOrigin();
        try {
            int i;
            long maxBitIndex;
            long bitIndex;
            int chksum;
            ListBindingSet bset = new ListBindingSet();
            int numBindings = in.unpackInt();
            if (numBindings == 0) {
                return bset;
            }
            int newVars = in.unpackInt();
            int newCached = in.unpackInt();
            if (newCached > 0 && numBindings == 0) {
                throw new RuntimeException();
            }
            if (newCached > 0 && this.namespace == null) {
                this.namespace = in.readUTF2();
                this.valueSer = BigdataValueFactoryImpl.getInstance(this.namespace).getValueSerializer();
            }
            for (int i2 = 0; i2 < newVars; ++i2) {
                Var var = Var.var(in.readUTF2());
                if (!this.schema.add(var)) {
                    throw new IllegalStateException("Already declared: " + var.getName());
                }
                this.schemaIndex.add(var);
            }
            int schemaSize = this.schema.size();
            int offsetVarBits = off + (int)in.position() << 3;
            int nbytesVarBits = numBindings == 0 ? 0 : BytesUtil.bitFlagByteLength(schemaSize);
            in.skipBytes(nbytesVarBits);
            int offsetCacheValueBits = off + (int)in.position() << 3;
            int nbytesCacheValueBits = newCached == 0 ? 0 : BytesUtil.bitFlagByteLength(numBindings);
            in.skipBytes(nbytesCacheValueBits);
            List ivs = newCached > 0 ? new ArrayList(numBindings) : Collections.emptyList();
            if (numBindings > 0) {
                chksum = 0;
                bitIndex = offsetVarBits;
                maxBitIndex = offsetCacheValueBits;
                int ivoff = (int)((long)off + in.position());
                for (i = 0; i < schemaSize && bitIndex < maxBitIndex; ++i) {
                    boolean isSet;
                    if (!(isSet = BytesUtil.getBit(data, bitIndex++))) continue;
                    ++chksum;
                    IVariable<?> var = this.schemaIndex.get(i);
                    IV iv = IVUtility.decodeFromOffset(data, ivoff, false);
                    bset.set(var, new Constant<IV>(iv));
                    if (newCached > 0) {
                        ivs.add(iv);
                    }
                    int byteLength = iv.byteLength();
                    ivoff += byteLength;
                    in.skipBytes(byteLength);
                }
                if (chksum != numBindings) {
                    throw new RuntimeException("Bad bit sum: chksum=" + chksum + ", expected=" + numBindings);
                }
            }
            if (newCached > 0) {
                chksum = 0;
                bitIndex = offsetCacheValueBits;
                maxBitIndex = bitIndex + (long)(nbytesCacheValueBits << 3);
                for (i = 0; i < numBindings && bitIndex < maxBitIndex; ++i) {
                    boolean isSet;
                    if (!(isSet = BytesUtil.getBit(data, bitIndex++))) continue;
                    ++chksum;
                    IV iv = (IV)ivs.get(i);
                    BigdataValue value = this.valueSer.deserialize(in, this.tmp);
                    if (!iv.isNullIV()) {
                        this.cache.put(iv, value);
                        continue;
                    }
                    iv.setValue(value);
                }
                if (chksum != newCached) {
                    throw new RuntimeException("Bad bit sum: chksum=" + chksum + ", expected=" + newCached);
                }
            }
            if (numBindings > 0) {
                this.resolveCachedValues(bset);
            }
            return bset;
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
    }

    @Override
    public void resolveCachedValues(IBindingSet bset) {
        Iterator<Map.Entry<IVariable, IConstant>> itr = bset.iterator();
        while (itr.hasNext()) {
            Map.Entry<IVariable, IConstant> e = itr.next();
            IConstant c = e.getValue();
            IV iv = (IV)c.get();
            BigdataValue val = this.cache.get(iv);
            if (val == null) continue;
            iv.setValue(val);
        }
    }

    @Override
    public void release() {
        this.cache.clear();
        this.schema.clear();
        this.schemaIndex.clear();
        this.tmp.setLength(0);
        this.version = -1;
        this.nsolutions = 0;
        this.namespace = null;
        this.valueSer = null;
    }

    @Override
    public boolean isValueCache() {
        return true;
    }
}

