/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.rdf.internal.encoder;

import com.bigdata.bop.IBindingSet;
import com.bigdata.bop.IConstant;
import com.bigdata.bop.IVariable;
import com.bigdata.btree.keys.ASCIIKeyBuilderFactory;
import com.bigdata.btree.keys.IKeyBuilder;
import com.bigdata.io.ByteArrayBuffer;
import com.bigdata.io.DataOutputBuffer;
import com.bigdata.rdf.internal.IV;
import com.bigdata.rdf.internal.IVUtility;
import com.bigdata.rdf.internal.encoder.IBindingSetEncoder;
import com.bigdata.rdf.model.BigdataValue;
import com.bigdata.rdf.model.BigdataValueFactoryImpl;
import com.bigdata.rdf.model.BigdataValueSerializer;
import com.bigdata.util.BytesUtil;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.Map;
import org.apache.log4j.Logger;

public class IVSolutionSetEncoder
implements IBindingSetEncoder {
    private static final Logger log = Logger.getLogger(IVSolutionSetEncoder.class);
    private final LinkedHashSet<IVariable<?>> schema = new LinkedHashSet();
    private final Map<IV<?, ?>, BigdataValue> cache = new HashMap();
    private final IKeyBuilder keyBuilder = new ASCIIKeyBuilderFactory(128).getKeyBuilder();
    private final DataOutputBuffer out = new DataOutputBuffer();
    private final ByteArrayBuffer tmp = new ByteArrayBuffer();
    static final int VERSION0 = 0;
    private final int version = 0;
    private int nsolutions = 0;
    private String namespace;
    private BigdataValueSerializer<BigdataValue> valueSer;

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(super.toString());
        sb.append("{namespace=" + this.namespace);
        sb.append(",schema=" + this.schema);
        sb.append(",cacheSize=" + this.cache.size());
        sb.append(",nsolutions=" + this.nsolutions);
        sb.append("}");
        return sb.toString();
    }

    public void encodeSolution(DataOutputBuffer out, IBindingSet bset) {
        out.append(this.encodeSolution(bset));
    }

    @Override
    public byte[] encodeSolution(IBindingSet bset) {
        return this.encodeSolution(bset, true);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public byte[] encodeSolution(IBindingSet bset, boolean updateCacheIsIgnored) {
        if (bset == null) {
            throw new IllegalArgumentException();
        }
        boolean trace = log.isTraceEnabled();
        this.keyBuilder.reset();
        this.out.reset();
        if (0 == this.nsolutions++) {
            this.out.packLong(0L);
        }
        LinkedList<IVariable> newVars = new LinkedList<IVariable>();
        Iterator<Map.Entry<IVariable, IConstant>> itr = bset.iterator();
        while (itr.hasNext()) {
            IVariable v = itr.next().getKey();
            if (!this.schema.add(v)) continue;
            newVars.add(v);
        }
        LinkedList values = new LinkedList();
        int numBindings = 0;
        int newCached = 0;
        boolean discoveredNamespace = false;
        for (IVariable iVariable : this.schema) {
            IConstant c = bset.get(iVariable);
            if (c == null) continue;
            IV iV = (IV)c.get();
            IVUtility.encode(this.keyBuilder, iV);
            if (iV.hasValue() && (iV.isNullIV() || !this.cache.containsKey(iV))) {
                Object value = iV.getValue();
                if (this.namespace == null) {
                    this.namespace = value.getValueFactory().getNamespace();
                    this.valueSer = BigdataValueFactoryImpl.getInstance(this.namespace).getValueSerializer();
                    discoveredNamespace = true;
                }
                if (!iV.isNullIV()) {
                    this.cache.put(iV, (BigdataValue)value);
                }
                values.add(value);
                ++newCached;
            } else {
                values.add(null);
            }
            ++numBindings;
        }
        this.out.packLong(numBindings);
        if (numBindings == 0) {
            return this.out.toByteArray();
        }
        this.out.packLong(newVars.size());
        this.out.packLong(newCached);
        if (discoveredNamespace) {
            this.out.writeUTF2(this.namespace);
        }
        if (trace) {
            log.trace("schemaSize=" + this.schema.size() + ", cacheSize=" + this.cache.size() + ", namespace=" + this.namespace);
            log.trace("newVars=" + newVars.size() + ", numBindings=" + numBindings + ", newCached=" + newCached);
        }
        for (IVariable iVariable : newVars) {
            this.out.writeUTF2(iVariable.getName());
        }
        if (numBindings > 0) {
            int nbytes = BytesUtil.bitFlagByteLength(this.schema.size());
            int n = this.out.pos() << 3;
            if (trace) {
                log.trace("varbitmap: beginBitOffset=" + n + ", nbytes=" + nbytes);
            }
            this.out.ensureFree(nbytes);
            for (int i = 0; i < nbytes; ++i) {
                this.out.append((byte)0);
            }
            for (IVariable iVariable : this.schema) {
                void var10_18;
                if (bset.isBound(iVariable)) {
                    BytesUtil.setBit(this.out.array(), (long)var10_18, true);
                }
                ++var10_18;
            }
        }
        if (newCached > 0) {
            int nbytes = BytesUtil.bitFlagByteLength(numBindings);
            int n = this.out.pos() << 3;
            this.out.ensureFree(nbytes);
            for (int i = 0; i < nbytes; ++i) {
                this.out.append((byte)0);
            }
            if (trace) {
                log.trace("cachebitmap: beginBitOffset=" + n + ", nbytes=" + nbytes);
            }
            for (BigdataValue bigdataValue : values) {
                void var10_20;
                if (bigdataValue != null) {
                    BytesUtil.setBit(this.out.array(), (long)var10_20, true);
                }
                ++var10_20;
            }
        }
        if (trace) {
            log.trace("IV[]: off=" + this.out.pos() + ", numBindings=" + numBindings + ", byteLength=" + this.keyBuilder.len());
        }
        this.out.append(this.keyBuilder.array(), 0, this.keyBuilder.len());
        if (newCached > 0) {
            if (trace) {
                log.trace("cache[]: off=" + this.out.pos() + ", newCached=" + newCached);
            }
            for (BigdataValue bigdataValue : values) {
                if (bigdataValue == null) continue;
                this.valueSer.serialize2(bigdataValue, this.out, this.tmp);
            }
        }
        if (trace) {
            log.trace("done: off=" + this.out.pos());
        }
        return this.out.toByteArray();
    }

    @Override
    public void release() {
        this.cache.clear();
        this.schema.clear();
        this.out.clear();
        this.tmp.clear();
        this.nsolutions = 0;
    }

    @Override
    public void flush() {
    }

    @Override
    public boolean isValueCache() {
        return true;
    }
}

