/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.rdf.internal.impl;

import com.bigdata.btree.keys.IKeyBuilder;
import com.bigdata.rdf.internal.DTE;
import com.bigdata.rdf.internal.IV;
import com.bigdata.rdf.internal.NotMaterializedException;
import com.bigdata.rdf.internal.VTE;
import com.bigdata.rdf.internal.impl.AbstractNonInlineIV;
import com.bigdata.rdf.internal.impl.literal.NumericIV;
import com.bigdata.rdf.model.BigdataLiteral;
import com.bigdata.rdf.model.BigdataValue;

public class TermId<V extends BigdataValue>
extends AbstractNonInlineIV<V, Void> {
    private static final long serialVersionUID = 4309045651680610931L;
    public static final transient long NULL = 0L;
    private final long termId;
    public static final transient TermId<?> NullIV = TermId.mockIV(VTE.URI);

    @Override
    public final boolean isNullIV() {
        return this.termId == 0L;
    }

    public static TermId<?> mockIV(VTE vte) {
        return new TermId(vte, 0L);
    }

    @Override
    public IV<V, Void> clone(boolean clearCache) {
        TermId tmp = new TermId(this.flags, this.termId);
        if (!clearCache) {
            tmp.setValue(this.getValueCache());
        }
        return tmp;
    }

    public TermId(byte flags, long termId) {
        super(flags);
        this.termId = termId;
    }

    public TermId(VTE vte, long termId) {
        super(vte, false, DTE.XSDBoolean);
        this.termId = termId;
    }

    @Override
    public String toString() {
        return "TermId(" + this.termId + String.valueOf(this.getVTE().getCharCode()) + ")" + (this.hasValue() ? "[" + this.getValue().stringValue() + "]" : "");
    }

    public static TermId<?> fromString(String s) {
        int pos = s.indexOf("[");
        int end = (pos > 0 ? pos : s.length()) - 2;
        long tid = Long.valueOf(s.substring(7, end));
        char type = s.charAt(end);
        TermId tmp = new TermId(VTE.valueOf(type), tid);
        return tmp;
    }

    public final long getTermId() {
        return this.termId;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o instanceof TermId) {
            TermId t = (TermId)o;
            if (this.termId == 0L || t.termId == 0L) {
                if (this.hasValue() && t.hasValue()) {
                    return this.getValue().equals(t.getValue());
                }
                return false;
            }
            return this.termId == t.termId;
        }
        return false;
    }

    @Override
    public int hashCode() {
        return (int)(this.termId ^ this.termId >>> 32);
    }

    @Override
    public int byteLength() {
        return 9;
    }

    @Override
    public int _compareTo(IV o) {
        long termId2 = ((TermId)o).termId;
        return this.termId < termId2 ? -1 : (this.termId > termId2 ? 1 : 0);
    }

    @Override
    public IKeyBuilder encode(IKeyBuilder keyBuilder) {
        keyBuilder.appendSigned(this.flags());
        keyBuilder.append(this.termId);
        return keyBuilder;
    }

    @Override
    public String getID() {
        return Long.toString(this.termId);
    }

    @Override
    public boolean isNumeric() {
        Object value = this.getValue();
        if (value == null) {
            throw new NotMaterializedException();
        }
        if (!(value instanceof BigdataLiteral)) {
            return false;
        }
        return NumericIV.numericalDatatypes.contains(((BigdataLiteral)value).getDatatype());
    }
}

