/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.rdf.internal.impl.bnode;

import com.bigdata.btree.keys.IKeyBuilder;
import com.bigdata.btree.keys.KeyBuilder;
import com.bigdata.io.LongPacker;
import com.bigdata.rdf.internal.DTE;
import com.bigdata.rdf.internal.IV;
import com.bigdata.rdf.internal.IVUtility;
import com.bigdata.rdf.internal.VTE;
import com.bigdata.rdf.internal.impl.AbstractIV;
import com.bigdata.rdf.internal.impl.AbstractInlineIV;
import com.bigdata.rdf.lexicon.LexiconRelation;
import com.bigdata.rdf.model.BigdataBNode;
import com.bigdata.rdf.model.BigdataResource;
import com.bigdata.rdf.model.BigdataURI;
import com.bigdata.rdf.model.StatementEnum;
import com.bigdata.rdf.spo.ISPO;
import com.bigdata.rdf.spo.SPO;
import com.bigdata.rdf.spo.SPOComparator;
import com.bigdata.rdf.spo.SPOKeyOrder;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.ObjectStreamException;
import java.io.Serializable;
import java.math.BigInteger;
import org.openrdf.model.BNode;
import org.openrdf.model.Value;

public class SidIV<V extends BigdataBNode>
extends AbstractInlineIV<V, ISPO>
implements Serializable,
BNode {
    private static final long serialVersionUID = 685148537376856907L;
    private final ISPO spo;
    private transient byte[] key;
    private transient V bnode;

    @Override
    public IV<V, ISPO> clone(boolean clearCache) {
        SidIV tmp = new SidIV(this.spo);
        tmp.key = this.key;
        tmp.bnode = this.bnode;
        if (!clearCache) {
            tmp.setValue(this.getValueCache());
        }
        return tmp;
    }

    public SidIV(ISPO spo) {
        super(VTE.STATEMENT, DTE.XSDBoolean);
        this.spo = spo;
    }

    public static final byte toFlags() {
        return AbstractIV.toFlags(VTE.STATEMENT, true, false, DTE.XSDBoolean);
    }

    @Override
    public ISPO getInlineValue() throws UnsupportedOperationException {
        return this.spo;
    }

    @Override
    public V asValue(LexiconRelation lex) {
        if (this.bnode == null) {
            this.bnode = lex.getValueFactory().createBNode(this.getID());
            this.bnode.setIV(this);
            this.bnode.setStatementIdentifier(true);
            BigdataResource c = this.spo.c() != null ? (BigdataResource)this.spo.c().asValue(lex) : null;
            this.bnode.setStatement(lex.getValueFactory().createStatement((BigdataResource)this.spo.s().asValue(lex), (BigdataURI)this.spo.p().asValue(lex), (Value)this.spo.o().asValue(lex), c));
        }
        return this.bnode;
    }

    @Override
    public int byteLength() {
        return 1 + this.key().length;
    }

    public String toString() {
        return "Sid(" + SidIV.toString(this.spo) + ")";
    }

    private static String toString(ISPO spo) {
        return SPO.toString(spo.s()) + ":" + SPO.toString(spo.p()) + ":" + SPO.toString(spo.o());
    }

    @Override
    public int hashCode() {
        return this.spo.hashCode();
    }

    @Override
    public String getID() {
        byte[] key = this.key();
        int signum = key.length > 0 ? 1 : 0;
        BigInteger bi = new BigInteger(signum, key);
        return 's' + bi.toString();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o instanceof SidIV) {
            ISPO stmt2 = ((SidIV)o).spo;
            return IVUtility.equals(this.spo.s(), stmt2.s()) && IVUtility.equals(this.spo.p(), stmt2.p()) && IVUtility.equals(this.spo.o(), stmt2.o());
        }
        return false;
    }

    @Override
    public int _compareTo(IV o) {
        ISPO spo2 = ((SidIV)o).spo;
        return SPOComparator.INSTANCE.compare(this.spo, spo2);
    }

    @Override
    public IKeyBuilder encode(IKeyBuilder keyBuilder) {
        keyBuilder.appendSigned(this.flags());
        keyBuilder.append(this.key());
        return keyBuilder;
    }

    private byte[] key() {
        if (this.key == null) {
            KeyBuilder keyBuilder = new KeyBuilder(64);
            this.key = SPOKeyOrder.SPO.encodeKey(keyBuilder, this.spo);
        }
        return this.key;
    }

    private Object writeReplace() throws ObjectStreamException {
        return new SidIVState(this);
    }

    @Override
    public String stringValue() {
        return this.getID();
    }

    @Override
    public boolean needsMaterialization() {
        return false;
    }

    private static class SidIVState
    implements Externalizable {
        private static final long serialVersionUID = -1L;
        private byte[] key;

        public SidIVState() {
        }

        private SidIVState(SidIV iv) {
            this.key = iv.key();
        }

        @Override
        public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
            int nbytes = LongPacker.unpackInt(in);
            this.key = new byte[nbytes];
            in.readFully(this.key);
        }

        @Override
        public void writeExternal(ObjectOutput out) throws IOException {
            LongPacker.packLong(out, (long)this.key.length);
            out.write(this.key);
        }

        private Object readResolve() throws ObjectStreamException {
            SPO spo = SPOKeyOrder.SPO.decodeKey(this.key);
            spo.setStatementType(StatementEnum.Explicit);
            return new SidIV(spo);
        }
    }
}

